/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.contraptions.blazeStove;

import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveBlockEntity;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveGuide;

public abstract class BlazeStoveGuideMenu<G extends BlazeStoveGuide>
extends GhostItemMenu<ItemStack> {
    protected G guide;
    @Nullable
    protected BlazeStoveBlockEntity blazeStove;
    protected int inputSize;

    public BlazeStoveGuideMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public BlazeStoveGuideMenu(MenuType<?> type, int id, Inventory inv, ItemStack cookingGuide) {
        super(type, id, inv, (Object)cookingGuide);
    }

    public BlazeStoveGuideMenu(MenuType<?> type, int id, Inventory inv, BlazeStoveBlockEntity blazeStove) {
        super(type, id, inv, (Object)blazeStove.getGuide());
        this.blazeStove = blazeStove;
    }

    public abstract G createGuide(ItemStack var1);

    public void updateRecipe() {
        ((BlazeStoveGuide)this.guide).updateRecipe(this.player.m_9236_());
        this.m_38853_(((BlazeStoveGuide)this.guide).getIngredientSize()).m_6654_();
    }

    public int getInputSize() {
        return this.inputSize;
    }

    public int getBlazeStatus() {
        return this.blazeStove == null ? 0 : this.blazeStove.getBlazeStatusCode();
    }

    public ItemStack getContainerItem() {
        return ((BlazeStoveGuide)this.guide).container;
    }

    public CompoundTag writeGuideToTag() {
        return ((BlazeStoveGuide)this.guide).serializeNBT();
    }

    public void updateGuideFromTag(CompoundTag tag) {
        ((BlazeStoveGuide)this.guide).deserializeNBT(tag);
    }

    protected void init(Inventory inv, ItemStack contentHolderIn) {
        super.init(inv, (Object)contentHolderIn);
        this.updateRecipe();
    }

    protected ItemStackHandler createGhostInventory() {
        return ((BlazeStoveGuide)this.guide).inventory;
    }

    protected void initAndReadInventory(ItemStack contentHolder) {
        this.guide = this.createGuide(contentHolder);
        this.inputSize = ((BlazeStoveGuide)this.guide).inventory.getSlots() - 1;
        super.initAndReadInventory((Object)contentHolder);
    }

    protected ItemStack createOnClient(FriendlyByteBuf extraData) {
        ItemStack item = extraData.m_130267_();
        boolean fromItemStack = extraData.readBoolean();
        if (!fromItemStack) {
            BlockPos pos = extraData.m_130135_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            assert (level != null);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BlazeStoveBlockEntity) {
                BlazeStoveBlockEntity blazeStove;
                this.blazeStove = blazeStove = (BlazeStoveBlockEntity)blockEntity;
            } else {
                throw new RuntimeException("Expected Blaze Stove at " + pos + " but found none");
            }
        }
        return item;
    }

    protected void saveData(ItemStack contentHolder) {
    }

    public boolean m_6875_(Player player) {
        return super.m_6875_(player) && (this.blazeStove == null || this.blazeStove.stillValid(player));
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (this.blazeStove != null) {
            this.blazeStove.notifyUpdate();
        } else {
            playerIn.m_36335_().m_41524_(((BlazeStoveGuide)this.guide).getOwner().m_41720_(), 5);
        }
    }

    protected boolean allowRepeats() {
        return true;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == 36 + this.inputSize) {
            return;
        }
        if (slotId < 36) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
            return;
        }
        if (clickTypeIn == ClickType.THROW) {
            return;
        }
        ItemStack held = this.m_142621_().m_41777_();
        held.m_41764_(1);
        if (clickTypeIn == ClickType.CLONE) {
            if (player.m_7500_() && held.m_41619_()) {
                ItemStack cloned = this.ghostInventory.getStackInSlot(slotId - 36).m_41777_();
                cloned.m_41764_(cloned.m_41741_());
                this.m_142503_(cloned);
            }
        } else if (this.m_38853_(slotId).m_5857_(held) || held.m_41619_()) {
            this.ghostInventory.setStackInSlot(slotId - 36, held.m_41777_());
            this.m_38853_(slotId).m_6654_();
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.m_8020_(index).m_41777_();
            stackToInsert.m_41764_(1);
            for (int i = 36; i < 36 + this.inputSize; ++i) {
                if (!this.m_38853_(i).m_5857_(stackToInsert)) continue;
                this.ghostInventory.insertItem(i - 36, stackToInsert, false);
                this.m_38853_(i).m_6654_();
                break;
            }
        } else if (index < 36 + this.inputSize) {
            this.ghostInventory.extractItem(0, 1, false);
            this.m_38853_(index).m_6654_();
        }
        return ItemStack.f_41583_;
    }

    protected class DisplaySlot
    extends SlotItemHandler {
        public DisplaySlot(int index, int xPosition, int yPosition) {
            super((IItemHandler)BlazeStoveGuideMenu.this.ghostInventory, index, xPosition, yPosition);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }

    protected class CookingIngredientSlot
    extends SlotItemHandler {
        public CookingIngredientSlot(int index, int xPosition, int yPosition) {
            super((IItemHandler)BlazeStoveGuideMenu.this.ghostInventory, index, xPosition, yPosition);
        }

        public int m_6641_() {
            return super.m_6641_();
        }

        public void m_6654_() {
            super.m_6654_();
            BlazeStoveGuideMenu.this.updateRecipe();
        }
    }
}

