/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.data.recipe.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import plus.dragons.createcentralkitchen.foundation.data.recipe.builder.ConditionedRecipeBuilder;

public class ConditionedShapedRecipeBuilder
implements RecipeBuilder,
ConditionedRecipeBuilder<ConditionedShapedRecipeBuilder> {
    private final ResourceLocation id;
    private Item result;
    private int count = 1;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group = null;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    public ConditionedShapedRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public ConditionedShapedRecipeBuilder define(Character symbol, TagKey<Item> tag) {
        return this.define(symbol, Ingredient.m_204132_(tag));
    }

    public ConditionedShapedRecipeBuilder define(Character symbol, ItemLike item) {
        return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ConditionedShapedRecipeBuilder define(Character symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredient);
        return this;
    }

    public ConditionedShapedRecipeBuilder pattern(String pPattern) {
        if (!this.rows.isEmpty() && pPattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pPattern);
        return this;
    }

    public ConditionedShapedRecipeBuilder output(ItemLike item, int count) {
        this.result = item.m_5456_();
        this.count = count;
        return this;
    }

    public ConditionedShapedRecipeBuilder output(ItemLike item) {
        return this.output(item, 1);
    }

    @Override
    public ConditionedShapedRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public ConditionedShapedRecipeBuilder unlockedBy(String criterionName, CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(criterionName, trigger);
        return this;
    }

    public ConditionedShapedRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    @Override
    public void m_176498_(Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, this.id);
    }

    @Override
    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        id = new ResourceLocation(id.m_135827_(), "crafting/" + id.m_135815_());
        this.ensureValid(id);
        if (!this.advancement.m_138405_().isEmpty()) {
            this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        }
        consumer.accept((FinishedRecipe)new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.rows, this.key, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_()), this.conditions));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.result == null) {
            throw new IllegalStateException("No result is defined for shaped recipe " + id + "!");
        }
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public static class Result
    extends ShapedRecipeBuilder.Result {
        private final boolean serializeAdvancement;
        private final List<ICondition> conditions;

        public Result(ResourceLocation id, Item result, int count, String group, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advancement, ResourceLocation advancementId, List<ICondition> conditions) {
            super(id, result, count, group, CraftingBookCategory.MISC, pattern, key, advancement, advancementId, false);
            this.serializeAdvancement = !advancement.m_138405_().isEmpty() && conditions.isEmpty();
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            if (!this.conditions.isEmpty()) {
                JsonArray conds = new JsonArray();
                this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
                json.add("conditions", (JsonElement)conds);
            }
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.serializeAdvancement ? super.m_5860_() : null;
        }
    }
}

