/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.model;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadsTransformer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public class CauldronBakedModel
implements CustomBakedModel {
    private static final boolean SINGLE_PASS = PlatHelper.getPlatform().isFabric();
    private final BakedModel cauldron;
    private final BakedModel fluid;
    private final ModelState transform;
    private final boolean hasTranslucent;

    public CauldronBakedModel(BakedModel c, BakedModel fluid, ModelState transform, boolean translucent) {
        this.cauldron = c;
        this.fluid = fluid;
        this.transform = transform;
        this.hasTranslucent = translucent && !SINGLE_PASS;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction direction, RandomSource randomSource, RenderType renderType, ExtraModelData extraModelData) {
        boolean isTranslucentLayer;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        boolean bl = isTranslucentLayer = renderType == RenderType.m_110466_();
        if (!this.hasTranslucent || !isTranslucentLayer) {
            quads.addAll(this.cauldron.m_213637_(state, direction, randomSource));
        }
        if (!this.hasTranslucent || isTranslucentLayer) {
            List liquidQuads = this.fluid.m_213637_(state, direction, randomSource);
            SoftFluid fluid = (SoftFluid)extraModelData.get(LiquidCauldronBlockTile.FLUID);
            Boolean glowing = (Boolean)extraModelData.get(LiquidCauldronBlockTile.GLOWING);
            if (glowing == null) {
                glowing = false;
            }
            BakedQuadsTransformer transformer = BakedQuadsTransformer.create();
            if (fluid != null && !fluid.isEmptyFluid()) {
                ResourceLocation stillTexture = fluid.getStillTexture();
                if (ClientConfigs.POTION_TEXTURE.get().booleanValue() && fluid == BuiltInSoftFluids.POTION.get()) {
                    stillTexture = AmendmentsClient.POTION_TEXTURE;
                } else if (fluid == BuiltInSoftFluids.MUSHROOM_STEW.get()) {
                    stillTexture = AmendmentsClient.MUSHROOM_STEW;
                } else if (fluid == BuiltInSoftFluids.BEETROOT_SOUP.get()) {
                    stillTexture = AmendmentsClient.BEETROOT_SOUP;
                } else if (fluid == BuiltInSoftFluids.RABBIT_STEW.get()) {
                    stillTexture = AmendmentsClient.RABBIT_STEW;
                } else if (fluid == BuiltInSoftFluids.SUS_STEW.get()) {
                    stillTexture = AmendmentsClient.SUS_STEW;
                }
                TextureAtlasSprite sprite = ClientHelper.getBlockMaterial((ResourceLocation)stillTexture).m_119204_();
                transformer.applyingAmbientOcclusion(false).applyingEmissivity(Math.max(glowing != false ? 14 : 0, fluid.getEmissivity())).applyingSprite(sprite);
                quads.addAll(transformer.transformAll(liquidQuads));
            } else if (!(state.m_60734_() instanceof ModCauldronBlock)) {
                transformer.applyingAmbientOcclusion(false);
                quads.addAll(transformer.transformAll(liquidQuads));
            }
        }
        return quads;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData extraModelData) {
        return this.cauldron.m_6160_();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

