/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.List;
import net.mehvahdjukaar.amendments.common.network.ClientBoundEntityHitSwayingBlockMessage;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.common.tile.SwayingBlockTile;
import net.mehvahdjukaar.amendments.common.tile.WallLanternBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.integration.SuppSquaredCompat;
import net.mehvahdjukaar.amendments.integration.ThinAirCompat;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WallLanternBlock
extends WaterBlock
implements EntityBlock {
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.0, (double)2.0, (double)6.0, (double)11.0, (double)15.99, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    public static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    public static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<ModBlockProperties.BlockAttachment> ATTACHMENT = ModBlockProperties.BLOCK_ATTACHMENT;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;

    public WallLanternBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(s -> (Boolean)s.m_61143_((Property)LIT) != false ? (Integer)s.m_61143_((Property)LIGHT_LEVEL) : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(15))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        WallLanternBlockTile te;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof WallLanternBlockTile && (te = (WallLanternBlockTile)blockEntity).isAccessibleBy(pPlayer)) {
            InteractionResult res;
            BlockState lantern = te.getHeldBlock();
            if (CompatHandler.SUPPSQUARED && (res = SuppSquaredCompat.lightUpLantern(pLevel, pPos, pPlayer, pHand, te, lantern)) != null) {
                return res;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43719_().m_122434_() == Direction.Axis.Y) {
            return null;
        }
        BlockState state = super.m_5573_(context);
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        Direction dir = context.m_43719_();
        BlockPos relative = blockpos.m_121945_(dir.m_122424_());
        BlockState facingState = world.m_8055_(relative);
        return (BlockState)WallLanternBlock.getConnectedState(state, facingState, (LevelAccessor)world, relative, dir).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity te = world.m_7702_(pos);
        Item i = stack.m_41720_();
        if (te instanceof WallLanternBlockTile) {
            WallLanternBlockTile blockHolder = (WallLanternBlockTile)te;
            if (i instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)i;
                blockHolder.setHeldBlock(blockItem.m_40614_().m_49966_());
            }
        }
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.addOptionalOwnership(world, pos, entity);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing == ((Direction)stateIn.m_61143_((Property)FACING)).m_122424_() ? (!stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : WallLanternBlock.getConnectedState(stateIn, facingState, worldIn, facingPos, facing)) : stateIn;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        return ModBlockProperties.BlockAttachment.get(blockstate, blockpos, level, direction) != null;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static BlockState getConnectedState(BlockState state, BlockState facingState, LevelAccessor world, BlockPos pos, Direction dir) {
        ModBlockProperties.BlockAttachment attachment = ModBlockProperties.BlockAttachment.get(facingState, pos, (LevelReader)world, dir);
        if (attachment == null) {
            return state;
        }
        return (BlockState)state.m_61124_(ATTACHMENT, (Comparable)((Object)attachment));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPE_SOUTH;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            WallLanternBlockTile te = (WallLanternBlockTile)blockEntity;
            return new ItemStack((ItemLike)te.getHeldBlock().m_60734_());
        }
        return new ItemStack((ItemLike)Blocks.f_50681_, 1);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIGHT_LEVEL, LIT, FACING, ATTACHMENT});
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        super.m_213897_(state, level, pos, rand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            BlockState lantern;
            WallLanternBlockTile te = (WallLanternBlockTile)blockEntity;
            if (te.isRedstoneLantern() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !level.m_276867_(pos)) {
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
                if (te.getHeldBlock().m_61138_((Property)LIT)) {
                    te.setHeldBlock((BlockState)te.getHeldBlock().m_61122_((Property)LIT));
                }
            }
            if (CompatHandler.THIN_AIR && ThinAirCompat.isAirLantern(lantern = te.getHeldBlock())) {
                te.setHeldBlock(lantern);
                if (te.getHeldBlock() != lantern) {
                    level.m_7260_(pos, state, state, 3);
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        boolean flag;
        WallLanternBlockTile tile;
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof WallLanternBlockTile && (tile = (WallLanternBlockTile)blockEntity).isRedstoneLantern() && (flag = ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) != world.m_276867_(pos)) {
            if (flag) {
                world.m_186460_(pos, (Block)this, 4);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
                if (tile.getHeldBlock().m_61138_((Property)LIT)) {
                    tile.setHeldBlock((BlockState)tile.getHeldBlock().m_61122_((Property)LIT));
                }
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof WallLanternBlockTile) {
            WallLanternBlockTile tile = (WallLanternBlockTile)object;
            return tile.getHeldBlock().m_287290_(builder);
        }
        return super.m_49635_(state, builder);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            WallLanternBlockTile tile = (WallLanternBlockTile)blockEntity;
            BlockState s = tile.getHeldBlock();
            s.m_60734_().m_214162_(s, level, pos, random);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new WallLanternBlockTile(pPos, pState);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        if (level.f_46443_) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof WallLanternBlockTile) {
                WallLanternBlockTile tile = (WallLanternBlockTile)blockEntity;
                tile.amendments$getAnimation().hitByEntity(entity, state, pos);
            }
        } else {
            if (entity.f_19854_ != entity.m_20185_() || entity.f_19856_ != entity.m_20189_() || entity.f_19855_ != entity.m_20186_()) {
                level.m_142346_(entity, GameEvent.f_223702_, pos);
            }
            ModNetwork.CHANNEL.sentToAllClientPlayersTrackingEntity(entity, (Message)new ClientBoundEntityHitSwayingBlockMessage(pos, entity.m_19879_()));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.WALL_LANTERN_TILE.get(), (BlockEntityTicker)(pLevel.f_46443_ ? SwayingBlockTile::clientTick : null));
    }

    public void placeOn(BlockState lantern, BlockPos onPos, Direction face, Level world) {
        BlockState state = (BlockState)WallLanternBlock.getConnectedState(this.m_49966_(), world.m_8055_(onPos), (LevelAccessor)world, onPos, face).m_61124_((Property)FACING, (Comparable)face);
        BlockPos newPos = onPos.m_121945_(face);
        world.m_7731_(newPos, state, 3);
        BlockEntity blockEntity = world.m_7702_(newPos);
        if (blockEntity instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)blockEntity;
            tile.setHeldBlock(lantern);
        }
    }

    public static boolean isValidBlock(Block b) {
        if (b.m_5456_() == Items.f_41852_) {
            return false;
        }
        ResourceLocation id = Utils.getID((Block)b);
        String namespace = id.m_135827_();
        if (CommonConfigs.WALL_LANTERN_WHITELIST.get().contains(id.toString())) {
            return true;
        }
        if (CommonConfigs.WALL_LANTERN_BLACKLIST.get().contains(namespace)) {
            return false;
        }
        if (namespace.equals("skinnedlanterns") || namespace.equals("twigs") && id.m_135815_().contains("paper_lantern")) {
            return true;
        }
        if (b instanceof LanternBlock) {
            return !b.m_49966_().m_155947_() || CompatHandler.SUPPSQUARED && SuppSquaredCompat.isLightableLantern(b);
        }
        return false;
    }
}

