/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import umpaz.nethersdelight.common.block.AbstractStoveBlock;
import umpaz.nethersdelight.common.registry.NDBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class BlackstoneStoveBlock
extends AbstractStoveBlock {
    public static final BooleanProperty SOUL = BooleanProperty.m_61465_((String)"soul");

    public BlackstoneStoveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SOUL, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)SOUL)).booleanValue() && (heldItem == Items.f_42049_ || heldItem == Items.f_42050_)) {
            if (!level.m_5776_()) {
                level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.soulLight(state, level, pos);
            if (!player.m_7500_()) {
                heldStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void soulLight(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SOUL, (Comparable)Boolean.valueOf(true)), 2);
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Direction.Axis direction$axis = direction.m_122434_();
        level.m_7785_(x, y, z, SoundEvents.f_11913_, SoundSource.BLOCKS, 0.2f, 2.6f, false);
        level.m_7785_(x, y, z, SoundEvents.f_12404_, SoundSource.BLOCKS, 1.5f, 2.6f, false);
        double horizontalOffset = MathUtils.RAND.nextDouble() * 0.6 - 0.3;
        double xOffset = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : horizontalOffset;
        double yOffset = MathUtils.RAND.nextDouble() * 6.0 / 16.0;
        double zOffset = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : horizontalOffset;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        for (int i = 0; i < 7; ++i) {
            double horizontalOffset2 = MathUtils.RAND.nextDouble() * 0.6 - 0.3;
            double xOffset2 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : horizontalOffset2;
            double yOffset2 = MathUtils.RAND.nextDouble() * 6.0 / 16.0;
            double zOffset2 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : horizontalOffset2;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, x + xOffset2, y + yOffset2, z + zOffset2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void extinguish(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        BlockState updatedState = (BlockState)state.m_61124_((Property)SOUL, (Comparable)Boolean.valueOf(false));
        super.extinguish(entity, updatedState, level, pos);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)SOUL, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean isLit = (Boolean)level.m_8055_(pos).m_61143_((Property)LIT);
        boolean isSoul = (Boolean)level.m_8055_(pos).m_61143_((Property)SOUL);
        if (isLit && isSoul && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(ModDamageTypes.getSimpleDamageSource((Level)level, (ResourceKey)ModDamageTypes.STOVE_BURN), 2.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SOUL});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue() && ((Boolean)stateIn.m_61143_((Property)SOUL)).booleanValue()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (rand.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, (SoundEvent)ModSounds.BLOCK_STOVE_CRACKLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Direction.Axis direction$axis = direction.m_122434_();
            double horizontalOffset = rand.m_188500_() * 0.6 - 0.3;
            double xOffset = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : horizontalOffset;
            double yOffset = rand.m_188500_() * 6.0 / 16.0;
            double zOffset = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : horizontalOffset;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            return;
        }
        super.m_214162_(stateIn, level, pos, rand);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)NDBlockEntityTypes.BLACKSTONE_STOVE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BlackstoneStoveBlock.createStoveTicker(level, state, blockEntityType, (BlockEntityType)NDBlockEntityTypes.BLACKSTONE_STOVE.get());
    }
}

