/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.networking;

import com.github.nyuppo.networking.MMVPacketHandler;
import com.github.nyuppo.networking.S2CRespondVariantPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraftforge.network.NetworkEvent;

public class C2SRequestVariantPacket {
    private final UUID uuid;

    public C2SRequestVariantPacket(UUID uuid) {
        this.uuid = uuid;
    }

    public C2SRequestVariantPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130259_());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
    }

    public static void handle(C2SRequestVariantPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            MinecraftServer server;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null && (server = sender.m_20194_()) != null) {
                Entity entity = server.m_129783_().m_8791_(msg.uuid);
                if (entity == null) {
                    for (ServerLevel level : server.m_129785_()) {
                        Entity entity2 = level.m_8791_(msg.uuid);
                        if (entity2 == null) continue;
                        entity = entity2;
                        break;
                    }
                }
                if (entity != null) {
                    CompoundTag nbt = new CompoundTag();
                    entity.m_20240_(nbt);
                    if (nbt.m_128441_("VariantID")) {
                        S2CRespondVariantPacket packet = new S2CRespondVariantPacket(entity.m_19879_(), nbt.m_128461_("VariantID"));
                        if (entity instanceof Pig) {
                            packet.setPigData(nbt.m_128471_("IsMuddy"), nbt.m_128451_("MuddyTimeLeft"));
                        } else if (entity instanceof Sheep) {
                            packet.setSheepData(nbt.m_128461_("HornColour"));
                        } else if (entity instanceof TamableAnimal) {
                            packet.setSitting(nbt.m_128471_("Sitting"));
                        }
                        MMVPacketHandler.sendToClient(packet, sender);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

