/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DecideStarbyActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.TravelToPosState;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DepositItemState
extends TravelToPosState {
    public DepositItemState(Starbuncle starbuncle, StarbyTransportBehavior behavior, BlockPos target) {
        super(starbuncle, behavior, target, new DecideStarbyActionState(starbuncle, behavior));
    }

    @Override
    public StarbyState onDestinationReached() {
        this.starbuncle.getNavigation().m_26573_();
        Level world = this.starbuncle.f_19853_;
        BlockEntity tileEntity = world.m_7702_(this.targetPos);
        if (tileEntity == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("missing_tile", "store pos broken " + this.targetPos.toString()));
            this.starbuncle.setBackOff(5 + this.starbuncle.f_19853_.f_46441_.m_188503_(20));
            return this.nextState;
        }
        IItemHandler iItemHandler = this.behavior.getItemCapFromTile(tileEntity, (Direction)this.behavior.TO_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (iItemHandler == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("NoItemHandler", "No item handler at " + this.targetPos.toString()));
            return this.nextState;
        }
        boolean didDeposit = this.depositStack(iItemHandler);
        if (!didDeposit) {
            this.starbuncle.setBackOff(5 + this.starbuncle.f_19853_.f_46441_.m_188503_(20));
            this.starbuncle.addGoalDebug(this, new DebugEvent("no_room", this.targetPos.toString()));
            return this.nextState;
        }
        OpenChestEvent event = new OpenChestEvent((ServerLevel)this.starbuncle.f_19853_, this.targetPos, 20);
        event.open();
        EventQueue.getServerInstance().addEvent(event);
        ItemStack left = this.starbuncle.getHeldStack();
        this.starbuncle.addGoalDebug(this, new DebugEvent("stored_item", "successful at " + this.targetPos.toString() + "set stack to " + left.m_41613_() + "x " + left.m_41786_().getString()));
        boolean fetchPassengerStack = left.m_41619_();
        while (fetchPassengerStack) {
            fetchPassengerStack = false;
            this.starbuncle.getNextItemFromPassengers();
            if (this.starbuncle.getHeldStack().m_41619_()) continue;
            fetchPassengerStack = this.depositStack(iItemHandler) && this.starbuncle.getHeldStack().m_41619_();
        }
        return this.nextState;
    }

    public boolean depositStack(IItemHandler iItemHandler) {
        ItemStack oldStack = new ItemStack((ItemLike)this.starbuncle.getHeldStack().m_41720_(), this.starbuncle.getHeldStack().m_41613_());
        ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)this.starbuncle.getHeldStack(), (boolean)false);
        this.starbuncle.setHeldStack(left);
        return !left.equals(oldStack);
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return this.behavior.sortPrefForStack(pos, this.starbuncle.getHeldStack()) != ItemScroll.SortPref.INVALID;
    }
}

