/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SignPostWallBlock
extends WaterBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);

    public SignPostWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)direction);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SignPostBlockTile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (itemstack.m_41720_() instanceof SignPostItem) {
            return InteractionResult.PASS;
        }
        if (level instanceof ServerLevel) {
            SignPostBlockTile tile;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SignPostBlockTile && (tile = (SignPostBlockTile)blockEntity).isAccessibleBy(player)) {
                return tile.handleInteraction(state, serverLevel, pos, player, handIn, hit, itemstack);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            SignPostBlockTile.Sign sign = tile.getClickedSign(target.m_82450_());
            if (sign.active()) {
                return sign.getItem();
            }
            return new ItemStack((ItemLike)tile.getHeldBlock().m_60734_());
        }
        return new ItemStack((ItemLike)this);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)object;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((ItemLike)tile.getHeldBlock().m_60734_()));
            SignPostBlockTile.Sign up = tile.getSignUp();
            SignPostBlockTile.Sign down = tile.getSignDown();
            if (up.active()) {
                list.add(up.getItem());
            }
            if (down.active()) {
                list.add(down.getItem());
            }
            return list;
        }
        return super.m_49635_(state, builder);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockUtil.addOptionalOwnership(placer, worldIn, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos behind = pos.m_121945_(facing.m_122424_());
        return level.m_8055_(behind).m_60783_((BlockGetter)level, behind, facing);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_48673_(BlockState state) {
        return true;
    }
}

