/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.faucet.APIFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BeehiveInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BrewingStandInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ConcreteInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ContainerItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FiniteFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FullBucketCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.LiquidBlockInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.MudInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.PowderSnowCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SappyLogInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidProviderInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SpongeInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.WaterCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.XPDroppingInteraction;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.BlockTestLevel;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FaucetBehaviorsManager
extends RegistryAccessJsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FaucetBehaviorsManager RELOAD_INSTANCE = new FaucetBehaviorsManager();
    private final Set<Object> dataInteractions = new HashSet<Object>();
    private final Set<Runnable> listeners = new HashSet<Runnable>();
    private static final Codec<Either<DataItemInteraction, DataFluidInteraction>> CODEC = Codec.either(DataItemInteraction.CODEC, DataFluidInteraction.CODEC);

    public FaucetBehaviorsManager() {
        super(GSON, "faucet_interactions");
    }

    public static void addRegisterFaucetInteraction(Runnable listener) {
        FaucetBehaviorsManager.RELOAD_INSTANCE.listeners.add(listener);
    }

    public void parse(Map<ResourceLocation, JsonElement> map, RegistryAccess registryAccess) {
        FaucetBlockTile.clearBehaviors();
        this.dataInteractions.clear();
        map.forEach((key, json) -> {
            try {
                DataResult result = CODEC.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess), json);
                Either d = (Either)result.getOrThrow(false, e -> Supplementaries.LOGGER.error("Failed to fluid interaction: {}", e));
                Optional l = d.left();
                Object o = l.isPresent() ? l.get() : d.right().get();
                this.dataInteractions.add(o);
                FaucetBlockTile.registerInteraction(o);
            }
            catch (Exception e2) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for faucet interaction {}", key);
            }
        });
        if (!this.dataInteractions.isEmpty()) {
            Supplementaries.LOGGER.info("Loaded  {} custom faucet interactions", (Object)this.dataInteractions.size());
        }
        FaucetBlockTile.clearBehaviors();
        FaucetBlockTile.registerInteraction(new SoftFluidProviderInteraction());
        FaucetBlockTile.registerInteraction(new WaterCauldronInteraction());
        FaucetBlockTile.registerInteraction(new FullBucketCauldronInteraction(Blocks.f_152477_.m_49966_(), Items.f_42448_.m_7968_()));
        FaucetBlockTile.registerInteraction(new PowderSnowCauldronInteraction());
        FaucetBlockTile.registerInteraction(new BeehiveInteraction());
        FaucetBlockTile.registerInteraction(new SoftFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new APIFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new BrewingStandInteraction());
        FaucetBlockTile.registerInteraction(new FiniteFluidInteraction());
        FaucetBlockTile.registerInteraction(new LiquidBlockInteraction());
        FaucetBlockTile.registerInteraction(new SpongeInteraction());
        FaucetBlockTile.registerInteraction(new XPDroppingInteraction());
        FaucetBlockTile.registerInteraction(new ConcreteInteraction());
        FaucetBlockTile.registerInteraction(new MudInteraction());
        FaucetBlockTile.registerInteraction(new ContainerItemInteraction());
        if (CompatHandler.AUTUMNITY) {
            FaucetBlockTile.registerInteraction(new SappyLogInteraction());
        }
        BlockTestLevel testLevel = BlockTestLevel.get(registryAccess);
        Player player = FakePlayerManager.getDefault((Level)testLevel);
        InteractionHand hand = InteractionHand.MAIN_HAND;
        BlockState emptyCauldron = Blocks.f_50256_.m_49966_();
        for (Map.Entry e : CauldronInteraction.f_175606_.entrySet()) {
            Item i = (Item)e.getKey();
            CauldronInteraction interaction = (CauldronInteraction)e.getValue();
            if (Utils.getID((Item)i).m_135827_().equals("minecraft")) continue;
            testLevel.setup();
            ItemStack fullBucket = i.m_7968_();
            ItemStack fullBucketCopy = fullBucket.m_41777_();
            player.m_21008_(hand, fullBucket);
            interaction.m_175710_(emptyCauldron, (Level)testLevel, BlockPos.f_121853_, player, hand, fullBucket);
            BlockState fullCauldron = testLevel.blockState;
            if (fullCauldron == null || fullCauldron.m_61138_((Property)LayeredCauldronBlock.f_153514_) && PlatHelper.getPlatform().isForge()) continue;
            FaucetBlockTile.registerInteraction(new FullBucketCauldronInteraction(fullCauldron, fullBucketCopy));
        }
        this.listeners.forEach(Runnable::run);
    }

    @Deprecated(forRemoval=true)
    public static void prepareToTransferBottle(SoftFluidTank tempFluidHolder, SoftFluid softFluid, @Nullable CompoundTag tag) {
    }
}

