/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.client.screens.SignPostScreen;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SignPostBlockTile
extends MimicBlockTile
implements ITextHolderProvider,
IOwnerProtected,
IScreenProvider {
    public static final ModelDataKey<Boolean> FRAMED_KEY = ModBlockProperties.FRAMED;
    public static final ModelDataKey<Float> RENDER_OFFSET_KEY = ModBlockProperties.RENDER_OFFSET;
    public static final ModelDataKey<Sign> SIGN_UP_KEY = ModBlockProperties.SIGN_UP;
    public static final ModelDataKey<Sign> SIGN_DOWN_KEY = ModBlockProperties.SIGN_DOWN;
    private final Sign signUp = new Sign(false, true, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private final Sign signDown = new Sign(false, false, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private boolean isWaxed = false;
    private UUID owner = null;
    private float zRenderOffset = 0.0f;
    private boolean framed = false;
    @Nullable
    private UUID playerWhoMayEdit;

    public SignPostBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.SIGN_POST_TILE.get(), pos, state);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        super.addExtraModelData(builder);
        builder.with(FRAMED_KEY, (Object)this.framed).with(SIGN_UP_KEY, (Object)this.signUp).with(SIGN_DOWN_KEY, (Object)this.signDown).with(RENDER_OFFSET_KEY, (Object)Float.valueOf(this.zRenderOffset));
    }

    @Override
    public TextHolder getTextHolder(int i) {
        return this.getSign((boolean)(i == 0 ? true : false)).text;
    }

    @Override
    public TextHolder getTextHolderAt(Vec3 hit) {
        return this.getClickedSign((Vec3)hit).text;
    }

    @Override
    public int textHoldersCount() {
        return 2;
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB((double)pos.m_123341_() - 0.25, (double)pos.m_123342_(), (double)pos.m_123343_() - 0.25, (double)pos.m_123341_() + 1.25, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.25);
    }

    public float getPointingYaw(boolean up) {
        if (up) {
            return this.signUp.getPointing();
        }
        return this.signDown.getPointing();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setHeldBlock(this.mimic);
        this.framed = compound.m_128471_("Framed");
        this.signUp.load(compound.m_128469_("SignUp"), this.f_58857_, this.f_58858_);
        this.signDown.load(compound.m_128469_("SignDown"), this.f_58857_, this.f_58858_);
        this.loadOwner(compound);
        if (compound.m_128441_("Waxed")) {
            this.isWaxed = compound.m_128471_("Waxed");
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.requestModelReload();
        }
    }

    public boolean setHeldBlock(BlockState state, int index) {
        Block b = state.m_60734_();
        this.zRenderOffset = b instanceof StickBlock ? 0.5625f : (b == Blocks.f_50016_ ? 0.0f : 0.625f);
        return super.setHeldBlock(state, index);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.mimic.m_60795_()) {
            compound.m_128473_("Mimic");
        }
        if (this.framed) {
            compound.m_128379_("Framed", true);
        }
        if (this.isWaxed) {
            compound.m_128379_("Waxed", true);
        }
        compound.m_128365_("SignUp", (Tag)this.signUp.save());
        compound.m_128365_("SignDown", (Tag)this.signDown.save());
        this.saveOwner(compound);
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean rotateSign(boolean up, float angle, boolean constrainAngle) {
        if (up && this.signUp.active) {
            this.signUp.rotateBy(angle, constrainAngle);
            return true;
        }
        if (this.signDown.active) {
            this.signDown.rotateBy(angle, constrainAngle);
            return true;
        }
        return false;
    }

    public void openScreen(Level level, BlockPos pos, Player player) {
        SignPostScreen.open(this);
    }

    public void openScreen(Level level, BlockPos pos, Player player, Direction direction) {
        SignPostScreen.open(this);
    }

    public float getOffset() {
        return this.zRenderOffset;
    }

    public Sign getSignUp() {
        return this.signUp;
    }

    public Sign getSignDown() {
        return this.signDown;
    }

    public Sign getSign(boolean up) {
        return up ? this.getSignUp() : this.getSignDown();
    }

    public boolean isFramed() {
        return this.framed;
    }

    public boolean trySetSign(WoodType woodType, int r, boolean up, boolean framed) {
        Sign sign = this.getSign(up);
        if (!sign.active) {
            sign.active = true;
            sign.woodType = woodType;
            sign.yaw = this.m_58900_().m_61138_((Property)HorizontalDirectionalBlock.f_54117_) ? 90.0f - ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_() : 90.0f + (float)r * -22.5f;
            this.framed = framed;
            return true;
        }
        return false;
    }

    public InteractionResult handleInteraction(BlockState state, ServerLevel level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, ItemStack itemstack) {
        Item item = itemstack.m_41720_();
        boolean emptyHand = itemstack.m_41619_();
        boolean isSneaking = player.m_6144_() && emptyHand;
        boolean ind = this.getClickedSignIndex(hit.m_82450_());
        if (hit.m_82434_().m_122434_() != Direction.Axis.Y) {
            boolean success;
            Sign sign = this.getSign(ind);
            if (!sign.active && item instanceof SignPostItem) {
                return InteractionResult.PASS;
            }
            if (isSneaking) {
                sign.toggleDirection();
                this.m_6596_();
                level.m_7260_(pos, state, state, 3);
                level.m_5594_(null, pos, ModSounds.BLOCK_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
            if (item instanceof CompassItem && !state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                BlockPos pointingPos;
                BlockPos blockPos = pointingPos = CompassItem.m_40736_((ItemStack)itemstack) ? this.getLodestonePos((Level)level, itemstack) : this.getWorldSpawnPos((Level)level);
                if (pointingPos != null) {
                    if (sign.active) {
                        sign.pointToward(pos, pointingPos);
                    }
                    this.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.FAIL;
            }
            if (CompatHandler.FRAMEDBLOCKS && this.framed && (success = FramedBlocksCompat.interactWithFramedSignPost(this, player, handIn, itemstack, (Level)level, pos))) {
                return InteractionResult.CONSUME;
            }
        }
        return this.interactWithTextHolder(ind ? 0 : 1, (Level)level, pos, state, player, handIn);
    }

    public boolean getClickedSignIndex(Vec3 hit) {
        double y = hit.f_82480_;
        y = y < 0.0 ? (y += (double)(1 - (int)y)) : (y -= (double)((int)y));
        return y > 0.5;
    }

    public Sign getClickedSign(Vec3 hit) {
        return this.getSign(this.getClickedSignIndex(hit));
    }

    @Nullable
    private BlockPos getLodestonePos(Level world, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            Optional optional;
            boolean flag = tag.m_128441_("LodestonePos");
            boolean flag1 = tag.m_128441_("LodestoneDimension");
            if (flag && flag1 && (optional = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("LodestoneDimension")).result()).isPresent() && world.m_46472_() == optional.get()) {
                return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LodestonePos"));
            }
        }
        return null;
    }

    @Nullable
    private BlockPos getWorldSpawnPos(Level world) {
        return world.m_6042_().f_63858_() ? new BlockPos(world.m_6106_().m_6789_(), world.m_6106_().m_6527_(), world.m_6106_().m_6526_()) : null;
    }

    @Override
    public void setWaxed(boolean waxed) {
        this.isWaxed = waxed;
    }

    @Override
    public boolean isWaxed() {
        return this.isWaxed;
    }

    @Override
    public void setPlayerWhoMayEdit(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    @Override
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public static final class Sign {
        public final TextHolder text;
        private boolean active;
        private boolean left;
        private float yaw;
        private WoodType woodType;

        private Sign(boolean active, boolean left, float yaw, WoodType woodType) {
            this.active = active;
            this.left = left;
            this.yaw = yaw;
            this.woodType = woodType;
            this.text = new TextHolder(1, 90);
        }

        public void load(CompoundTag compound, Level level, BlockPos pos) {
            this.active = compound.m_128471_("Active");
            this.left = compound.m_128471_("Left");
            this.yaw = compound.m_128457_("Yaw");
            this.woodType = WoodTypeRegistry.fromNBT((String)compound.m_128461_("WoodType"));
            this.text.load(compound, level, pos);
        }

        public CompoundTag save() {
            CompoundTag compound = new CompoundTag();
            compound.m_128350_("Yaw", this.yaw);
            compound.m_128379_("Left", this.left);
            compound.m_128379_("Active", this.active);
            compound.m_128359_("WoodType", this.woodType.toString());
            this.text.save(compound);
            return compound;
        }

        public void pointToward(BlockPos myPos, BlockPos targetPos) {
            float yaw = (float)(Math.atan2((double)targetPos.m_123341_() - (double)myPos.m_123341_(), (double)targetPos.m_123343_() - (double)myPos.m_123343_()) * 57.2957763671875);
            this.setYaw(yaw);
        }

        private float getPointing() {
            return Mth.m_14177_((float)(-this.yaw - (float)(this.left ? 180 : 0)));
        }

        private void setYaw(float yaw) {
            this.yaw = Mth.m_14177_((float)(yaw - (float)(this.left ? 180 : 0)));
        }

        private void rotateBy(float angle, boolean constrainAngle) {
            this.yaw = Mth.m_14177_((float)(this.yaw + angle));
            if (constrainAngle) {
                this.yaw -= this.yaw % 22.5f;
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setLeft(boolean left) {
            this.left = left;
        }

        public void setWoodType(WoodType woodType) {
            this.woodType = woodType;
        }

        public boolean active() {
            return this.active;
        }

        public boolean left() {
            return this.left;
        }

        public float yaw() {
            return this.yaw;
        }

        public WoodType woodType() {
            return this.woodType;
        }

        public void toggleDirection() {
            this.left = !this.left;
        }

        public ItemStack getItem() {
            return new ItemStack((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(this.woodType));
        }
    }
}

