/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChangeDimensionCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.teleport.invalidPosition"));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"dimension").requires(p -> p.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)new DimensionArgument()).executes(c -> ChangeDimensionCommand.teleportToPos((CommandContext<CommandSourceStack>)c, List.of(((CommandSourceStack)c.getSource()).m_81374_()), (Level)DimensionArgument.m_88808_((CommandContext)c, (String)"dimension"), (Coordinates)WorldCoordinates.m_120898_()))).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(c -> ChangeDimensionCommand.teleportToPos((CommandContext<CommandSourceStack>)c, List.of(((CommandSourceStack)c.getSource()).m_81374_()), (Level)DimensionArgument.m_88808_((CommandContext)c, (String)"dimension"), Vec3Argument.m_120849_((CommandContext)c, (String)"location"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(c -> ChangeDimensionCommand.teleportToPos((CommandContext<CommandSourceStack>)c, EntityArgument.m_91461_((CommandContext)c, (String)"targets"), (Level)DimensionArgument.m_88808_((CommandContext)c, (String)"dimension"), (Coordinates)WorldCoordinates.m_120898_()))).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(c -> ChangeDimensionCommand.teleportToPos((CommandContext<CommandSourceStack>)c, EntityArgument.m_91461_((CommandContext)c, (String)"targets"), (Level)DimensionArgument.m_88808_((CommandContext)c, (String)"dimension"), Vec3Argument.m_120849_((CommandContext)c, (String)"location"))))));
    }

    private static int teleportToPos(CommandContext<CommandSourceStack> context, Collection<? extends Entity> targets, Level level, Coordinates position) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Vec3 vec3 = position.m_6955_(source);
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (position.m_6888_()) {
            set.add(RelativeMovement.X);
        }
        if (position.m_6892_()) {
            set.add(RelativeMovement.Y);
        }
        if (position.m_6900_()) {
            set.add(RelativeMovement.Z);
        }
        set.add(RelativeMovement.X_ROT);
        set.add(RelativeMovement.Y_ROT);
        for (Entity entity : targets) {
            ChangeDimensionCommand.performTeleport(source, entity, level, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, set);
        }
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.location.single", (Object[])new Object[]{((Entity)targets.iterator().next()).m_5446_(), ChangeDimensionCommand.formatDouble(vec3.f_82479_), ChangeDimensionCommand.formatDouble(vec3.f_82480_), ChangeDimensionCommand.formatDouble(vec3.f_82481_)}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.location.multiple", (Object[])new Object[]{targets.size(), ChangeDimensionCommand.formatDouble(vec3.f_82479_), ChangeDimensionCommand.formatDouble(vec3.f_82480_), ChangeDimensionCommand.formatDouble(vec3.f_82481_)}), true);
        }
        return targets.size();
    }

    private static void performTeleport(CommandSourceStack source, Entity entity, Level level, double x, double y, double z, Set<RelativeMovement> relativeList) throws CommandSyntaxException {
        float g;
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (!Level.m_46741_((BlockPos)blockPos)) {
            throw INVALID_POSITION.create();
        }
        float f = Mth.m_14177_((float)entity.m_146908_());
        if (entity.m_264318_((ServerLevel)level, x, y, z, relativeList, f, g = Mth.m_14177_((float)entity.m_146909_()))) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21255_()) {
                entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
                entity.m_6853_(true);
            }
            if (entity instanceof PathfinderMob) {
                PathfinderMob pathfinderMob = (PathfinderMob)entity;
                pathfinderMob.m_21573_().m_26573_();
            }
        }
    }

    private static String formatDouble(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }
}

