/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.ProjectileStats;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.CannonBallExplosion;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundExplosionPacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.mixins.LivingEntityAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CannonBallEntity
extends ImprovedProjectileEntity {
    private final List<CannonBallEntity> justCollidedWith = new ArrayList<CannonBallEntity>();
    private int bounces = 0;

    public CannonBallEntity(LivingEntity thrower) {
        super(ModEntities.CANNONBALL.get(), thrower, thrower.m_9236_());
        this.maxAge = 6000;
        this.f_19850_ = true;
    }

    public CannonBallEntity(EntityType<CannonBallEntity> type, Level level) {
        super(type, level);
        this.maxAge = 6000;
        this.f_19850_ = true;
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("bounces", this.bounces);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.bounces = compound.m_128451_("bounces");
    }

    protected Item m_7881_() {
        return ModRegistry.CANNONBALL.get().m_5456_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.justCollidedWith.clear();
    }

    protected float m_7139_() {
        return ProjectileStats.CANNONBALL_GRAVITY;
    }

    public float getDefaultShootVelocity() {
        return ProjectileStats.CANNONBALL_SPEED;
    }

    public void spawnTrailParticles() {
        Vec3 speed = this.m_20184_();
        Vec3 normalSpeed = speed.m_82541_();
        double pitch = Math.asin(normalSpeed.f_82480_);
        double yaw = Math.atan2(normalSpeed.f_82479_, normalSpeed.f_82481_);
        double dx = this.m_20185_() - this.f_19854_;
        double dy = this.m_20186_() - this.f_19855_;
        double dz = this.m_20189_() - this.f_19856_;
        for (int k = 0; k < 2; ++k) {
            if (!((double)this.f_19796_.m_188501_() < speed.m_82553_() * 0.35)) continue;
            Vector3f offset = new Vector3f(0.0f, this.f_19796_.m_188501_() * this.m_20205_() * 0.7f, 0.0f);
            offset.rotateZ(this.m_9236_().f_46441_.m_188501_() * ((float)Math.PI * 2));
            offset.rotateX((float)pitch);
            offset.rotateY((float)yaw);
            float j = this.f_19796_.m_188501_() * -0.5f;
            this.m_9236_().m_7106_((ParticleOptions)ModParticles.WIND_STREAM.get(), (double)offset.x + (double)j * dx, (double)offset.y + (double)j * dy + (double)(this.m_20205_() / 3.0f), (double)offset.z + (double)j * dz, (double)this.m_19879_(), 0.0, 0.0);
        }
    }

    public void m_7822_(byte id) {
        BlockParticleOption particleData;
        super.m_7822_(id);
        Object object = particleData = ClientConfigs.Items.CANNONBALL_3D.get() != false ? new BlockParticleOption(ParticleTypes.f_123794_, ModRegistry.CANNONBALL.get().m_49966_()) : new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_());
        if (id == 3) {
            float speed = 0.05f;
            for (int i = 0; i < 8; ++i) {
                double k = this.f_19796_.m_188583_() * (double)speed;
                double l = this.f_19796_.m_188583_() * (double)speed;
                double m = this.f_19796_.m_188583_() * (double)speed;
                this.m_9236_().m_7106_((ParticleOptions)particleData, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), k, l, m);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (this.maybeBounce(result)) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            float radius = 1.1f;
            Vec3 movement = this.m_20184_();
            double vel = Math.abs(movement.m_82553_());
            float scaling = 5.0f;
            float maxAmount = (float)(vel * vel * (double)scaling);
            Vec3 loc = this.m_20182_();
            BlockPos pos = result.m_82425_();
            Set<Block> whitelist = CannonBlockTile.readBreakWhitelist(this.m_7846_().m_41784_());
            CannonBallExplosion exp = new CannonBallExplosion(this.m_9236_(), (Entity)this, loc.m_7096_(), loc.m_7098_(), loc.m_7094_(), pos, maxAmount, radius, whitelist);
            exp.m_46061_();
            exp.m_46075_(true);
            float exploded = exp.getExploded();
            if (exploded != 0.0f) {
                double speedUsed = exploded / maxAmount;
                double factor = 1.0 - speedUsed;
                if (factor <= 0.0 || factor > 1.0) {
                    Supplementaries.error();
                }
                this.m_20256_(movement.m_82490_(factor));
                ClientBoundExplosionPacket message = ClientBoundExplosionPacket.cannonball(exp, this);
                ModNetwork.CHANNEL.sendToAllClientPlayersInDefaultRange(this.m_9236_(), pos, (Message)message);
            }
            this.f_19812_ = true;
            if (this.m_20184_().m_82556_() < 0.04000000000000001 || exploded == 0.0f) {
                this.m_5496_(ModSounds.CANNONBALL_BREAK.get(), 1.0f, 1.5f);
                this.m_9236_().m_7605_((Entity)this, (byte)3);
                this.m_146870_();
            } else {
                Vec3 targetPos = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_).m_82549_(this.movementOld);
                Vec3 missingMovement = targetPos.m_82546_(this.m_20182_());
                if (missingMovement.m_82556_() > 1.0E-4) {
                    this.m_6478_(MoverType.SELF, missingMovement);
                }
            }
        }
    }

    private boolean maybeBounce(BlockHitResult hit) {
        boolean shouldBounce;
        if (this.bounces >= 3) {
            return false;
        }
        ++this.bounces;
        Direction hitDirection = hit.m_82434_();
        BlockPos pos = hit.m_82425_();
        Vec3 velocity = this.m_20184_();
        Vector3f surfaceNormal = hitDirection.m_253071_();
        Level level = this.m_9236_();
        BlockState hitBlock = level.m_8055_(pos);
        if (hitBlock.m_60734_() instanceof SlimeBlock) {
            shouldBounce = true;
        } else {
            float bounceCosAngle;
            double dot = surfaceNormal.dot((Vector3fc)velocity.m_252839_());
            double cosAngle = Math.abs(dot / velocity.m_82553_());
            boolean bl = shouldBounce = cosAngle < (double)(bounceCosAngle = Mth.m_14089_((float)1.3089969f));
        }
        if (shouldBounce) {
            Vec3 newVel = new Vec3(velocity.m_252839_().reflect((Vector3fc)surfaceNormal));
            this.m_20256_(newVel);
            this.f_19812_ = true;
            double missingDistance = velocity.m_82546_(this.m_20182_().m_82546_(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_))).m_82553_();
            this.m_146884_(this.m_20182_().m_82549_(newVel.m_82541_().m_82490_(missingDistance)));
            level.m_214171_(GameEvent.f_157770_, this.m_20182_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)hitBlock));
            this.addLandingEffects(hit);
            return true;
        }
        return false;
    }

    private void addLandingEffects(BlockHitResult hit) {
        this.m_5496_(ModSounds.CANNONBALL_BOUNCE.get(), 2.2f, 1.0f);
        BlockPos pos = hit.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        double speed = this.m_20184_().m_82556_();
        double minSpeed = 0.2f;
        if (!this.m_9236_().f_46443_ && !state.m_60795_() && speed > minSpeed) {
            double x = hit.m_82450_().f_82479_;
            double y = hit.m_82450_().f_82480_;
            double z = hit.m_82450_().f_82481_;
            int count = Math.min(10, (int)(speed * 4.0) + 1);
            BlockParticleOption blockParticleOption = new BlockParticleOption(ParticleTypes.f_123794_, state);
            SuppPlatformStuff.setParticlePos(blockParticleOption, pos);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)blockParticleOption, x, y, z, count, 0.0, 0.0, 0.0, 0.15);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        float f;
        Entity target = result.m_82443_();
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            f = 0.1f;
        } else {
            f = 0.8f;
        }
        float lossFactor = f;
        float cannonballDensity = 8.0f;
        float m2 = (float)target.m_20191_().m_82309_() * (target instanceof CannonBallEntity ? cannonballDensity : 0.0f);
        float m1 = (float)this.m_20191_().m_82309_() * cannonballDensity;
        Vector3f v2i = target.m_20184_().m_252839_();
        Vector3f v1i = this.m_20184_().m_252839_();
        double initialKineticEnergy = 0.5f * m1 * v1i.lengthSquared() + 0.5f * m2 * v2i.lengthSquared();
        float elasticity = 1.0f;
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            double lostEnergy = initialKineticEnergy * (double)(1.0f - lossFactor);
            float dmgMult = 3.5f;
            float amount = (float)lostEnergy * dmgMult;
            float oldHealth = le.m_21223_();
            if (le.m_6469_(ModDamageSources.cannonBallExplosion((Entity)this, this.m_19749_()), amount)) {
                elasticity = Mth.m_14116_((float)(1.0f - lossFactor));
            }
            if (!this.m_9236_().f_46443_ && le instanceof Creeper && oldHealth >= le.m_21233_()) {
                this.maybeDropDisc(le);
            }
        }
        Vector3f v1f = new Vector3f();
        Vector3f v2f = new Vector3f();
        for (int i = 0; i < 3; ++i) {
            float c1 = (v1i.get(i) * (m1 - m2) + elasticity * 2.0f * m2 * v2i.get(i)) / (m1 + m2);
            float c2 = (v2i.get(i) * (m2 - m1) + elasticity * 2.0f * m1 * v1i.get(i)) / (m1 + m2);
            v1f.setComponent(i, c1);
            v2f.setComponent(i, c2);
        }
        this.m_20256_(new Vec3(v1f));
        target.m_20256_(new Vec3(v2f));
        this.f_19812_ = true;
        Vector3f finalMomentum = v1f.mul(m1, new Vector3f()).add((Vector3fc)v2f.mul(m2, new Vector3f()));
        double finalKineticEnergy = 0.5f * m1 * v1f.lengthSquared() + 0.5f * m2 * v2f.lengthSquared();
        if (target instanceof CannonBallEntity) {
            CannonBallEntity c = (CannonBallEntity)target;
            c.justCollidedWith.add(this);
            this.m_5496_(ModSounds.CANNONBALL_BOUNCE.get(), 2.2f, 1.0f);
        }
    }

    private void maybeDropDisc(LivingEntity le) {
        if (!le.m_6084_() && CommonConfigs.Functional.PIRATE_DISC_ENABLED.get().booleanValue() && this.m_19749_() instanceof Player && ((LivingEntityAccessor)le).invokeShouldDropLoot() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            le.m_19998_((ItemLike)ModRegistry.PIRATE_DISC.get());
        }
    }

    protected boolean m_5603_(Entity target) {
        if (target instanceof CannonBallEntity) {
            CannonBallEntity c = (CannonBallEntity)target;
            return !c.justCollidedWith.contains((Object)this);
        }
        return super.m_5603_(target);
    }

    public boolean m_271807_() {
        return true;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }
}

