/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.mehvahdjukaar.moonlight.api.client.anim.PendulumAnimation;
import net.mehvahdjukaar.moonlight.api.client.anim.SwingAnimation;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HatStandEntity
extends LivingEntity {
    private static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.m_135353_(HatStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.m_135353_(HatStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<OptionalInt> FACING_TARGET = SynchedEntityData.m_135353_(HatStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private final NonNullList<ItemStack> helmet = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private boolean invisible;
    public long lastHit;
    private boolean slotsDisabled = false;
    private Rotations headPose;
    public final SwingAnimation swingAnimation;
    public final AnimationState skibidiAnimation;
    private final int tickOffset;
    private int skibidiAnimDur = 0;
    @Nullable
    private Float originalYRot = null;
    @Nullable
    private Entity target = null;
    public Vec3 jumpScareAngles = Vec3.f_82478_;

    public HatStandEntity(EntityType<? extends HatStandEntity> entityType, Level level) {
        super(entityType, level);
        this.headPose = DEFAULT_HEAD_POSE;
        this.m_274367_(0.0f);
        if (PlatHelper.getPhysicalSide().isClient()) {
            this.swingAnimation = new PendulumAnimation(ClientConfigs.Blocks.HAT_STAND_CONFIG, this::getRotationAxis);
            this.skibidiAnimation = new AnimationState();
        } else {
            this.swingAnimation = null;
            this.skibidiAnimation = null;
        }
        this.tickOffset = level.f_46441_.m_188503_(100);
        this.originalYRot = null;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        if (PlatHelper.getPlatform().isForge()) {
            return PlatHelper.getEntitySpawnPacket((Entity)this);
        }
        return super.m_5654_();
    }

    private Vector3f getRotationAxis() {
        return this.m_20252_(0.0f).m_252839_();
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, e, f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CLIENT_FLAGS, (Object)0);
        this.f_19804_.m_135372_(FACING_TARGET, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(DATA_HEAD_POSE, (Object)DEFAULT_HEAD_POSE);
    }

    public Iterable<ItemStack> m_6168_() {
        return this.helmet;
    }

    public Iterable<ItemStack> m_6167_() {
        return List.of();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (Objects.requireNonNull(slot) == EquipmentSlot.HEAD) {
            return (ItemStack)this.helmet.get(0);
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        this.m_181122_(stack);
        if (slot == EquipmentSlot.HEAD) {
            this.m_238392_(slot, (ItemStack)this.helmet.set(0, (Object)stack), stack);
        }
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)stack);
        return this.m_6844_(equipmentSlot).m_41619_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ItemStack stack = (ItemStack)this.helmet.get(0);
        if (!stack.m_41619_()) {
            compound.m_128365_("Helmet", (Tag)stack.m_41739_(new CompoundTag()));
        }
        compound.m_128379_("Invisible", this.m_20145_());
        compound.m_128379_("NoBasePlate", this.isNoBasePlate());
        compound.m_128379_("DisabledSlots", this.slotsDisabled);
        ListTag compoundTag = new ListTag();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            compoundTag = this.headPose.m_123155_();
        }
        compound.m_128365_("HeadPose", (Tag)compoundTag);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Helmet")) {
            this.helmet.set(0, (Object)ItemStack.m_41712_((CompoundTag)compound.m_128469_("Helmet")));
        }
        this.m_6842_(compound.m_128471_("Invisible"));
        this.setNoBasePlate(compound.m_128471_("NoBasePlate"));
        this.slotsDisabled = compound.m_128471_("DisabledSlots");
        ListTag listTag = compound.m_128437_("HeadPose", 5);
        this.setHeadPose(listTag.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(listTag));
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        Level level = this.m_9236_();
        if (level.f_46443_) {
            Entity e;
            this.swingAnimation.tick(!level.m_6425_(this.m_20097_()).m_76178_());
            List list = level.m_45933_((Entity)this, this.m_20191_());
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !this.swingAnimation.hitByEntity(e = (Entity)iterator.next())) {
            }
            float currentRot = this.m_146908_();
            if (this.target != null && this.skibidiAnimation.m_216984_()) {
                Vec3 distanceVec = this.target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                float targetYRot = distanceVec.m_252839_().angleSigned((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)) * 57.295776f - 90.0f;
                float difference = Mth.m_14118_((float)currentRot, (float)targetYRot);
                this.m_146922_(Mth.m_14179_((float)0.5f, (float)currentRot, (float)(currentRot + difference)));
            } else if (this.originalYRot != null && currentRot != this.originalYRot.floatValue()) {
                this.m_146922_(this.originalYRot.floatValue());
                this.originalYRot = null;
            }
        } else if (this.skibidiAnimDur != 0) {
            --this.skibidiAnimDur;
            if (this.skibidiAnimDur == 0) {
                this.m_20088_().m_135381_(FACING_TARGET, (Object)OptionalInt.empty());
                this.m_20124_(Pose.STANDING);
            }
        } else if (this.m_20089_() == Pose.STANDING && (this.f_19797_ + this.tickOffset) % 100 == 0 && this.f_19796_.m_188501_() < 0.2f) {
            this.setSkibidiIfInCauldron(null);
        }
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
        super.m_6138_();
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_150930_(Items.f_42656_)) {
            boolean isClientSide = player.m_9236_().f_46443_;
            if (player.m_36341_()) {
                if (isClientSide) {
                    this.swingAnimation.addImpulse(0.001f);
                    this.swingAnimation.addPositiveImpulse(1.2f);
                }
                return InteractionResult.m_19078_((boolean)isClientSide);
            }
            if (player.m_5833_()) {
                return InteractionResult.SUCCESS;
            }
            if (isClientSide) {
                return InteractionResult.CONSUME;
            }
            if (!this.slotsDisabled) {
                if (itemStack.m_41619_()) {
                    EquipmentSlot targetSlot = EquipmentSlot.HEAD;
                    if (this.m_21033_(targetSlot) && this.swapItem(player, targetSlot, itemStack, hand)) {
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
                    if (CommonConfigs.Building.HAT_STAND_UNRESTRICTED.get().booleanValue()) {
                        equipmentSlot = EquipmentSlot.HEAD;
                    }
                    if (equipmentSlot != EquipmentSlot.HEAD) {
                        return InteractionResult.FAIL;
                    }
                    if (this.swapItem(player, equipmentSlot, itemStack, hand)) {
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private boolean swapItem(Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack itemStack = this.m_6844_(slot);
        if (player.m_150110_().f_35937_ && itemStack.m_41619_() && !stack.m_41619_()) {
            this.m_8061_(slot, stack.m_255036_(1));
            return true;
        }
        if (!stack.m_41619_() && stack.m_41613_() > 1) {
            if (!itemStack.m_41619_()) {
                return false;
            }
            this.m_8061_(slot, stack.m_41620_(1));
            return true;
        }
        this.m_8061_(slot, stack);
        player.m_21008_(hand, itemStack);
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().f_46443_ && source.m_7640_() instanceof Projectile) {
            this.swingAnimation.hitByEntity(source.m_7640_());
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            if (source.m_269533_(DamageTypeTags.f_268738_)) {
                this.dismantle(source);
                return false;
            }
            if (!this.m_6673_(source) && !this.invisible) {
                if (source.m_269533_(DamageTypeTags.f_268415_)) {
                    this.dismantle(source);
                    return false;
                }
                if (source.m_269533_(DamageTypeTags.f_268727_)) {
                    if (this.m_6060_()) {
                        this.causeDamage(source, 0.15f);
                    } else {
                        this.m_20254_(5);
                    }
                    return false;
                }
                if (source.m_269533_(DamageTypeTags.f_268711_) && this.m_21223_() > 0.5f) {
                    this.causeDamage(source, 4.0f);
                    return false;
                }
                boolean isDirectArrow = source.m_7640_() instanceof AbstractArrow;
                boolean isPierceArrow = isDirectArrow && ((AbstractArrow)source.m_7640_()).m_36796_() > 0;
                boolean bl3 = "player".equals(source.m_19385_());
                if (!bl3 && !isDirectArrow) {
                    return false;
                }
                Entity sourceEntity = source.m_7639_();
                if (sourceEntity instanceof Player) {
                    Player player = (Player)sourceEntity;
                    if (!player.m_150110_().f_35938_) {
                        return false;
                    }
                }
                if (source.m_19390_()) {
                    this.dismantle(null);
                    return isPierceArrow;
                }
                long l = this.m_9236_().m_46467_();
                if (l - this.lastHit > 5L && !isDirectArrow) {
                    this.m_9236_().m_7605_((Entity)this, (byte)32);
                    this.m_146852_(GameEvent.f_223706_, source.m_7639_());
                    this.lastHit = l;
                } else {
                    this.dismantle(source);
                }
                return true;
            }
        }
        return false;
    }

    public void m_7822_(byte id) {
        if (id == 32) {
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f, false);
                this.lastHit = this.m_9236_().m_46467_();
            }
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_6783_(double distance) {
        double d = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d) || d == 0.0) {
            d = 4.0;
        }
        return distance < (d *= 64.0) * d;
    }

    private void showBreakingParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource damageSource, float amount) {
        float f = this.m_21223_();
        if ((f -= amount) <= 0.5f) {
            this.dismantle(damageSource);
        } else {
            this.m_21153_(f);
            this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
        }
    }

    protected float m_5632_(float yRot, float animStep) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * (this.m_6162_() ? 0.5f : 0.7f);
    }

    public void m_5618_(float pOffset) {
        float r;
        this.f_19859_ = r = this.m_146908_();
        this.f_20884_ = r;
        this.f_20883_ = r;
    }

    public void m_5616_(float pRotation) {
        float r;
        this.f_19859_ = r = this.m_146908_();
        this.f_20886_ = r;
        this.f_20885_ = r;
    }

    public void m_8119_() {
        super.m_8119_();
        Rotations rotations = (Rotations)this.f_19804_.m_135370_(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)rotations)) {
            this.setHeadPose(rotations);
        }
    }

    protected void m_8034_() {
        this.m_6842_(this.invisible);
    }

    public void m_6842_(boolean invisible) {
        this.invisible = invisible;
        super.m_6842_(invisible);
    }

    public void setNoBasePlate(boolean noBasePlate) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 8, noBasePlate));
    }

    public boolean isNoBasePlate() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    private byte setBit(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }

    public void dismantle(@Nullable DamageSource source) {
        if (source != null) {
            this.m_6668_(source);
        }
        this.showBreakingParticles();
        this.playBrokenSound();
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    protected void m_6668_(DamageSource damageSource) {
        super.m_6668_(damageSource);
        this.m_5552_(this.m_142340_(), 1.0f);
    }

    protected void m_5907_() {
        super.m_5907_();
        ItemStack itemStack = (ItemStack)this.helmet.get(0);
        if (!itemStack.m_41619_()) {
            this.m_5552_(itemStack, 1.0f);
            this.helmet.set(0, (Object)ItemStack.f_41583_);
        }
    }

    private void playBrokenSound() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
    }

    public void m_6074_() {
        this.dismantle(this.m_9236_().m_269111_().m_269264_());
    }

    public boolean m_6128_() {
        return this.m_20145_();
    }

    public void setHeadPose(Rotations headPose) {
        this.headPose = headPose;
        this.f_19804_.m_135381_(DATA_HEAD_POSE, (Object)headPose);
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7313_(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player p = (Player)entity;
        if (this.m_9236_().m_7966_(p, this.m_20183_())) return false;
        return true;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_11682_, SoundEvents.f_11682_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11683_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightning) {
    }

    public boolean m_5801_() {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_CLIENT_FLAGS.equals(key)) {
            this.m_6210_();
            this.f_19850_ = true;
        }
        if (f_19806_.equals(key) && this.m_9236_().f_46443_) {
            Pose pose = this.m_20089_();
            if (pose == Pose.SNIFFING || pose == Pose.SPIN_ATTACK) {
                this.skibidiAnimation.m_216977_(this.f_19797_);
            } else {
                this.skibidiAnimation.m_216973_();
            }
        }
        if (FACING_TARGET.equals(key) && this.m_9236_().f_46443_) {
            OptionalInt o = (OptionalInt)this.m_20088_().m_135370_(FACING_TARGET);
            if (o.isPresent()) {
                this.target = this.m_9236_().m_6815_(o.getAsInt());
                this.originalYRot = Float.valueOf(this.m_146908_());
            } else {
                this.target = null;
            }
        }
        super.m_7350_(key);
    }

    public boolean m_5789_() {
        return false;
    }

    public ItemStack m_142340_() {
        ItemStack itemStack = new ItemStack((ItemLike)ModRegistry.HAT_STAND.get());
        if (this.m_8077_()) {
            itemStack.m_41714_(this.m_7770_());
        }
        return itemStack;
    }

    public boolean m_142065_() {
        return !this.m_20145_();
    }

    private void setSkibidiIfInCauldron(@Nullable LivingEntity target) {
        BlockState state = this.m_146900_();
        Block block = state.m_60734_();
        if (block instanceof AbstractCauldronBlock || block instanceof ComposterBlock) {
            this.setSkibidi(true, true, target);
        } else if (block instanceof HopperBlock) {
            this.setSkibidi(true, false, target);
        }
    }

    public void setSkibidi(boolean skibidi, boolean tall, @Nullable LivingEntity playerTarget) {
        OptionalInt opt = playerTarget != null ? OptionalInt.of(playerTarget.m_19879_()) : OptionalInt.empty();
        this.f_19804_.m_135381_(FACING_TARGET, (Object)opt);
        if (skibidi) {
            this.m_20124_(tall ? Pose.SPIN_ATTACK : Pose.SNIFFING);
            this.skibidiAnimDur = 160;
        } else {
            this.m_20124_(Pose.STANDING);
        }
    }

    public static void makeSkibidiInArea(LivingEntity player) {
        Level level = player.m_9236_();
        List toilets = level.m_45976_(HatStandEntity.class, new AABB(player.m_20097_()).m_82400_(10.0));
        toilets.forEach(h -> h.setSkibidiIfInCauldron(player));
    }
}

