/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AwningBlock;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.ProjectileStats;
import net.mehvahdjukaar.supplementaries.common.entities.ISlimeable;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SlimeBallEntity
extends ImprovedProjectileEntity {
    private int bounces = 0;

    public SlimeBallEntity(Level world, double x, double y, double z) {
        super(ModEntities.THROWABLE_SLIMEBALL.get(), x, y, z, world);
    }

    public SlimeBallEntity(LivingEntity thrower) {
        super(ModEntities.THROWABLE_SLIMEBALL.get(), thrower, thrower.m_9236_());
    }

    public SlimeBallEntity(EntityType<SlimeBallEntity> type, Level level) {
        super(type, level);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("bounces", this.bounces);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.bounces = compound.m_128451_("bounces");
    }

    protected Component m_5677_() {
        return this.m_7846_().m_41611_();
    }

    protected Item m_7881_() {
        return Items.f_42518_;
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        Direction hitDirection = result.m_82434_();
        Vector3f surfaceNormal = hitDirection.m_253071_();
        BlockState hitState = this.m_9236_().m_8055_(result.m_82425_());
        if (hitDirection == Direction.UP && hitState.m_60734_() instanceof AwningBlock) {
            surfaceNormal = AwningBlock.getNormalVector(hitState);
        }
        Vec3 velocity = this.m_20184_();
        Vec3 newVel = new Vec3(velocity.m_252839_().reflect((Vector3fc)surfaceNormal));
        this.bounce(newVel);
    }

    private void bounce(Vec3 newVel) {
        ++this.bounces;
        Vec3 velocity = this.m_20184_();
        float conservedEnergy = 0.75f;
        newVel = newVel.m_82490_((double)conservedEnergy);
        this.m_20256_(newVel);
        double missingDistance = velocity.m_82546_(this.m_20182_().m_82546_(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_))).m_82553_();
        Vec3 missingVel = newVel.m_82541_().m_82490_(missingDistance);
        this.m_6478_(MoverType.SELF, missingVel);
        if (!this.m_9236_().f_46443_) {
            this.f_19812_ = true;
            this.addParticleEffects();
            this.m_5496_(ModSounds.SLIMEBALL_LAND.get(), 1.5f, 1.0f);
            if (this.bounces > 3) {
                this.m_146870_();
            }
        }
    }

    private void addParticleEffects() {
        this.m_9236_().m_7605_((Entity)this, (byte)3);
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            SimpleParticleType particleOptions = ParticleTypes.f_123753_;
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)particleOptions, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        entity = result.m_82443_();
        if (entity instanceof LivingEntity && (le = (LivingEntity)entity).m_21254_()) {
            hit = result.m_82450_();
            entityView = le.m_20252_(1.0f);
            normal = hit.m_82505_(le.m_20182_()).m_82541_();
            normal = new Vec3(normal.f_82479_, 0.0, normal.f_82481_);
            if (normal.m_82526_(entityView) < 0.0) {
                this.bounce(this.m_20184_().m_82490_(-1.0));
                return;
            }
        }
        if (!(entity instanceof ISlimeable)) ** GOTO lbl-1000
        s = (ISlimeable)entity;
        if (entity instanceof LivingEntity && (le = (LivingEntity)entity).m_5789_()) {
            s.supp$setSlimedTicks(CommonConfigs.Tweaks.SLIME_DURATION.get(), true);
        } else if (entity instanceof EndCrystal) {
            entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
        } else {
            this.f_19812_ = true;
            this.addParticleEffects();
        }
        this.m_146870_();
    }

    public float getDefaultShootVelocity() {
        return ProjectileStats.SLIMEBALL_SPEED;
    }

    public boolean canHarmOwner() {
        return true;
    }
}

