/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart;

import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.ILevelEventRedirect;
import net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.MovingBlockSource;
import net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.MovingDispenserBlockEntity;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.mixins.AbstractProjectileBehaviorAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DispenserMinecartEntity
extends Minecart
implements Container,
MenuProvider {
    private static final BlockState BLOCK_STATE = (BlockState)Blocks.f_50061_.m_49966_().m_61124_((Property)DispenserBlock.f_52659_, (Comparable)Direction.UP);
    private final MovingDispenserBlockEntity dispenser = new MovingDispenserBlockEntity(BlockEntityType.f_58922_, BlockPos.f_121853_, BLOCK_STATE, this);
    private boolean onActivator = false;
    private boolean powered = false;

    public DispenserMinecartEntity(Level level, double x, double y, double z) {
        this(ModEntities.DISPENSER_MINECART.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public DispenserMinecartEntity(EntityType<DispenserMinecartEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Dispenser", (Tag)this.dispenser.m_187482_());
    }

    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.dispenser.m_142466_(pCompound.m_128469_("Dispenser"));
    }

    public ItemStack m_142340_() {
        return ModRegistry.DISPENSER_MINECART_ITEM.get().m_7968_();
    }

    protected Item m_213728_() {
        return ModRegistry.DISPENSER_MINECART_ITEM.get();
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    public BlockState m_6390_() {
        return BLOCK_STATE;
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        InteractionResult ret = InteractionResult.PASS;
        if (ret.m_19077_()) {
            return ret;
        }
        pPlayer.m_5893_((MenuProvider)this);
        if (!pPlayer.m_9236_().f_46443_) {
            this.m_146852_(GameEvent.f_157803_, (Entity)pPlayer);
            PiglinAi.m_34873_((Player)pPlayer, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public int m_6643_() {
        return this.dispenser.m_6643_();
    }

    public boolean m_7983_() {
        return this.dispenser.m_7983_();
    }

    public ItemStack m_8020_(int pIndex) {
        return this.dispenser.m_8020_(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return this.dispenser.m_7407_(pIndex, pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        return this.dispenser.m_8016_(pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.dispenser.m_6836_(pIndex, pStack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.m_213877_()) {
            return false;
        }
        return pPlayer.m_20280_((Entity)this) <= 64.0;
    }

    public void m_6211_() {
        this.dispenser.m_6211_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return this.dispenser.m_7208_(pContainerId, pInventory, pPlayer);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && reason.m_146965_()) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(reason);
    }

    protected void m_7114_() {
        float f = 0.98f;
        int i = 15 - AbstractContainerMenu.m_38938_((Container)this);
        f += (float)i * 0.001f;
        if (this.m_20069_()) {
            f *= 0.95f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)f, 0.0, (double)f));
    }

    public SlotAccess m_141942_(final int pSlot) {
        return pSlot >= 0 && pSlot < this.m_6643_() ? new SlotAccess(){

            public ItemStack m_142196_() {
                return DispenserMinecartEntity.this.dispenser.m_8020_(pSlot);
            }

            public boolean m_142104_(ItemStack carried) {
                DispenserMinecartEntity.this.dispenser.m_6836_(pSlot, carried);
                return true;
            }
        } : super.m_141942_(pSlot);
    }

    public void m_6025_(int pX, int pY, int pZ, boolean pReceivingPower) {
        Level level;
        this.onActivator = true;
        if (!this.powered && pReceivingPower && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.dispenseFrom(serverLevel, this.m_20183_());
        }
        this.powered = pReceivingPower;
    }

    public void m_8119_() {
        super.m_8119_();
        this.dispenser.m_142339_(this.m_9236_());
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.powered) {
            if (!this.onActivator) {
                this.powered = false;
            }
            this.onActivator = false;
        }
    }

    public void m_6021_(double pX, double pY, double pZ) {
        super.m_6021_(pX, pY, pZ);
        this.m_9236_().m_7605_((Entity)this, (byte)46);
    }

    protected void dispenseFrom(ServerLevel pLevel, BlockPos pPos) {
        ((ILevelEventRedirect)pLevel).supp$setRedirected(true, this.m_20182_());
        int i = this.dispenser.m_222761_(pLevel.m_213780_());
        if (i < 0) {
            pLevel.m_46796_(1001, pPos, 0);
            pLevel.m_142346_((Entity)this, GameEvent.f_223702_, pPos);
        } else {
            ItemStack itemstack = this.dispenser.m_8020_(i);
            try {
                DispenseItemBehavior dispenseitembehavior = ((DispenserBlock)Blocks.f_50061_).m_7216_(itemstack);
                if (dispenseitembehavior != DispenseItemBehavior.f_123393_) {
                    ItemStack dispensed;
                    MovingBlockSource<MovingDispenserBlockEntity> blockSource = new MovingBlockSource<MovingDispenserBlockEntity>((Entity)this, this.dispenser);
                    if (CommonConfigs.Redstone.DISPENSER_MINECART_ANGLE.get().booleanValue() && dispenseitembehavior instanceof AbstractProjectileBehaviorAccessor) {
                        AbstractProjectileBehaviorAccessor pb = (AbstractProjectileBehaviorAccessor)dispenseitembehavior;
                        dispensed = this.executeAbstractProjectileBehavior(pb, blockSource, itemstack);
                    } else {
                        dispensed = dispenseitembehavior.m_6115_(blockSource, itemstack);
                    }
                    this.dispenser.m_6836_(i, dispensed);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("Failed to execute Dispenser Minecart behavior for item {}", (Object)itemstack.m_41720_());
            }
        }
        ((ILevelEventRedirect)pLevel).supp$setRedirected(false, Vec3.f_82478_);
    }

    private ItemStack executeAbstractProjectileBehavior(AbstractProjectileBehaviorAccessor ap, BlockSource source, ItemStack stack) {
        BaseRailBlock br;
        RailShape railShape;
        boolean ascending;
        ServerLevel level = source.m_7727_();
        Position position = DispenserBlock.m_52720_((BlockSource)source);
        Projectile projectile = ap.invokeGetProjectile((Level)level, position, stack);
        Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        projectile.m_6686_((double)direction.m_122429_(), (double)((float)direction.m_122430_() + 0.1f), (double)direction.m_122431_(), ap.invokeGetPower(), ap.invokeGetUncertainty());
        BlockState rail = level.m_8055_(this.m_20183_());
        Block block = rail.m_60734_();
        if (block instanceof BaseRailBlock && (ascending = (railShape = (RailShape)rail.m_61143_((br = (BaseRailBlock)block).m_7978_())).m_61745_())) {
            DispenserMinecartEntity.adjustMovementRelativeToRail(projectile, railShape);
        }
        Vec3 mySpeed = this.m_20184_().m_82490_(0.25);
        projectile.m_20256_(projectile.m_20184_().m_82520_(mySpeed.f_82479_, this.m_20096_() ? 0.0 : mySpeed.f_82480_, mySpeed.f_82481_));
        level.m_7967_((Entity)projectile);
        stack.m_41774_(1);
        ap.invokePlaySound(source);
        source.m_7727_().m_46796_(2000, source.m_7961_(), direction.m_122411_());
        return stack;
    }

    private static void adjustMovementRelativeToRail(Projectile projectile, RailShape railShape) {
        Vec3 movement = projectile.m_20184_();
        switch (railShape) {
            case ASCENDING_EAST: {
                movement = movement.m_82535_(-0.7853982f);
                break;
            }
            case ASCENDING_WEST: {
                movement = movement.m_82535_(0.7853982f);
                break;
            }
            case ASCENDING_SOUTH: {
                movement = movement.m_82496_(0.7853982f);
                break;
            }
            case ASCENDING_NORTH: {
                movement = movement.m_82496_(-0.7853982f);
            }
        }
        projectile.m_20256_(movement);
    }
}

