/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SignPostBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SignPostWallBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;

public class SignPostItem
extends WoodBasedBlockItem {
    public SignPostItem(Block block, Item.Properties properties, WoodType wood) {
        super(block, properties, wood, 100);
    }

    private AttachType getAttachType(BlockState state) {
        Block b = state.m_60734_();
        if (b instanceof SignPostWallBlock) {
            return AttachType.WAY_SIGN_WALL;
        }
        if (b instanceof SignPostBlock) {
            return AttachType.WAY_SIGN_POST;
        }
        if (b instanceof StickBlock && !((Boolean)state.m_61143_((Property)StickBlock.AXIS_X)).booleanValue() && !((Boolean)state.m_61143_((Property)StickBlock.AXIS_Z)).booleanValue() || state.m_60734_() instanceof EndRodBlock && ((Direction)state.m_61143_((Property)EndRodBlock.f_52588_)).m_122434_() == Direction.Axis.Y) {
            return AttachType.STICK;
        }
        ResourceLocation res = Utils.getID((Block)b);
        if (state.m_204336_(ModTags.POSTS) && !res.m_135827_().equals("blockcarpentry")) {
            return AttachType.FENCE;
        }
        return AttachType.WALL;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        ItemStack itemstack = context.m_43722_();
        BlockState state = level.m_8055_(blockpos);
        Block targetBlock = state.m_60734_();
        boolean framed = false;
        AttachType attachType = this.getAttachType(state);
        int rotation = attachType.getRot(context);
        if (attachType.needsConversion()) {
            Block f;
            if (CompatHandler.FRAMEDBLOCKS && (f = FramedBlocksCompat.tryGettingFramedBlock(targetBlock, level, blockpos)) != null) {
                framed = true;
                if (f != Blocks.f_50016_) {
                    targetBlock = f;
                }
            }
            boolean waterlogged = level.m_6425_(blockpos).m_76152_() == Fluids.f_76193_;
            level.m_7731_(blockpos, (BlockState)ModRegistry.SIGN_POST.get().m_5573_(new BlockPlaceContext(context)).m_61124_((Property)SignPostBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
        } else if (attachType == AttachType.WALL) {
            if (super.m_6225_(context).m_19077_()) {
                context = this.m_7732_(new BlockPlaceContext(context));
                blockpos = context.m_8083_();
            } else {
                return InteractionResult.PASS;
            }
        }
        BlockEntity blockEntity = level.m_7702_(blockpos);
        if (blockEntity instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            double y = context.m_43720_().f_82480_ - (double)blockpos.m_123342_();
            boolean up = y > 0.5;
            boolean addedSign = tile.trySetSign((WoodType)this.getBlockType(), rotation, up, framed);
            if (addedSign) {
                if (attachType != AttachType.WALL) {
                    if (attachType.needsConversion()) {
                        tile.setHeldBlock(targetBlock.m_49966_());
                        BlockUtil.addOptionalOwnership((LivingEntity)player, tile);
                        tile.m_6596_();
                    }
                    level.m_7260_(blockpos, state, state, 3);
                    SoundType soundtype = ((WoodType)this.getBlockType()).getSound();
                    level.m_5594_(player, blockpos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
                    if (!context.m_43723_().m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static enum AttachType {
        FENCE,
        STICK,
        WALL,
        WAY_SIGN_POST,
        WAY_SIGN_WALL;


        int getRot(UseOnContext context) {
            if (!this.needsConversion()) {
                return 0;
            }
            return Mth.m_14107_((double)((double)((180.0f + context.m_7074_()) * 16.0f / 360.0f) + 0.5)) & 0xF;
        }

        public boolean needsConversion() {
            return this == FENCE || this == STICK;
        }

        public boolean isSign() {
            return this == WAY_SIGN_POST || this == WAY_SIGN_WALL;
        }
    }
}

