/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TrinketsCompat {
    static IKeyLockable.KeyStatus getKey(Player player, String password) {
        TrinketComponent trinket = TrinketsApi.getTrinketComponent((LivingEntity)player).orElse(null);
        if (trinket != null) {
            List found = trinket.getEquipped(i -> i.m_204117_(ModTags.KEYS) || i.m_41720_() instanceof KeyItem);
            if (found.isEmpty()) {
                return IKeyLockable.KeyStatus.NO_KEY;
            }
            for (Tuple slot : found) {
                ItemStack stack = (ItemStack)slot.m_14419_();
                if (!IKeyLockable.getKeyStatus(stack, password).isCorrect()) continue;
                return IKeyLockable.KeyStatus.CORRECT_KEY;
            }
            return IKeyLockable.KeyStatus.INCORRECT_KEY;
        }
        return IKeyLockable.KeyStatus.NO_KEY;
    }

    static net.mehvahdjukaar.supplementaries.common.utils.SlotReference getQuiver(Player player) {
        List found;
        TrinketComponent trinket = TrinketsApi.getTrinketComponent((LivingEntity)player).orElse(null);
        if (trinket != null && !(found = trinket.getEquipped((Item)ModRegistry.QUIVER_ITEM.get())).isEmpty()) {
            return Trinket.of((SlotReference)((Tuple)found.get(0)).m_14418_(), trinket);
        }
        return net.mehvahdjukaar.supplementaries.common.utils.SlotReference.EMPTY;
    }

    static {
        net.mehvahdjukaar.supplementaries.common.utils.SlotReference.REGISTRY.register("trinket", Trinket.CODEC);
    }

    public record Trinket(String name1, String name2, int id) implements net.mehvahdjukaar.supplementaries.common.utils.SlotReference
    {
        public static final Codec<Trinket> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name1").forGetter(Trinket::name1), (App)Codec.STRING.fieldOf("name2").forGetter(Trinket::name2), (App)Codec.INT.fieldOf("id").forGetter(Trinket::id)).apply((Applicative)instance, Trinket::new));

        public static Trinket of(SlotReference ref, TrinketComponent comp) {
            int id = ref.index();
            TrinketInventory inv = ref.inventory();
            for (Map.Entry g : comp.getInventory().entrySet()) {
                String first = (String)g.getKey();
                for (Map.Entry s : ((Map)g.getValue()).entrySet()) {
                    String second = (String)s.getKey();
                    if (s.getValue() != inv) continue;
                    return new Trinket(first, second, id);
                }
            }
            throw new IllegalStateException("Trinket inventory not found. How?");
        }

        @Override
        public ItemStack get(LivingEntity player) {
            TrinketInventory inv;
            Map i;
            TrinketComponent trinket = TrinketsApi.getTrinketComponent((LivingEntity)player).orElse(null);
            if (trinket != null && (i = (Map)trinket.getInventory().get(this.name1)) != null && (inv = (TrinketInventory)i.get(this.name2)) != null) {
                return inv.getItem(this.id);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public Codec<? extends net.mehvahdjukaar.supplementaries.common.utils.SlotReference> getCodec() {
            return CODEC;
        }
    }
}

