/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.orcinus.galosphere.blocks.GlowInkClumpsBlock;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GNetworkHandler;
import net.orcinus.galosphere.network.SendParticlesPacket;

public class GlowInkClumpsBlockEntity
extends BlockEntity {
    private static int delay = 0;

    public GlowInkClumpsBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GBlockEntityTypes.GLOW_INK_CLUMPS.get(), pos, state);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, GlowInkClumpsBlockEntity te) {
        if ((Integer)state.m_61143_((Property)BlockStateProperties.f_61410_) == 0) {
            return;
        }
        if (delay > 0) {
            --delay;
        } else {
            GlowInkClumpsBlockEntity.generateGlowInk(world, pos, state, 2);
        }
    }

    private static void generateGlowInk(Level world, BlockPos pos, BlockState originState, int range) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                for (int y = -range; y <= range; ++y) {
                    BlockPos offset = pos.m_7918_(x, y, z);
                    if (!world.m_8055_(offset).m_60804_((BlockGetter)world, offset) || x * x + z * z + y * y > range * range) continue;
                    for (Direction direction : Direction.values()) {
                        BlockPos relative = offset.m_121945_(direction.m_122424_());
                        BlockState state = world.m_8055_(relative);
                        BlockState placeState = (BlockState)((Block)GBlocks.GLOW_INK_CLUMPS.get()).m_49966_().m_61124_((Property)GlowInkClumpsBlock.m_153933_((Direction)direction), (Comparable)Boolean.valueOf(true));
                        world.m_7731_(pos, (BlockState)originState.m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(Math.max(0, (Integer)originState.m_61143_((Property)BlockStateProperties.f_61410_) - ((Integer)originState.m_61143_((Property)BlockStateProperties.f_61410_) <= 4 ? 3 : 1)))), 2);
                        if (!world.m_7433_(relative, DripstoneUtils::m_159664_) && (!world.m_8055_(relative).m_247087_() || world.m_6425_(relative).m_205070_(FluidTags.f_13132_)) || state.m_60734_() instanceof GlowInkClumpsBlock && ((Boolean)state.m_61143_((Property)GlowInkClumpsBlock.m_153933_((Direction)direction))).booleanValue()) continue;
                        for (Direction dir : Direction.values()) {
                            if (!world.m_8055_(relative.m_121945_(dir)).m_60804_((BlockGetter)world, relative.m_121945_(dir))) continue;
                            placeState = (BlockState)placeState.m_61124_((Property)GlowInkClumpsBlock.m_153933_((Direction)dir), (Comparable)Boolean.valueOf(true));
                        }
                        if (delay != 0) continue;
                        GNetworkHandler.sendToAllInRangeClients(offset, (ServerLevel)world, 16.0, new SendParticlesPacket(offset));
                        int age = 0;
                        if (x == 1 || x == -1 && z == 1 || z == -1) {
                            age = Math.max(0, (Integer)originState.m_61143_((Property)BlockStateProperties.f_61410_) - 3);
                        }
                        world.m_7731_(relative, (BlockState)((BlockState)placeState.m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(age))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_8055_(relative).m_60713_(Blocks.f_49990_))), 2);
                        delay = 2;
                    }
                }
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        delay = tag.m_128451_("delay");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("delay", delay);
    }
}

