/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.galosphere.client.animations.BerserkerAnimations;
import net.orcinus.galosphere.entities.Berserker;

@OnlyIn(value=Dist.CLIENT)
public class BerserkerModel<T extends Berserker>
extends HierarchicalModel<T> {
    private final ModelPart root;

    public BerserkerModel(ModelPart root) {
        this.root = root.m_171324_("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition rightLeg = root.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(62, 0).m_171488_(-4.0f, -2.5f, -2.0f, 8.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)-12.5f, (float)11.0f));
        PartDefinition leftLeg = root.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(58, 62).m_171488_(-4.0f, -2.5f, -2.0f, 8.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-12.5f, (float)11.0f));
        PartDefinition rightArm = root.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-4.0f, -3.5f, -4.0f, 8.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 75).m_171488_(-4.0f, -5.5f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-10.0f, (float)-20.5f, (float)-8.0f));
        PartDefinition leftArm = root.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(32, 36).m_171488_(-4.0f, -3.5f, -4.0f, 8.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(78, 75).m_171488_(-4.0f, -5.5f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.0f, (float)-20.5f, (float)-8.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-10.0f, -5.75f, -18.5f, 20.0f, 14.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-17.25f, (float)9.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition firstSpike = body.m_171599_("firstSpike", CubeListBuilder.m_171558_().m_171514_(64, 36).m_171488_(-3.0f, -17.0f, -3.5f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.75f, (float)-13.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition secondSpike = body.m_171599_("secondSpike", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -15.0f, -1.5f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.75f, (float)-6.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition thirdSpike = body.m_171599_("thirdSpike", CubeListBuilder.m_171558_().m_171514_(90, 0).m_171488_(-1.0f, -12.0f, -1.5f, 2.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.75f, (float)0.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 68).m_171488_(-4.0f, 3.0f, -6.0f, 8.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 68).m_171488_(-4.0f, -5.0f, -6.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-25.0f, (float)-9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)112, (int)96);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        ModelPart head = this.root.m_171324_("head");
        head.f_104203_ = headPitch * ((float)Math.PI / 180);
        head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.m_267799_(BerserkerAnimations.BERSERKER_WALK, limbSwing, limbSwingAmount, 3.0f, 4.5f);
        this.m_233385_(((Berserker)((Object)entity)).attackAnimationState, BerserkerAnimations.BERSERKER_ATTACK, ageInTicks, 1.0f);
        this.m_233385_(((Berserker)((Object)entity)).impalingAnimationState, BerserkerAnimations.BERSERKER_IMPALING, ageInTicks, 1.0f);
        this.m_233385_(((Berserker)((Object)entity)).roarAnimationState, BerserkerAnimations.BERSERKER_SHAKE, ageInTicks, 1.0f);
        this.m_233385_(((Berserker)((Object)entity)).punchAnimationState, BerserkerAnimations.BERSERKER_PUNCH, ageInTicks, 1.0f);
        this.m_233385_(((Berserker)((Object)entity)).summoningAnimationState, BerserkerAnimations.BERSERKER_SPAWN_MINIONS, ageInTicks, 1.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

