/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.orcinus.galosphere.entities.ai.SpecterpillarAi;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Specterpillar
extends PathfinderMob {
    protected static final ImmutableList<SensorType<? extends Sensor<? super Specterpillar>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_, (Object)((SensorType)GSensorTypes.SPECTRE_TEMPTATIONS.get()), (Object)((SensorType)GSensorTypes.NEAREST_LICHEN_MOSS.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26331_, (Object)MemoryModuleType.f_148197_, (Object)MemoryModuleType.f_148198_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_217768_, (Object)((MemoryModuleType)GMemoryModuleTypes.CAN_BURY.get()), (Object[])new MemoryModuleType[]{(MemoryModuleType)GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get()});
    public final AnimationState burrowAnimationState = new AnimationState();
    private int age;

    public Specterpillar(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public float m_274421_() {
        return 1.0f;
    }

    public boolean m_6094_() {
        return this.m_20089_() != Pose.DIGGING && super.m_6094_();
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == Pose.DIGGING) {
                this.burrowAnimationState.m_216977_(this.f_19797_);
            } else {
                this.burrowAnimationState.m_216973_();
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    protected Brain.Provider<Specterpillar> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public Brain<Specterpillar> m_6274_() {
        return super.m_6274_();
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return SpecterpillarAi.makeBrain((Brain<Specterpillar>)this.m_5490_().m_22073_(dynamic));
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)GSoundEvents.SPECTERPILLAR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)GSoundEvents.SPECTERPILLAR_DEATH.get();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("specterpillarBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("specterpillarActivityUpdate");
        SpecterpillarAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public void setAge(int i) {
        this.age = i;
    }

    public int getAge() {
        return this.age;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        MemoryModuleType moduleType = (MemoryModuleType)GMemoryModuleTypes.CAN_BURY.get();
        if (!this.m_9236_().f_46443_ && stack.m_204117_(GItemTags.SPECTRE_TEMPT_ITEMS) && !this.m_6274_().m_21874_(moduleType)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (this.m_217043_().m_188503_(5) == 0) {
                this.m_6274_().m_21879_(moduleType, (Object)true);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, interactionHand);
    }

    public void m_7822_(byte b) {
        if (b == 4) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
        } else {
            super.m_7822_(b);
        }
    }

    public boolean m_6149_() {
        return false;
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Age", this.getAge());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAge(compoundTag.m_128451_("Age"));
    }
}

