/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.mixin.ProjectileAccessor;

public abstract class ThrowableLaunchedProjectile
extends FireworkRocketEntity {
    protected static final EntityDataAccessor<Boolean> THROWN = SynchedEntityData.m_135353_(ThrowableLaunchedProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ThrowableLaunchedProjectile(EntityType<? extends FireworkRocketEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ThrowableLaunchedProjectile(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        super(world, stack, entity, x, y, z, shotAtAngle);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(THROWN, (Object)false);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setThrown(compoundTag.m_128471_("Thrown"));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Thrown", this.isThrown());
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
    }

    public boolean isThrown() {
        return (Boolean)this.f_19804_.m_135370_(THROWN);
    }

    public void setThrown(boolean thrown) {
        this.f_19804_.m_135381_(THROWN, (Object)thrown);
    }

    public void m_8119_() {
        if (this.isThrown()) {
            float h;
            ProjectileAccessor accessor = (ProjectileAccessor)((Object)this);
            if (!accessor.isHasBeenShot()) {
                this.m_146852_(GameEvent.f_157778_, this.m_19749_());
                accessor.setHasBeenShot(true);
            }
            if (!accessor.isLeftOwner()) {
                accessor.setLeftOwner(accessor.callCheckLeftOwner());
            }
            this.m_6075_();
            HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
            boolean bl = false;
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockPos = ((BlockHitResult)hitResult).m_82425_();
                BlockState blockState = this.m_9236_().m_8055_(blockPos);
                if (blockState.m_60713_(Blocks.f_50142_)) {
                    this.m_20221_(blockPos);
                    bl = true;
                } else if (blockState.m_60713_(Blocks.f_50446_)) {
                    BlockEntity blockEntity = this.m_9236_().m_7702_(blockPos);
                    if (blockEntity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                        TheEndGatewayBlockEntity.m_155828_((Level)this.m_9236_(), (BlockPos)blockPos, (BlockState)blockState, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockEntity));
                    }
                    bl = true;
                }
            }
            if (hitResult.m_6662_() != HitResult.Type.MISS && !bl) {
                this.m_6532_(hitResult);
            }
            this.m_20101_();
            Vec3 vec3 = this.m_20184_();
            double d = this.m_20185_() + vec3.f_82479_;
            double e = this.m_20186_() + vec3.f_82480_;
            double f = this.m_20189_() + vec3.f_82481_;
            this.m_37283_();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d - vec3.f_82479_ * 0.25, e - vec3.f_82480_ * 0.25, f - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                h = 0.8f;
            } else {
                h = 0.99f;
            }
            this.m_20256_(vec3.m_82490_((double)h));
            if (!this.m_20068_()) {
                Vec3 vec32 = this.m_20184_();
                this.m_20334_(vec32.f_82479_, vec32.f_82480_ - (double)this.getGravity(), vec32.f_82481_);
            }
            this.m_6034_(d, e, f);
        } else {
            super.m_8119_();
            this.handleLaunchedProjectile();
        }
    }

    public float getGravity() {
        return 0.03f;
    }

    public void handleLaunchedProjectile() {
    }

    protected abstract Item getDefaultItem();

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)this.getDefaultItem());
    }
}

