/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.ai.tasks.WalkToPollinatedCluster;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;

public class SparkleAi {
    public static Brain<?> makeBrain(Brain<Sparkle> brain) {
        SparkleAi.initCoreActivity(brain);
        SparkleAi.initIdleActivity(brain);
        SparkleAi.initSwimActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Sparkle> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_)));
    }

    private static void initIdleActivity(Brain<Sparkle> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)GEntityTypes.SPARKLE.get(), 1.0f)), (Object)Pair.of((Object)1, (Object)new FollowTemptation(entity -> Float.valueOf(2.0f))), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.m_257685_((UniformInt)UniformInt.m_146622_((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, (Object)((Object)new WalkToPollinatedCluster())), (Object)Pair.of((Object)4, (Object)TryFindLand.m_257647_((int)6, (float)1.0f)), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.5f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.5f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20096_), (Object)2))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_217766_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initSwimActivity(Brain<Sparkle> brain) {
        brain.m_21903_(Activity.f_219847_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new FollowTemptation(entity -> Float.valueOf(2.0f))), (Object)Pair.of((Object)2, (Object)((Object)new WalkToPollinatedCluster())), (Object)Pair.of((Object)3, (Object)TryFindLand.m_257647_((int)8, (float)1.5f)), (Object)Pair.of((Object)4, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257751_((float)0.75f), (Object)1), (Object)Pair.of((Object)RandomStroll.m_257798_((float)1.0f, (boolean)true), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20072_), (Object)5))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_217766_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivity(Sparkle entity) {
        entity.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219847_, (Object)Activity.f_37979_));
    }

    public static Ingredient getTemptations() {
        return Ingredient.m_204132_(GItemTags.SPARKLE_TEMPT_ITEMS);
    }
}

