/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.entities.ai.tasks.FindValidLandingPosition;
import net.orcinus.galosphere.entities.ai.tasks.LaySpecterpillar;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;

public class SpectreAi {
    public static Brain<?> makeBrain(Brain<Spectre> brain) {
        SpectreAi.initCoreActivity(brain);
        SpectreAi.initIdleActivity(brain);
        SpectreAi.initLaySpawnActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Spectre> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_)));
    }

    private static void initIdleActivity(Brain<Spectre> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)GEntityTypes.SPECTRE.get(), 1.0f)), (Object)Pair.of((Object)1, (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257379_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    private static void initLaySpawnActivity(Brain<Spectre> brain) {
        brain.m_21903_(Activity.f_219848_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)((Object)new FindValidLandingPosition((Block)GBlocks.LICHEN_MOSS.get()))), (Object)Pair.of((Object)2, (Object)((Object)new LaySpecterpillar())), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(5, 20), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_217767_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivity(Spectre entity) {
        entity.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219848_, (Object)Activity.f_37979_));
    }

    public static Ingredient getTemptations() {
        return Ingredient.m_204132_(GItemTags.SPECTRE_TEMPT_ITEMS);
    }
}

