/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class WalkToPollinatedCluster
extends Behavior<Sparkle> {
    private int sniffingTicks;
    private int stuckTicks;
    private boolean setCooldownOnly = false;

    public WalkToPollinatedCluster() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)GMemoryModuleTypes.POLLINATED_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel world, Sparkle entity) {
        return !entity.m_6162_() && this.getNearestCluster(entity).isPresent() && !entity.m_6274_().m_21874_(MemoryModuleType.f_26375_) && !entity.m_6274_().m_21874_(MemoryModuleType.f_217768_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canStillUse(ServerLevel world, Sparkle entity, long p_22547_) {
        if (this.stuckTicks > 200) {
            this.setCooldownOnly = true;
            return false;
        }
        if (this.sniffingTicks <= 0) return false;
        if (!this.getNearestCluster(entity).map(arg_0 -> ((ServerLevel)world).m_8055_(arg_0)).filter(this::isPollinatedCluster).isPresent()) return false;
        return true;
    }

    private boolean isPollinatedCluster(BlockState state) {
        return state.m_60713_(Blocks.f_152492_) || state.m_60734_() instanceof PollinatedClusterBlock && (Boolean)state.m_61143_((Property)PollinatedClusterBlock.POLLINATED) == false;
    }

    protected void start(ServerLevel world, Sparkle entity, long p_22542_) {
        this.sniffingTicks = 100;
    }

    protected void tick(ServerLevel p_22551_, Sparkle entity, long p_22553_) {
        this.getNearestCluster(entity).ifPresent(blockPos -> {
            boolean flag;
            boolean bl = flag = (float)entity.m_20183_().m_123333_((Vec3i)blockPos) <= (entity.m_20072_() ? 2.0f : 1.0f);
            if (flag) {
                entity.m_21573_().m_26573_();
                --this.sniffingTicks;
            } else {
                ++this.stuckTicks;
            }
            BehaviorUtils.m_22617_((LivingEntity)entity, (BlockPos)blockPos, (float)2.0f, (int)0);
        });
    }

    protected void stop(ServerLevel world, Sparkle entity, long p_22550_) {
        this.getNearestCluster(entity).filter(blockPos -> this.isPollinatedCluster(world.m_8055_(blockPos))).ifPresent(blockPos -> {
            entity.m_6274_().m_21936_((MemoryModuleType)GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER.get());
            if (!this.setCooldownOnly) {
                BlockState state = world.m_8055_(blockPos);
                Block placeState = entity.getClustersToGlinted().get(state.m_60734_());
                world.m_7731_(blockPos, placeState.m_152465_(state), 2);
                world.m_5594_(null, blockPos, placeState.m_49966_().m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_46796_(2005, blockPos, 0);
                return;
            }
            entity.m_6274_().m_21882_((MemoryModuleType)GMemoryModuleTypes.POLLINATED_COOLDOWN.get(), (Object)Unit.INSTANCE, 100L);
        });
        this.stuckTicks = 0;
        this.setCooldownOnly = false;
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }

    private Optional<BlockPos> getNearestCluster(Sparkle entity) {
        return entity.m_6274_().m_21952_((MemoryModuleType)GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER.get());
    }
}

