/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.orcinus.galosphere.client.model.SterlingArmorModel;
import net.orcinus.galosphere.init.GAttributes;
import net.orcinus.galosphere.init.GItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SterlingArmorItem
extends ArmorItem {
    private static final SterlingArmorMaterial material = new SterlingArmorMaterial();
    private static final String HELMET_TEXTURE = "galosphere:textures/entity/sterling_helmet.png";
    private static final String LEGS_TEXTURE = "galosphere:textures/entity/sterling_armor_2.png";
    private static final String TEXTURE = "galosphere:textures/entity/sterling_armor.png";

    public SterlingArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super((ArmorMaterial)material, type, properties);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> HELMET_TEXTURE;
            case EquipmentSlot.LEGS -> LEGS_TEXTURE;
            default -> TEXTURE;
        };
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = UUID.fromString("fb112e48-f201-4a6f-ae86-0f11df4f8e79");
        UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
        UUID defaultUUid = ARMOR_MODIFIER_UUID_PER_SLOT[slot.m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(defaultUUid, "Armor modifier", (double)this.m_40401_().m_7366_(this.f_265916_), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(defaultUUid, "Armor toughness", (double)this.m_40401_().m_6651_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)GAttributes.ILLAGER_RESISTANCE.get()), (Object)new AttributeModifier(uuid, "Armor illager resistance", (double)this.getInsurgentResistance(slot), AttributeModifier.Operation.ADDITION));
        return slot == this.f_265916_.m_266308_() ? builder.build() : super.m_7167_(slot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return equipmentSlot == EquipmentSlot.HEAD ? new SterlingArmorModel(SterlingArmorModel.createBodyLayer().m_171564_()) : super.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
            }
        });
    }

    public float getInsurgentResistance(EquipmentSlot slot) {
        float[] array = new float[]{3.0f, 5.0f, 6.0f, 2.0f};
        return array[slot.m_20749_()];
    }

    private static class SterlingArmorMaterial
    implements ArmorMaterial {
        private static final int[] HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};

        private SterlingArmorMaterial() {
        }

        public int m_266425_(ArmorItem.Type type) {
            return HEALTH_PER_SLOT[type.m_266308_().m_20749_()] * 12;
        }

        public int m_7366_(ArmorItem.Type type) {
            int[] slots = new int[]{2, 5, 4, 1};
            return slots[type.m_266308_().m_20749_()];
        }

        public int m_6646_() {
            return 9;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11672_;
        }

        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)GItems.SILVER_INGOT.get()});
        }

        public String m_6082_() {
            return "sterling";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

