/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.orcinus.galosphere.blocks.PinkSaltLampBlock;
import net.orcinus.galosphere.blocks.PinkSaltStrawBlock;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.world.gen.features.config.PinkSaltStrawPatchConfig;

public class PinkSaltStrawPatchFeature
extends Feature<PinkSaltStrawPatchConfig> {
    public PinkSaltStrawPatchFeature(Codec<PinkSaltStrawPatchConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<PinkSaltStrawPatchConfig> featurePlaceContext) {
        PinkSaltStrawPatchConfig config = (PinkSaltStrawPatchConfig)featurePlaceContext.m_159778_();
        WorldGenLevel world = featurePlaceContext.m_159774_();
        BlockPos blockPos = featurePlaceContext.m_159777_();
        RandomSource random = featurePlaceContext.m_225041_();
        int xRadius = config.radius().m_214085_(random);
        int zRadius = config.radius().m_214085_(random);
        int yRange = config.height().m_214085_(random);
        Direction direction = config.direction();
        if (!world.m_7433_(blockPos, DripstoneUtils::m_159664_)) {
            return false;
        }
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                for (int y = -yRange; y <= yRange; ++y) {
                    BlockPos pos = blockPos.m_7918_(x, y, z);
                    if (x * x + z * z > xRadius * zRadius || !world.m_8055_(pos).m_204336_(GBlockTags.PINK_SALT_BLOCKS) || !world.m_7433_(pos.m_121945_(direction), DripstoneUtils::m_159664_)) continue;
                    if (x == 0 && z == 0) {
                        world.m_7731_(pos.m_121945_(direction), (BlockState)((BlockState)((Block)GBlocks.PINK_SALT_CLUSTER.get()).m_49966_().m_61124_((Property)PinkSaltLampBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.m_8055_(pos.m_121945_(direction)).m_60713_(Blocks.f_49990_)))).m_61124_((Property)PinkSaltLampBlock.FACING, (Comparable)direction), 2);
                        continue;
                    }
                    if (random.m_188503_(3) == 0) continue;
                    int sample = config.additionHeight().m_214085_(random);
                    if (random.m_188503_(5) == 0) {
                        sample *= 2;
                    }
                    this.addSaltStraw(world, pos.m_121945_(direction), sample, direction);
                }
            }
        }
        return true;
    }

    public void addSaltStraw(WorldGenLevel world, BlockPos blockPos, int height, Direction direction) {
        for (int i = 0; i <= height; ++i) {
            BlockPos pos = blockPos.m_5484_(direction, i);
            if (!world.m_7433_(pos, DripstoneUtils::m_159664_)) {
                boolean fullShape = world.m_8055_(pos).m_60838_((BlockGetter)world, pos);
                world.m_7731_(pos.m_121945_(direction.m_122424_()), (BlockState)((BlockState)((BlockState)((Block)GBlocks.PINK_SALT_STRAW.get()).m_49966_().m_61124_((Property)PinkSaltStrawBlock.TIP_DIRECTION, (Comparable)direction.m_122424_())).m_61124_(PinkSaltStrawBlock.STRAW_SHAPE, (Comparable)((Object)(fullShape ? PinkSaltStrawBlock.StrawShape.BOTTOM : PinkSaltStrawBlock.StrawShape.TOP)))).m_61124_((Property)PinkSaltStrawBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.m_8055_(pos).m_60713_(Blocks.f_49990_))), 2);
                break;
            }
            PinkSaltStrawBlock.StrawShape strawShape = i == height ? PinkSaltStrawBlock.StrawShape.TOP : (i == 0 ? PinkSaltStrawBlock.StrawShape.BOTTOM : PinkSaltStrawBlock.StrawShape.MIDDLE);
            world.m_7731_(pos, (BlockState)((BlockState)((BlockState)((Block)GBlocks.PINK_SALT_STRAW.get()).m_49966_().m_61124_((Property)PinkSaltStrawBlock.TIP_DIRECTION, (Comparable)direction)).m_61124_(PinkSaltStrawBlock.STRAW_SHAPE, (Comparable)((Object)strawShape))).m_61124_((Property)PinkSaltStrawBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.m_8055_(pos).m_60713_(Blocks.f_49990_))), 2);
        }
    }
}

