/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.client.sound.HamsterFlightSoundInstance;
import net.dawson.adorablehamsterpets.client.sound.HamsterThrowSoundInstance;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.client.ModModelLayers;
import net.dawson.adorablehamsterpets.entity.client.model.HamsterShoulderModel;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();

    public static void init() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ModBlocks.GREEN_BEANS_CROP.get(), (Block)ModBlocks.CUCUMBER_CROP.get(), (Block)ModBlocks.SUNFLOWER_BLOCK.get(), (Block)ModBlocks.WILD_CUCUMBER_BUSH.get(), (Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get()});
        ModPackets.registerS2CPackets();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAMSTER_SPAWN_EGG.get()});
        InteractionEvent.RIGHT_CLICK_ITEM.register((player, hand) -> {
            ItemStack stack = player.m_21120_(hand);
            if (player.m_9236_().f_46443_ && stack.m_150930_((Item)ModItems.HAMSTER_GUIDE_BOOK.get()) && stack.m_41782_() && stack.m_41783_().m_128441_("pages")) {
                Minecraft.m_91087_().m_91152_((Screen)new BookViewScreen((BookViewScreen.BookAccess)new BookViewScreen.WrittenBookAccess(stack)));
                return CompoundEventResult.interrupt((Boolean)true, (Object)stack);
            }
            return CompoundEventResult.pass();
        });
    }

    public static void initKeybindings() {
        ModKeyBindings.registerKeyInputs();
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
    }

    public static void initModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)ModModelLayers.HAMSTER_SHOULDER_LAYER, HamsterShoulderModel::getTexturedModelData);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    private static void onEndClientTick(Minecraft client) {
        if (client.f_91074_ == null || client.f_91073_ == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.m_90859_()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.f_91074_.m_5661_((Component)Component.m_237113_((String)"Hamster throwing is disabled in config."), true);
            } else {
                boolean hasShoulderHamsterClient;
                boolean lookingAtReachableBlock = client.f_91077_ != null && client.f_91077_.m_6662_() == HitResult.Type.BLOCK;
                boolean bl = hasShoulderHamsterClient = !((PlayerEntityAccessor)client.f_91074_).getHamsterShoulderEntity().m_128456_();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    NetworkManager.sendToServer((ResourceLocation)ModPackets.THROW_HAMSTER_ID, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()));
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(entityId.intValue());
            buf.writeBoolean(false);
            NetworkManager.sendToServer((ResourceLocation)ModPackets.UPDATE_HAMSTER_RENDER_STATE_ID, (FriendlyByteBuf)buf);
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
    }

    public static void handleStartFlightSound(int hamsterEntityId) {
        HamsterEntity hamster;
        SoundEvent flightSound;
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            return;
        }
        Entity entity = client.f_91073_.m_6815_(hamsterEntityId);
        if (entity instanceof HamsterEntity && (flightSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_FLYING_SOUNDS, (hamster = (HamsterEntity)entity).m_217043_())) != null) {
            client.m_91106_().m_120367_((SoundInstance)new HamsterFlightSoundInstance(flightSound, SoundSource.NEUTRAL, hamster));
        }
    }

    public static void handleStartThrowSound(int hamsterEntityId) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            return;
        }
        Entity entity = client.f_91073_.m_6815_(hamsterEntityId);
        if (entity instanceof HamsterEntity) {
            HamsterEntity hamster = (HamsterEntity)entity;
            client.m_91106_().m_120367_((SoundInstance)new HamsterThrowSoundInstance((SoundEvent)ModSounds.HAMSTER_THROW.get(), SoundSource.PLAYERS, hamster));
        }
    }
}

