/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.entity.client.ModModelLayers;
import net.dawson.adorablehamsterpets.entity.client.model.HamsterShoulderModel;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class HamsterShoulderFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final float BABY_SCALE = 0.4f;
    private static final float ADULT_SCALE = 0.7f;
    private static final float BABY_Y_OFFSET_SNEAKING = -0.55f;
    private static final float BABY_Y_OFFSET_STANDING = -0.6f;
    private static final float ADULT_Y_OFFSET_SNEAKING = -0.85f;
    private static final float ADULT_Y_OFFSET_STANDING = -1.05f;
    private final EntityModelSet modelLoader;
    @Nullable
    private HamsterShoulderModel hamsterShoulderModel;
    @Nullable
    private ModelPart closedEyesPart;

    public HamsterShoulderFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context, EntityModelSet modelLoader) {
        super(context);
        this.modelLoader = modelLoader;
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        CompoundTag shoulderNbt;
        if (this.hamsterShoulderModel == null) {
            this.initializeModels();
        }
        if ((shoulderNbt = ((PlayerEntityAccessor)player).getHamsterShoulderEntity()).m_128456_() || this.hamsterShoulderModel == null) {
            return;
        }
        Optional<HamsterShoulderData> shoulderDataOpt = HamsterShoulderData.fromNbt(shoulderNbt);
        if (shoulderDataOpt.isEmpty()) {
            return;
        }
        HamsterShoulderData shoulderData = shoulderDataOpt.get();
        this.setCheekVisibility(shoulderData);
        if (this.closedEyesPart != null) {
            this.closedEyesPart.f_104207_ = false;
        }
        this.renderShoulderHamster(matrices, vertexConsumers, light, player, shoulderData);
    }

    private void initializeModels() {
        try {
            this.hamsterShoulderModel = new HamsterShoulderModel(this.modelLoader.m_171103_(ModModelLayers.HAMSTER_SHOULDER_LAYER));
            this.closedEyesPart = this.hamsterShoulderModel.root.m_171324_("body_parent").m_171324_("body_child").m_171324_("head_parent").m_171324_("head_child").m_171324_("closed_eyes");
        }
        catch (Exception e) {
            AdorableHamsterPets.LOGGER.error("[ShoulderRender] Failed to initialize shoulder model lazily. Feature will be disabled.", (Throwable)e);
        }
    }

    private void renderShoulderHamster(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, HamsterShoulderData shoulderData) {
        float scaleFactor;
        matrices.m_85836_();
        boolean isBaby = shoulderData.breedingAge() < 0;
        float f = scaleFactor = isBaby ? 0.4f : 0.7f;
        float yOffset = player.m_6047_() ? (isBaby ? -0.55f : -0.85f) : (isBaby ? -0.6f : -1.05f);
        float xOffset = -0.4f;
        matrices.m_252880_(xOffset, yOffset, 0.0f);
        matrices.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        HamsterVariant variant = HamsterVariant.byId(shoulderData.variantId());
        ResourceLocation baseTextureId = this.getTextureId(variant.getBaseTextureName());
        @Nullable String overlayTextureName = variant.getOverlayTextureName();
        int pinkPetalType = shoulderData.pinkPetalType();
        RenderType baseRenderLayer = RenderType.m_110458_((ResourceLocation)baseTextureId);
        this.hamsterShoulderModel.m_7695_(matrices, vertexConsumers.m_6299_(baseRenderLayer), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (overlayTextureName != null) {
            ResourceLocation overlayTextureId = this.getTextureId(overlayTextureName);
            RenderType overlayRenderLayer = RenderType.m_110473_((ResourceLocation)overlayTextureId);
            this.hamsterShoulderModel.m_7695_(matrices, vertexConsumers.m_6299_(overlayRenderLayer), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (pinkPetalType > 0 && pinkPetalType <= 3) {
            ResourceLocation petalTextureId = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)("textures/entity/hamster/overlay_pink_petal" + pinkPetalType + ".png"));
            RenderType petalRenderLayer = RenderType.m_110473_((ResourceLocation)petalTextureId);
            this.hamsterShoulderModel.m_7695_(matrices, vertexConsumers.m_6299_(petalRenderLayer), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrices.m_85849_();
    }

    private void setCheekVisibility(HamsterShoulderData data) {
        if (this.hamsterShoulderModel.left_cheek_deflated == null || this.hamsterShoulderModel.left_cheek_inflated == null || this.hamsterShoulderModel.right_cheek_deflated == null || this.hamsterShoulderModel.right_cheek_inflated == null) {
            return;
        }
        boolean leftCheekFull = data.leftCheekFull();
        boolean rightCheekFull = data.rightCheekFull();
        this.hamsterShoulderModel.left_cheek_deflated.f_104207_ = !leftCheekFull;
        this.hamsterShoulderModel.left_cheek_inflated.f_104207_ = leftCheekFull;
        this.hamsterShoulderModel.right_cheek_deflated.f_104207_ = !rightCheekFull;
        this.hamsterShoulderModel.right_cheek_inflated.f_104207_ = rightCheekFull;
    }

    private ResourceLocation getTextureId(String textureName) {
        return ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)("textures/entity/hamster/" + textureName + ".png"));
    }
}

