/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.custom;

import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFleeGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFollowOwnerGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAroundGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAtEntityGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMateGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMeleeAttackGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSeekDiamondGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSitGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSleepGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterTemptGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterWanderAroundFarGoal;
import net.dawson.adorablehamsterpets.entity.ImplementedInventory;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.mixin.accessor.LandPathNodeMakerInvoker;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreenHandler;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.dawson.adorablehamsterpets.world.gen.ModEntitySpawns;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterEntity
extends TamableAnimal
implements GeoEntity,
ImplementedInventory,
ExtendedMenuProvider {
    private static final int INVENTORY_SIZE = 6;
    private static final int REFUSE_FOOD_TIMER_TICKS = 40;
    private static final int CUSTOM_LOVE_TICKS = 600;
    private static final float THROW_DAMAGE = 20.0f;
    private static final double THROWN_GRAVITY = -0.05;
    private static final double HAMSTER_ATTACK_BOX_EXPANSION = 0.7;
    public static final int CELEBRATION_PARTICLE_DURATION_TICKS = 600;
    private static final float DEFAULT_FOOTSTEP_VOLUME = 0.1f;
    private static final float GRAVEL_VOLUME_MODIFIER = 0.6f;
    private static final Set<BlockPathTypes> HAZARDOUS_FLOOR_TYPES = EnumSet.of(BlockPathTypes.LAVA, new BlockPathTypes[]{BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.DANGER_FIRE, BlockPathTypes.POWDER_SNOW, BlockPathTypes.DAMAGE_OTHER, BlockPathTypes.DANGER_OTHER, BlockPathTypes.DAMAGE_CAUTIOUS, BlockPathTypes.WATER});
    private static final Set<TagKey<Item>> DISALLOWED_ITEM_TAGS = Set.of(ItemTags.f_271207_, ItemTags.f_271298_, ItemTags.f_271360_, ItemTags.f_271138_, ItemTags.f_271388_, ItemTags.f_265942_, ItemTags.f_13146_, ItemTags.f_13191_, ItemTags.f_13179_, ItemTags.f_13155_, ItemTags.f_13159_);
    private static final Set<Item> DISALLOWED_ITEMS = Set.of(Items.f_42411_, Items.f_42717_, Items.f_42713_, Items.f_42523_, Items.f_42740_, Items.f_42741_, Items.f_42354_, Items.f_42047_, Items.f_42680_, Items.f_42681_, Items.f_42678_, Items.f_42679_, Items.f_42682_, Items.f_42683_, Items.f_260451_, Items.f_42449_, Items.f_42519_, Items.f_42520_, Items.f_42693_, Items.f_42694_, Items.f_42657_, Items.f_42450_, Items.f_42446_, Items.f_42447_, Items.f_42448_, Items.f_42455_, Items.f_151055_, Items.f_151057_, Items.f_220210_, Items.f_42458_, Items.f_42456_, Items.f_42457_, Items.f_42459_, Items.f_42617_, Items.f_151063_, Items.f_42487_, Items.f_42650_, Items.f_42729_, Items.f_151059_, Items.f_42686_, Items.f_42104_, Items.f_151058_, (Item)ModItems.HAMSTER_GUIDE_BOOK.get());
    private static final Set<Item> HAMSTER_FOODS = new HashSet<Item>(Arrays.asList((Item)ModItems.HAMSTER_FOOD_MIX.get(), (Item)ModItems.SUNFLOWER_SEEDS.get(), (Item)ModItems.GREEN_BEANS.get(), (Item)ModItems.CUCUMBER.get(), (Item)ModItems.GREEN_BEAN_SEEDS.get(), (Item)ModItems.CUCUMBER_SEEDS.get(), Items.f_42410_, Items.f_42619_, Items.f_42575_, Items.f_42780_, Items.f_42732_, Items.f_42405_, Items.f_42404_));
    private static final Set<Item> REPEATABLE_FOODS = new HashSet<Item>(Arrays.asList((Item)ModItems.HAMSTER_FOOD_MIX.get(), (Item)ModItems.STEAMED_GREEN_BEANS.get()));
    private static final Set<Item> AUTO_HEAL_FOODS = new HashSet<Item>(List.of((Item)ModItems.HAMSTER_FOOD_MIX.get()));
    private static final List<HamsterVariant> ORANGE_VARIANTS = List.of(HamsterVariant.ORANGE, HamsterVariant.ORANGE_OVERLAY1, HamsterVariant.ORANGE_OVERLAY2, HamsterVariant.ORANGE_OVERLAY3, HamsterVariant.ORANGE_OVERLAY4, HamsterVariant.ORANGE_OVERLAY5, HamsterVariant.ORANGE_OVERLAY6, HamsterVariant.ORANGE_OVERLAY7, HamsterVariant.ORANGE_OVERLAY8);
    private static final List<HamsterVariant> BLACK_VARIANTS = List.of(HamsterVariant.BLACK, HamsterVariant.BLACK_OVERLAY1, HamsterVariant.BLACK_OVERLAY2, HamsterVariant.BLACK_OVERLAY3, HamsterVariant.BLACK_OVERLAY4, HamsterVariant.BLACK_OVERLAY5, HamsterVariant.BLACK_OVERLAY6, HamsterVariant.BLACK_OVERLAY7, HamsterVariant.BLACK_OVERLAY8);
    private static final List<HamsterVariant> BLUE_VARIANTS = List.of(HamsterVariant.BLUE, HamsterVariant.BLUE_OVERLAY1, HamsterVariant.BLUE_OVERLAY2, HamsterVariant.BLUE_OVERLAY3, HamsterVariant.BLUE_OVERLAY4, HamsterVariant.BLUE_OVERLAY5, HamsterVariant.BLUE_OVERLAY6, HamsterVariant.BLUE_OVERLAY7, HamsterVariant.BLUE_OVERLAY8);
    private static final List<HamsterVariant> CHOCOLATE_VARIANTS = List.of(HamsterVariant.CHOCOLATE, HamsterVariant.CHOCOLATE_OVERLAY1, HamsterVariant.CHOCOLATE_OVERLAY2, HamsterVariant.CHOCOLATE_OVERLAY3, HamsterVariant.CHOCOLATE_OVERLAY4, HamsterVariant.CHOCOLATE_OVERLAY5, HamsterVariant.CHOCOLATE_OVERLAY6, HamsterVariant.CHOCOLATE_OVERLAY7, HamsterVariant.CHOCOLATE_OVERLAY8);
    private static final List<HamsterVariant> CREAM_VARIANTS = List.of(HamsterVariant.CREAM, HamsterVariant.CREAM_OVERLAY1, HamsterVariant.CREAM_OVERLAY2, HamsterVariant.CREAM_OVERLAY3, HamsterVariant.CREAM_OVERLAY4, HamsterVariant.CREAM_OVERLAY5, HamsterVariant.CREAM_OVERLAY6, HamsterVariant.CREAM_OVERLAY7, HamsterVariant.CREAM_OVERLAY8);
    private static final List<HamsterVariant> DARK_GRAY_VARIANTS = List.of(HamsterVariant.DARK_GRAY, HamsterVariant.DARK_GRAY_OVERLAY1, HamsterVariant.DARK_GRAY_OVERLAY2, HamsterVariant.DARK_GRAY_OVERLAY3, HamsterVariant.DARK_GRAY_OVERLAY4, HamsterVariant.DARK_GRAY_OVERLAY5, HamsterVariant.DARK_GRAY_OVERLAY6, HamsterVariant.DARK_GRAY_OVERLAY7, HamsterVariant.DARK_GRAY_OVERLAY8);
    private static final List<HamsterVariant> LAVENDER_VARIANTS = List.of(HamsterVariant.LAVENDER, HamsterVariant.LAVENDER_OVERLAY1, HamsterVariant.LAVENDER_OVERLAY2, HamsterVariant.LAVENDER_OVERLAY3, HamsterVariant.LAVENDER_OVERLAY4, HamsterVariant.LAVENDER_OVERLAY5, HamsterVariant.LAVENDER_OVERLAY6, HamsterVariant.LAVENDER_OVERLAY7, HamsterVariant.LAVENDER_OVERLAY8);
    private static final List<HamsterVariant> LIGHT_GRAY_VARIANTS = List.of(HamsterVariant.LIGHT_GRAY, HamsterVariant.LIGHT_GRAY_OVERLAY1, HamsterVariant.LIGHT_GRAY_OVERLAY2, HamsterVariant.LIGHT_GRAY_OVERLAY3, HamsterVariant.LIGHT_GRAY_OVERLAY4, HamsterVariant.LIGHT_GRAY_OVERLAY5, HamsterVariant.LIGHT_GRAY_OVERLAY6, HamsterVariant.LIGHT_GRAY_OVERLAY7, HamsterVariant.LIGHT_GRAY_OVERLAY8);
    private static final List<HamsterVariant> WHITE_VARIANTS = List.of(HamsterVariant.WHITE);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ANIMATION_PERSONALITY_ID = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> IS_SLEEPING = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_SITTING = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_BEGGING = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_IN_LOVE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_REFUSING_FOOD = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_THROWN = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LEFT_CHEEK_FULL = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RIGHT_CHEEK_FULL = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_KNOCKED_OUT = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> PINK_PETAL_TYPE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> CHEEK_POUCH_UNLOCKED = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_CONSIDERING_AUTO_EAT = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DOZING_PHASE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> CURRENT_DEEP_SLEEP_ANIM_ID = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> IS_SULKING = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_CELEBRATING_DIAMOND = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_CLEANING = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> ACTIVE_CUSTOM_GOAL_NAME_DEBUG = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final RawAnimation CRASH_ANIM = RawAnimation.begin().thenPlay("anim_hamster_crash");
    private static final RawAnimation KNOCKED_OUT_ANIM = RawAnimation.begin().thenPlay("anim_hamster_ko");
    private static final RawAnimation WAKE_UP_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup");
    private static final RawAnimation FLYING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_flying");
    private static final RawAnimation NO_ANIM = RawAnimation.begin().thenPlay("anim_hamster_no");
    private static final RawAnimation SLEEP_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose1");
    private static final RawAnimation SLEEP_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose2");
    private static final RawAnimation SLEEP_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose3");
    private static final RawAnimation SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_settle_sleep1");
    private static final RawAnimation SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_settle_sleep2");
    private static final RawAnimation SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_settle_sleep3");
    private static final RawAnimation WILD_SETTLE_SLEEP_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wild_settle_sleep");
    private static final RawAnimation SITTING_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose1");
    private static final RawAnimation SITTING_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose2");
    private static final RawAnimation SITTING_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose3");
    private static final RawAnimation DRIFTING_OFF_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose1");
    private static final RawAnimation DRIFTING_OFF_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose2");
    private static final RawAnimation DRIFTING_OFF_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose3");
    private static final RawAnimation CLEANING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_cleaning");
    private static final RawAnimation RUNNING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_running");
    private static final RawAnimation WALKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_walking");
    private static final RawAnimation BEGGING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_begging");
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_attack");
    private static final RawAnimation SULK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulk");
    private static final RawAnimation SULKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulking");
    public static final RawAnimation SEEKING_DIAMOND_ANIM = RawAnimation.begin().thenPlay("anim_hamster_seeking_diamond");
    public static final RawAnimation WANTS_TO_SEEK_DIAMOND_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wants_to_seek_diamond");
    @Unique
    private int interactionCooldown = 0;
    @Unique
    private int throwTicks = 0;
    @Unique
    public int wakingUpTicks = 0;
    @Unique
    private int ejectionCheckCooldown = 20;
    @Unique
    private int preAutoEatDelayTicks = 0;
    @Unique
    private int quiescentSitDurationTimer = 0;
    @Unique
    private int driftingOffTimer = 0;
    @Unique
    private int settleSleepAnimationCooldown = 0;
    @Unique
    private String activeCustomGoalDebugName = "None";
    @Unique
    public boolean isPrimedToSeekDiamonds = false;
    @Unique
    public long foundOreCooldownEndTick = 0L;
    @Unique
    public BlockPos currentOreTarget = null;
    @Unique
    private int celebrationParticleTicks = 0;
    @Unique
    private int sulkingSoundTicks = 0;
    @Unique
    private int diamondCelebrationSoundTicks = 0;
    @Unique
    private int sulkOrchestraHitDelayTicks = 0;
    @Unique
    private int sulkFailParticleTicks = 0;
    @Unique
    private int sulkEntityEffectTicks = 0;
    @Unique
    private int sulkShockedSoundDelayTicks = 0;
    @Unique
    private int diamondSparkleSoundDelayTicks = 0;
    @Unique
    public transient String particleEffectId = null;
    @Unique
    public transient String soundEffectId = null;
    private final NonNullList<ItemStack> items = ImplementedInventory.create(6);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int refuseTimer = 0;
    private ItemStack lastFoodItem = ItemStack.f_41583_;
    public int customLoveTimer;
    private int tamingCooldown = 0;
    private long throwCooldownEndTick = 0L;
    private long steamedBeansCooldownEndTick = 0L;
    private boolean isAutoEating = false;
    private int autoEatProgressTicks = 0;
    private int autoEatCooldownTicks = 0;
    public int cleaningTimer = 0;
    private int cleaningCooldownTimer = 0;

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    private static HamsterVariant determineVariantForBiome(Holder<Biome> biomeEntry, RandomSource random) {
        boolean lightOrDarkGrayChance;
        int chance;
        String biomeName = biomeEntry.m_203543_().map(k -> k.m_135782_().toString()).orElse("unknown");
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] determineVariantForBiome called for biome: {}", (Object)biomeName);
        HamsterVariant result = ModEntitySpawns.isIceSpikesBiome(biomeEntry) ? (random.m_188503_(10) < 3 ? HamsterEntity.getRandomVariant(WHITE_VARIANTS, random) : HamsterEntity.getRandomVariant(BLUE_VARIANTS, random)) : (ModEntitySpawns.isCherryGroveBiome(biomeEntry) ? HamsterEntity.getRandomVariant(LAVENDER_VARIANTS, random) : (biomeEntry.m_203565_(Biomes.f_48215_) ? HamsterEntity.getRandomVariant(LAVENDER_VARIANTS, random) : (ModEntitySpawns.isSnowyBiome(biomeEntry) ? HamsterEntity.getRandomVariant(WHITE_VARIANTS, random) : (ModEntitySpawns.isOldGrowthBirchForest(biomeEntry) ? HamsterEntity.getRandomVariant(CREAM_VARIANTS, random) : (ModEntitySpawns.isCaveBiome(biomeEntry) ? ((chance = random.m_188503_(4)) < 2 ? HamsterEntity.getRandomVariant(BLACK_VARIANTS, random) : (chance == 2 ? HamsterEntity.getRandomVariant(DARK_GRAY_VARIANTS, random) : HamsterEntity.getRandomVariant(LIGHT_GRAY_VARIANTS, random))) : (ModEntitySpawns.isSwampBiome(biomeEntry) ? HamsterEntity.getRandomVariant(BLACK_VARIANTS, random) : (ModEntitySpawns.isDesertBiome(biomeEntry) ? HamsterEntity.getRandomVariant(CREAM_VARIANTS, random) : (biomeEntry.m_203656_(BiomeTags.f_207607_) ? HamsterEntity.getRandomVariant(ORANGE_VARIANTS, random) : (biomeEntry.m_203656_(BiomeTags.f_207604_) && !ModEntitySpawns.isSnowyBiome(biomeEntry) ? HamsterEntity.getRandomVariant(CREAM_VARIANTS, random) : ((biomeEntry.m_203656_(BiomeTags.f_207611_) || biomeEntry.m_203656_(BiomeTags.f_207609_) || ModEntitySpawns.isJungleBiome(biomeEntry)) && !ModEntitySpawns.isSnowyBiome(biomeEntry) && !ModEntitySpawns.isCherryGroveBiome(biomeEntry) && !ModEntitySpawns.isOldGrowthBirchForest(biomeEntry) ? HamsterEntity.getRandomVariant(CHOCOLATE_VARIANTS, random) : (biomeEntry.m_203656_(BiomeTags.f_215816_) || ModEntitySpawns.isPlainsBiome(biomeEntry) ? HamsterEntity.getRandomVariant(ORANGE_VARIANTS, random) : ((biomeEntry.m_203656_(BiomeTags.f_207606_) || biomeEntry.m_203565_(Biomes.f_186760_) || ModEntitySpawns.isWindsweptOrStonyPeaks(biomeEntry)) && !ModEntitySpawns.isSnowyBiome(biomeEntry) && !ModEntitySpawns.isIceSpikesBiome(biomeEntry) ? ((lightOrDarkGrayChance = random.m_188499_()) ? HamsterEntity.getRandomVariant(DARK_GRAY_VARIANTS, random) : HamsterEntity.getRandomVariant(LIGHT_GRAY_VARIANTS, random)) : HamsterEntity.getRandomVariant(ORANGE_VARIANTS, random)))))))))))));
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] Determined variant for {} is {}", (Object)biomeName, (Object)result.name());
        return result;
    }

    private static HamsterVariant getRandomVariant(List<HamsterVariant> variantPool, RandomSource random) {
        if (variantPool == null || variantPool.isEmpty()) {
            return HamsterVariant.ORANGE;
        }
        return variantPool.get(random.m_188503_(variantPool.size()));
    }

    private static List<HamsterVariant> getPoolForBaseVariant(HamsterVariant baseVariant) {
        return switch (baseVariant) {
            case HamsterVariant.ORANGE -> ORANGE_VARIANTS;
            case HamsterVariant.BLACK -> BLACK_VARIANTS;
            case HamsterVariant.BLUE -> BLUE_VARIANTS;
            case HamsterVariant.CHOCOLATE -> CHOCOLATE_VARIANTS;
            case HamsterVariant.CREAM -> CREAM_VARIANTS;
            case HamsterVariant.DARK_GRAY -> DARK_GRAY_VARIANTS;
            case HamsterVariant.LAVENDER -> LAVENDER_VARIANTS;
            case HamsterVariant.LIGHT_GRAY -> LIGHT_GRAY_VARIANTS;
            case HamsterVariant.WHITE -> WHITE_VARIANTS;
            default -> ORANGE_VARIANTS;
        };
    }

    public static AttributeSupplier.Builder createHamsterAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22281_, ((Double)Configs.AHP.meleeDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, 40.0);
    }

    @Nullable
    public static HamsterEntity createFromNbt(ServerLevel world, Player player, CompoundTag nbt) {
        Optional<HamsterShoulderData> dataOpt = HamsterShoulderData.fromNbt(nbt);
        if (dataOpt.isEmpty()) {
            AdorableHamsterPets.LOGGER.error("Failed to deserialize HamsterShoulderData from NBT: {}", (Object)nbt);
            return null;
        }
        HamsterShoulderData data = dataOpt.get();
        AdorableHamsterPets.LOGGER.debug("[HamsterEntity] createFromNbt called for player {} with data: {}", (Object)player.m_7755_().getString(), (Object)data);
        HamsterEntity hamster = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).m_20615_((Level)world);
        if (hamster != null) {
            hamster.setVariant(data.variantId());
            hamster.m_21153_(data.health());
            hamster.m_21816_(player.m_20148_());
            hamster.setTamed(true, true);
            hamster.m_146762_(data.breedingAge());
            hamster.throwCooldownEndTick = data.throwCooldownEndTick();
            hamster.steamedBeansCooldownEndTick = data.steamedBeansCooldownEndTick();
            hamster.autoEatCooldownTicks = data.autoEatCooldownTicks();
            hamster.m_20088_().m_135381_(PINK_PETAL_TYPE, (Object)data.pinkPetalType());
            hamster.m_20088_().m_135381_(CHEEK_POUCH_UNLOCKED, (Object)data.cheekPouchUnlocked());
            hamster.m_20088_().m_135381_(ANIMATION_PERSONALITY_ID, (Object)data.animationPersonalityId());
            data.customName().ifPresent(name -> {
                if (!name.isEmpty()) {
                    hamster.m_6593_((Component)Component.m_237113_((String)name));
                }
            });
            if (!data.inventoryNbt().m_128456_()) {
                ContainerHelper.m_18980_((CompoundTag)data.inventoryNbt(), hamster.items);
                hamster.updateCheekTrackers();
            }
            ListTag effectsList = data.activeEffectsNbt();
            for (Tag effectElement : effectsList) {
                CompoundTag effectInstanceNbt;
                MobEffectInstance effectInstance;
                if (!(effectElement instanceof CompoundTag) || (effectInstance = MobEffectInstance.m_19560_((CompoundTag)(effectInstanceNbt = (CompoundTag)effectElement))) == null) continue;
                hamster.m_7292_(effectInstance);
            }
            HamsterShoulderData.SeekingBehaviorData seekingData = data.seekingBehaviorData();
            hamster.isPrimedToSeekDiamonds = seekingData.isPrimedToSeekDiamonds();
            hamster.foundOreCooldownEndTick = seekingData.foundOreCooldownEndTick();
            hamster.currentOreTarget = seekingData.currentOreTarget().orElse(null);
            hamster.m_20088_().m_135381_(IS_SULKING, (Object)seekingData.isSulking());
            hamster.isAutoEating = false;
            hamster.autoEatProgressTicks = 0;
        }
        return hamster;
    }

    public static void spawnFromNbt(ServerLevel world, Player player, CompoundTag nbt, boolean wasDiamondAlertActive) {
        HamsterEntity hamster = HamsterEntity.createFromNbt(world, player, nbt);
        if (hamster == null) {
            return;
        }
        if (wasDiamondAlertActive && Configs.AHP.enableIndependentDiamondSeeking) {
            hamster.isPrimedToSeekDiamonds = true;
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity {}] Primed for diamond seeking upon dismount.", (Object)hamster.m_19879_());
        }
        BlockPos ultimateFallbackPos = player.m_20183_();
        HitResult hitResult = player.m_19907_(4.5, 0.0f, false);
        BlockPos initialSearchPos = hitResult.m_6662_() == HitResult.Type.BLOCK ? ((BlockHitResult)hitResult).m_82425_() : ultimateFallbackPos;
        Optional<BlockPos> safePosOpt = hamster.findSafeSpawnPosition(initialSearchPos, (Level)world, 5);
        safePosOpt.ifPresentOrElse(safePos -> {
            hamster.m_7678_((double)safePos.m_123341_() + 0.5, safePos.m_123342_(), (double)safePos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            AdorableHamsterPets.LOGGER.debug("[HamsterDismount] Found safe spawn at {} for player {}.", safePos, (Object)player.m_7755_().getString());
        }, () -> {
            AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Could not find a safe spawn position for player {}. Spawning at player's feet as a fallback.", (Object)player.m_7755_().getString());
            hamster.m_7678_((double)ultimateFallbackPos.m_123341_() + 0.5, ultimateFallbackPos.m_123342_(), (double)ultimateFallbackPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        });
        world.m_47205_((Entity)hamster);
        AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned Hamster ID {} from NBT data near Player {}.", (Object)hamster.m_19879_(), (Object)player.m_7755_().getString());
    }

    public static void tryThrowFromShoulder(ServerPlayer player) {
        Level world = player.m_9236_();
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        CompoundTag shoulderNbt = playerAccessor.getHamsterShoulderEntity();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (shoulderNbt.m_128456_()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterEntity] tryThrowFromShoulder: Player {} received throw packet but had no shoulder data.", (Object)player.m_7755_().getString());
            return;
        }
        if (!config.enableHamsterThrowing) {
            player.m_5661_((Component)Component.m_237113_((String)"Hamster throwing is disabled in config."), true);
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        HamsterEntity hamster = HamsterEntity.createFromNbt(serverWorld, (Player)player, shoulderNbt);
        if (hamster != null) {
            if (hamster.m_6162_()) {
                player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.baby_throw_refusal").m_130940_(ChatFormatting.RED), true);
                return;
            }
            long currentTime = world.m_46467_();
            if (hamster.throwCooldownEndTick > currentTime) {
                long remainingTicks = hamster.throwCooldownEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.throw_cooldown", (Object[])new Object[]{minutes, seconds}).m_130940_(ChatFormatting.RED), true);
                return;
            }
            playerAccessor.setHamsterShoulderEntity(new CompoundTag());
            hamster.m_7678_(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_(), player.m_146908_(), player.m_146909_());
            hamster.setThrown(true);
            hamster.interactionCooldown = 10;
            hamster.throwTicks = 0;
            hamster.throwCooldownEndTick = currentTime + (long)((Integer)config.hamsterThrowCooldown.get()).intValue();
            float throwSpeed = 1.5f;
            Vec3 lookVec = player.m_20252_(1.0f);
            Vec3 throwVec = new Vec3(lookVec.f_82479_, lookVec.f_82480_ + (double)0.1f, lookVec.f_82481_).m_82541_();
            hamster.m_20256_(throwVec.m_82490_((double)throwSpeed));
            hamster.f_19812_ = true;
            serverWorld.m_7967_((Entity)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] tryThrowFromShoulder: Spawned thrown Hamster ID {}.", (Object)hamster.m_19879_());
            FriendlyByteBuf flightBuf = new FriendlyByteBuf(Unpooled.buffer());
            flightBuf.writeInt(hamster.m_19879_());
            FriendlyByteBuf throwBuf = new FriendlyByteBuf(Unpooled.buffer());
            throwBuf.writeInt(hamster.m_19879_());
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ModPackets.START_HAMSTER_FLIGHT_SOUND_ID, (FriendlyByteBuf)flightBuf);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ModPackets.START_HAMSTER_THROW_SOUND_ID, (FriendlyByteBuf)throwBuf);
            double radius = 64.0;
            Vec3 hamsterPos = hamster.m_20182_();
            AABB searchBox = new AABB(hamsterPos.m_82492_(radius, radius, radius), hamsterPos.m_82520_(radius, radius, radius));
            List nearbyPlayers = serverWorld.m_8795_(p -> p != player && searchBox.m_82390_(p.m_20182_()));
            FriendlyByteBuf flightBufNearby = new FriendlyByteBuf(Unpooled.buffer());
            flightBufNearby.writeInt(hamster.m_19879_());
            FriendlyByteBuf throwBufNearby = new FriendlyByteBuf(Unpooled.buffer());
            throwBufNearby.writeInt(hamster.m_19879_());
            NetworkManager.sendToPlayers((Iterable)nearbyPlayers, (ResourceLocation)ModPackets.START_HAMSTER_FLIGHT_SOUND_ID, (FriendlyByteBuf)flightBufNearby);
            NetworkManager.sendToPlayers((Iterable)nearbyPlayers, (ResourceLocation)ModPackets.START_HAMSTER_THROW_SOUND_ID, (FriendlyByteBuf)throwBufNearby);
            ModCriteria.HAMSTER_THROWN.trigger(player);
        } else {
            AdorableHamsterPets.LOGGER.error("[HamsterEntity] tryThrowFromShoulder: Failed to create HamsterEntity instance from NBT. Clearing shoulder data as a precaution.");
            playerAccessor.setHamsterShoulderEntity(new CompoundTag());
        }
    }

    private static boolean isIsFood(ItemStack stack) {
        return HAMSTER_FOODS.contains(stack.m_41720_());
    }

    public HamsterEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 3;
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variantId) {
        this.f_19804_.m_135381_(VARIANT, (Object)variantId);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(IS_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(IS_SLEEPING, (Object)sleeping);
    }

    public boolean m_21827_() {
        return (Boolean)this.f_19804_.m_135370_(IS_SITTING) != false || (Boolean)this.f_19804_.m_135370_(IS_SLEEPING) != false || (Boolean)this.f_19804_.m_135370_(IS_KNOCKED_OUT) != false || (Boolean)this.f_19804_.m_135370_(IS_SULKING) != false;
    }

    public boolean isBegging() {
        return (Boolean)this.f_19804_.m_135370_(IS_BEGGING);
    }

    public void setBegging(boolean value) {
        this.f_19804_.m_135381_(IS_BEGGING, (Object)value);
    }

    public boolean m_27593_() {
        return (Boolean)this.f_19804_.m_135370_(IS_IN_LOVE);
    }

    public void setInLove(boolean value) {
        this.f_19804_.m_135381_(IS_IN_LOVE, (Object)value);
    }

    public boolean isRefusingFood() {
        return (Boolean)this.f_19804_.m_135370_(IS_REFUSING_FOOD);
    }

    public void setRefusingFood(boolean value) {
        this.f_19804_.m_135381_(IS_REFUSING_FOOD, (Object)value);
    }

    public boolean isThrown() {
        return (Boolean)this.f_19804_.m_135370_(IS_THROWN);
    }

    public void setThrown(boolean thrown) {
        this.f_19804_.m_135381_(IS_THROWN, (Object)thrown);
    }

    public boolean isLeftCheekFull() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_CHEEK_FULL);
    }

    public void setLeftCheekFull(boolean full) {
        this.f_19804_.m_135381_(LEFT_CHEEK_FULL, (Object)full);
    }

    public boolean isRightCheekFull() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_CHEEK_FULL);
    }

    public void setRightCheekFull(boolean full) {
        this.f_19804_.m_135381_(RIGHT_CHEEK_FULL, (Object)full);
    }

    public boolean isKnockedOut() {
        return (Boolean)this.f_19804_.m_135370_(IS_KNOCKED_OUT);
    }

    public void setKnockedOut(boolean knocked_out) {
        this.f_19804_.m_135381_(IS_KNOCKED_OUT, (Object)knocked_out);
    }

    public String getCurrentDeepSleepAnimationIdFromTracker() {
        return (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID);
    }

    public boolean isAutoEating() {
        return this.isAutoEating;
    }

    public boolean isConsideringAutoEat() {
        return (Boolean)this.f_19804_.m_135370_(IS_CONSIDERING_AUTO_EAT);
    }

    public DozingPhase getDozingPhase() {
        return DozingPhase.values()[(Integer)this.f_19804_.m_135370_(DOZING_PHASE)];
    }

    public void setDozingPhase(DozingPhase phase) {
        this.f_19804_.m_135381_(DOZING_PHASE, (Object)phase.ordinal());
    }

    public void setActiveCustomGoalDebugName(String name) {
        this.f_19804_.m_135381_(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)name);
    }

    public String getActiveCustomGoalDebugName() {
        String goalName = (String)this.f_19804_.m_135370_(ACTIVE_CUSTOM_GOAL_NAME_DEBUG);
        return goalName;
    }

    public boolean isSulking() {
        return (Boolean)this.f_19804_.m_135370_(IS_SULKING);
    }

    public boolean isCelebratingDiamond() {
        return (Boolean)this.f_19804_.m_135370_(IS_CELEBRATING_DIAMOND);
    }

    public void setCelebratingDiamond(boolean celebrating) {
        this.f_19804_.m_135381_(IS_CELEBRATING_DIAMOND, (Object)celebrating);
        if (celebrating) {
            this.setBegging(false);
            if (!this.m_9236_().m_5776_()) {
                this.celebrationParticleTicks = 600;
                this.diamondSparkleSoundDelayTicks = 10;
            }
        } else {
            this.celebrationParticleTicks = 0;
            this.diamondSparkleSoundDelayTicks = 0;
            this.diamondCelebrationSoundTicks = 0;
        }
    }

    public void setSulking(boolean sulking) {
        this.f_19804_.m_135381_(IS_SULKING, (Object)sulking);
        if (sulking) {
            if (!this.m_9236_().m_5776_()) {
                this.sulkOrchestraHitDelayTicks = 10;
                this.sulkShockedSoundDelayTicks = 44;
                this.sulkFailParticleTicks = 600;
                this.sulkEntityEffectTicks = 600;
            }
        } else {
            this.sulkOrchestraHitDelayTicks = 0;
            this.sulkFailParticleTicks = 0;
            this.sulkEntityEffectTicks = 0;
        }
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void m_6596_() {
        if (!this.m_9236_().m_5776_()) {
            this.updateCheekTrackers();
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        return new HamsterInventoryScreenHandler(syncId, playerInventory, this);
    }

    public Component m_5446_() {
        return this.m_8077_() ? this.m_7770_() : Component.m_237115_((String)"entity.adorablehamsterpets.hamster.inventory_title");
    }

    @Override
    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot < 0 || slot >= 6) {
            return false;
        }
        return !this.isItemDisallowed(stack);
    }

    public void updateCheekTrackers() {
        LivingEntity livingEntity;
        boolean leftFull = false;
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            leftFull = true;
            break;
        }
        boolean rightFull = false;
        for (int i = 3; i < 6; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            rightFull = true;
            break;
        }
        if (this.isLeftCheekFull() != leftFull) {
            this.setLeftCheekFull(leftFull);
        }
        if (this.isRightCheekFull() != rightFull) {
            this.setRightCheekFull(rightFull);
        }
        if (!this.m_9236_().m_5776_() && (livingEntity = this.m_269323_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
            boolean allSlotsFilled = true;
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
                allSlotsFilled = false;
                break;
            }
            if (allSlotsFilled) {
                ModCriteria.HAMSTER_POUCH_FILLED.trigger(serverPlayerOwner, this);
            }
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("HamsterVariant", this.getVariant());
        if (this.m_21824_()) {
            nbt.m_128379_("Sitting", ((Boolean)this.f_19804_.m_135370_(IS_SITTING)).booleanValue());
        }
        nbt.m_128379_("KnockedOut", this.isKnockedOut());
        nbt.m_128356_("ThrowCooldownEnd", this.throwCooldownEndTick);
        nbt.m_128356_("SteamedBeansCooldownEnd", this.steamedBeansCooldownEndTick);
        nbt.m_128405_("AutoEatCooldown", this.autoEatCooldownTicks);
        nbt.m_128405_("EjectionCheckCooldown", this.ejectionCheckCooldown);
        nbt.m_128405_("PinkPetalType", ((Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE)).intValue());
        nbt.m_128379_("CheekPouchUnlocked", ((Boolean)this.f_19804_.m_135370_(CHEEK_POUCH_UNLOCKED)).booleanValue());
        nbt.m_128405_("AnimationPersonalityId", ((Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID)).intValue());
        nbt.m_128405_("DozingPhase", this.getDozingPhase().ordinal());
        nbt.m_128359_("CurrentDeepSleepAnimId", (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID));
        nbt.m_128405_("QuiescentSitTimer", this.quiescentSitDurationTimer);
        nbt.m_128405_("DriftingOffTimer", this.driftingOffTimer);
        nbt.m_128405_("SettleSleepCooldown", this.settleSleepAnimationCooldown);
        CompoundTag inventoryWrapperNbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inventoryWrapperNbt, this.items);
        nbt.m_128365_("Inventory", (Tag)inventoryWrapperNbt);
        nbt.m_128379_("IsPrimedToSeekDiamonds", this.isPrimedToSeekDiamonds);
        nbt.m_128356_("FoundOreCooldownEndTick", this.foundOreCooldownEndTick);
        if (this.currentOreTarget != null) {
            nbt.m_128405_("OreTargetX", this.currentOreTarget.m_123341_());
            nbt.m_128405_("OreTargetY", this.currentOreTarget.m_123342_());
            nbt.m_128405_("OreTargetZ", this.currentOreTarget.m_123343_());
        }
        nbt.m_128379_("IsSulking", ((Boolean)this.f_19804_.m_135370_(IS_SULKING)).booleanValue());
        nbt.m_128379_("IsCelebratingDiamond", ((Boolean)this.f_19804_.m_135370_(IS_CELEBRATING_DIAMOND)).booleanValue());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        AdorableHamsterPets.LOGGER.debug("[NBT Read {}] Start reading NBT data.", (Object)this.m_19879_());
        this.setVariant(nbt.m_128451_("HamsterVariant"));
        if (this.m_21824_()) {
            boolean wasSittingNbt = nbt.m_128471_("Sitting");
            this.setSitting(wasSittingNbt, true);
        } else {
            this.setSitting(false, true);
        }
        this.setKnockedOut(nbt.m_128471_("KnockedOut"));
        this.throwCooldownEndTick = nbt.m_128454_("ThrowCooldownEnd");
        this.steamedBeansCooldownEndTick = nbt.m_128454_("SteamedBeansCooldownEnd");
        this.autoEatCooldownTicks = nbt.m_128451_("AutoEatCooldown");
        this.ejectionCheckCooldown = nbt.m_128425_("EjectionCheckCooldown", 3) ? nbt.m_128451_("EjectionCheckCooldown") : 20;
        this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)nbt.m_128451_("PinkPetalType"));
        this.f_19804_.m_135381_(CHEEK_POUCH_UNLOCKED, (Object)nbt.m_128471_("CheekPouchUnlocked"));
        this.f_19804_.m_135381_(ANIMATION_PERSONALITY_ID, (Object)nbt.m_128451_("AnimationPersonalityId"));
        if (nbt.m_128425_("DozingPhase", 3)) {
            int phaseOrdinal = nbt.m_128451_("DozingPhase");
            if (phaseOrdinal >= 0 && phaseOrdinal < DozingPhase.values().length) {
                this.setDozingPhase(DozingPhase.values()[phaseOrdinal]);
            } else {
                this.setDozingPhase(DozingPhase.NONE);
            }
        } else {
            this.setDozingPhase(DozingPhase.NONE);
        }
        this.f_19804_.m_135381_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)nbt.m_128461_("CurrentDeepSleepAnimId"));
        this.quiescentSitDurationTimer = nbt.m_128451_("QuiescentSitTimer");
        this.driftingOffTimer = nbt.m_128451_("DriftingOffTimer");
        this.settleSleepAnimationCooldown = nbt.m_128451_("SettleSleepCooldown");
        this.items.clear();
        if (nbt.m_128425_("Inventory", 10)) {
            ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("Inventory"), this.items);
        }
        this.updateCheekTrackers();
        this.isPrimedToSeekDiamonds = nbt.m_128471_("IsPrimedToSeekDiamonds");
        this.foundOreCooldownEndTick = nbt.m_128454_("FoundOreCooldownEndTick");
        this.currentOreTarget = nbt.m_128441_("OreTargetX") && nbt.m_128441_("OreTargetY") && nbt.m_128441_("OreTargetZ") ? new BlockPos(nbt.m_128451_("OreTargetX"), nbt.m_128451_("OreTargetY"), nbt.m_128451_("OreTargetZ")) : null;
        this.f_19804_.m_135381_(IS_SULKING, (Object)nbt.m_128471_("IsSulking"));
        this.f_19804_.m_135381_(IS_CELEBRATING_DIAMOND, (Object)nbt.m_128471_("IsCelebratingDiamond"));
    }

    public HamsterShoulderData saveToShoulderData() {
        this.updateCheekTrackers();
        CompoundTag inventoryNbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inventoryNbt, this.items);
        CompoundTag effectsNbt = new CompoundTag();
        ListTag effectsList = new ListTag();
        for (MobEffectInstance effectInstance : this.m_21220_()) {
            effectsList.add((Object)effectInstance.m_19555_(new CompoundTag()));
        }
        Optional<String> nameOptional = Optional.ofNullable(this.m_7770_()).map(Component::getString);
        HamsterShoulderData.SeekingBehaviorData seekingData = new HamsterShoulderData.SeekingBehaviorData(this.isPrimedToSeekDiamonds, this.foundOreCooldownEndTick, Optional.ofNullable(this.currentOreTarget), (Boolean)this.m_20088_().m_135370_(IS_SULKING));
        return new HamsterShoulderData(this.getVariant(), this.m_21223_(), inventoryNbt, this.isLeftCheekFull(), this.isRightCheekFull(), this.m_146764_(), this.throwCooldownEndTick, this.steamedBeansCooldownEndTick, effectsList, this.autoEatCooldownTicks, nameOptional, (Integer)this.m_20088_().m_135370_(PINK_PETAL_TYPE), (Boolean)this.m_20088_().m_135370_(CHEEK_POUCH_UNLOCKED), (Integer)this.m_20088_().m_135370_(ANIMATION_PERSONALITY_ID), seekingData);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void m_19884_(double cursorX, double cursorY) {
        if (this.m_5803_()) {
            return;
        }
        super.m_19884_(cursorX, cursorY);
    }

    public void m_21839_(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean suppressSound) {
        if (!sitting && this.m_21824_() && this.getDozingPhase() != DozingPhase.NONE) {
            this.resetSleepSequence("Player commanded hamster to stand up.");
        }
        this.f_19804_.m_135381_(IS_SITTING, (Object)sitting);
        this.m_21837_(sitting);
        if (sitting) {
            this.cleaningTimer = 0;
        } else {
            this.quiescentSitDurationTimer = 0;
            this.cleaningTimer = 0;
            if (((Boolean)this.f_19804_.m_135370_(IS_CLEANING)).booleanValue()) {
                this.f_19804_.m_135381_(IS_CLEANING, (Object)false);
            }
        }
    }

    public boolean m_217066_(LivingEntity entity) {
        AABB hamsterBox = this.m_20191_();
        AABB attackBox = hamsterBox.m_82377_(0.7, 0.0, 0.7);
        boolean intersects = attackBox.m_82381_(entity.m_20191_());
        return intersects;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        TraceableEntity ownableFallback;
        Entity fallbackOwnerEntity;
        AbstractHorse horsePet;
        LivingEntity horseOwnerEntity;
        TamableAnimal tameablePet;
        UUID petOwnerUuid;
        UUID ownerUuid = owner.m_20148_();
        if (target == this || target == owner) {
            return false;
        }
        if (target instanceof Player && target.m_20148_().equals(ownerUuid)) {
            return false;
        }
        if (target instanceof Creeper || target instanceof ArmorStand) {
            return false;
        }
        return !(target instanceof TamableAnimal ? (petOwnerUuid = (tameablePet = (TamableAnimal)target).m_21805_()) != null && petOwnerUuid.equals(ownerUuid) : (target instanceof AbstractHorse ? (horseOwnerEntity = (horsePet = (AbstractHorse)target).m_269323_()) != null && horseOwnerEntity.m_20148_().equals(ownerUuid) : target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).m_19749_()) != null && fallbackOwnerEntity.m_20148_().equals(ownerUuid)));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Level world = this.m_9236_();
        AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Interaction start. Player: {}, Hand: {}, Item: {}", new Object[]{this.m_19879_(), world.m_46467_(), player.m_7755_().getString(), hand, stack.m_41720_()});
        if (this.isKnockedOut()) {
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Hamster is knocked out. Waking up.", (Object)this.m_19879_(), (Object)world.m_46467_());
            if (!world.m_5776_()) {
                SoundEvent wakeUpSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_WAKE_UP_SOUNDS, this.f_19796_);
                if (wakeUpSound != null) {
                    world.m_5594_(null, this.m_20183_(), wakeUpSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                this.setKnockedOut(false);
                this.setSitting(false, true);
                this.triggerAnimOnServer("mainController", "wakeup");
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (this.isCelebratingDiamond()) {
            if (!world.m_5776_()) {
                this.setCelebratingDiamond(false);
                this.setSitting(false, true);
                SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_);
                if (affectionSound != null) {
                    world.m_5594_(null, this.m_20183_(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.m_6100_());
                } else {
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.5f, 1.5f);
                }
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (this.isSulking()) {
            if (!world.m_5776_()) {
                this.setSulking(false);
                this.setSitting(false, true);
                SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_);
                if (affectionSound != null) {
                    world.m_5594_(null, this.m_20183_(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.m_6100_());
                } else {
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_11754_, SoundSource.NEUTRAL, 0.5f, 1.5f);
                }
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (this.interactionCooldown > 0) {
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Interaction cooldown active ({} ticks left). Passing.", new Object[]{this.m_19879_(), world.m_46467_(), this.interactionCooldown});
            return InteractionResult.PASS;
        }
        if (player.m_6144_() && stack.m_150930_((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) {
            if (!world.f_46443_) {
                boolean newSetting;
                AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
                boolean currentSetting = currentConfig.enableJadeHamsterDebugInfo;
                currentConfig.enableJadeHamsterDebugInfo = newSetting = !currentSetting;
                currentConfig.save();
                MutableComponent message = Component.m_237115_((String)(newSetting ? "message.adorablehamsterpets.debug_overlay_enabled" : "message.adorablehamsterpets.debug_overlay_disabled")).m_130940_(newSetting ? ChatFormatting.GREEN : ChatFormatting.RED);
                player.m_5661_((Component)message, true);
                AdorableHamsterPets.LOGGER.info("Player {} toggled Jade Hamster Debug Info via Guide Book to: {} for hamster {}", new Object[]{player.m_7755_().getString(), newSetting, this.m_19879_()});
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && stack.m_150930_(Items.f_271209_) && !player.m_6144_()) {
            if (!world.f_46443_) {
                if (this.getDozingPhase() != DozingPhase.NONE) {
                    this.resetSleepSequence("Player interacted with pink petals.");
                }
                int currentPetalType = (Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE);
                int nextPetalType = currentPetalType % 3 + 1;
                this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)nextPetalType);
                world.m_5594_(null, this.m_20183_(), SoundEvents.f_271130_, SoundSource.PLAYERS, 0.7f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175832_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.75, this.m_20189_(), 7, (double)(this.m_20205_() / 2.0f), (double)(this.m_20206_() / 2.0f), (double)(this.m_20205_() / 2.0f), 0.0);
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                AdorableHamsterPets.LOGGER.debug("[InteractMob {}] Cycled/Applied pink petal to type {}.", (Object)this.m_19879_(), (Object)nextPetalType);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModCriteria.APPLIED_PINK_PETAL.trigger(serverPlayer, this);
                }
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && stack.m_150930_(Items.f_42574_) && !player.m_6144_() && (Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE) > 0) {
            if (!world.f_46443_) {
                if (this.getDozingPhase() != DozingPhase.NONE) {
                    this.resetSleepSequence("Player used shears (removed petals).");
                }
                this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)0);
                world.m_5594_(null, this.m_20183_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 0.9f, 1.0f + this.f_19796_.m_188501_() * 0.1f);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    serverWorld.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_271209_)), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), 5, (double)(this.m_20205_() / 2.0f), (double)(this.m_20206_() / 2.0f), (double)(this.m_20205_() / 2.0f), 0.05);
                }
                Containers.m_18992_((Level)world, (double)this.m_20185_(), (double)(this.m_20186_() + 0.5), (double)this.m_20189_(), (ItemStack)new ItemStack((ItemLike)Items.f_271209_, 1));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
                }
                AdorableHamsterPets.LOGGER.debug("[InteractMob {}] Removed pink petals with shears.", (Object)this.m_19879_());
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (!this.m_21824_()) {
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Hamster not tamed. Checking for taming attempt.", (Object)this.m_19879_(), (Object)world.m_46467_());
            if (player.m_6144_() && stack.m_150930_((Item)ModItems.SLICED_CUCUMBER.get())) {
                AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Taming attempt detected.", (Object)this.m_19879_(), (Object)world.m_46467_());
                if (!world.f_46443_) {
                    this.tryTame(player, stack);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Not a taming attempt. Calling super.interactMob for untamed.", (Object)this.m_19879_(), (Object)world.m_46467_());
            return super.m_6071_(player, hand);
        }
        if (this.m_21830_((LivingEntity)player)) {
            boolean isPotentialFood;
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Player is owner. Processing owner interactions.", (Object)this.m_19879_(), (Object)world.m_46467_());
            boolean isSneaking = player.m_6144_();
            PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
            if (!isSneaking && stack.m_150930_((Item)ModItems.CHEESE.get())) {
                if (!world.f_46443_) {
                    if (playerAccessor.getHamsterShoulderEntity().m_128456_()) {
                        if (this.getDozingPhase() != DozingPhase.NONE) {
                            this.resetSleepSequence("Player mounted hamster with cheese.");
                        }
                        HamsterShoulderData data = this.saveToShoulderData();
                        CompoundTag hamsterNbt = data.toNbt();
                        playerAccessor.setHamsterShoulderEntity(hamsterNbt);
                        BlockPos hamsterPosForCheeseSound = this.m_20183_();
                        this.m_146870_();
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            ModCriteria.HAMSTER_ON_SHOULDER.trigger(serverPlayer);
                        }
                        player.m_5661_((Component)Component.m_237113_((String)"Your hamster scurries onto your shoulder!"), true);
                        world.m_5594_(null, hamsterPosForCheeseSound, (SoundEvent)ModSounds.CHEESE_USE_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        SoundEvent mountSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SHOULDER_MOUNT_SOUNDS, this.f_19796_);
                        if (mountSound != null) {
                            world.m_5594_(null, player.m_20183_(), mountSound, SoundSource.PLAYERS, 1.0f, this.m_6100_());
                        }
                        ((ServerLevel)world).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModItems.CHEESE.get())), (double)hamsterPosForCheeseSound.m_123341_() + 0.5, (double)hamsterPosForCheeseSound.m_123342_() + 0.5, (double)hamsterPosForCheeseSound.m_123343_() + 0.5, 8, 0.25, 0.25, 0.25, 0.05);
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237113_((String)"Your shoulder is already occupied!"), true);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (!world.m_5776_() && isSneaking) {
                if (((Boolean)this.f_19804_.m_135370_(CHEEK_POUCH_UNLOCKED)).booleanValue() || !AdorableHamsterPets.CONFIG.requireFoodMixToUnlockCheeks) {
                    if (this.getDozingPhase() != DozingPhase.NONE) {
                        this.resetSleepSequence("Player accessed inventory.");
                    }
                    MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)this);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.cheek_pouch_locked").m_130940_(ChatFormatting.WHITE), true);
                }
                return InteractionResult.CONSUME;
            }
            boolean bl = isPotentialFood = HamsterEntity.isIsFood(stack) || stack.m_150930_((Item)ModItems.STEAMED_GREEN_BEANS.get());
            if (!world.m_5776_() && !isSneaking && isPotentialFood) {
                AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Owner not sneaking, holding potential food. Checking refusal.", (Object)this.m_19879_(), (Object)world.m_46467_());
                if (this.getDozingPhase() != DozingPhase.NONE) {
                    this.resetSleepSequence("Player attempted to feed hamster.");
                }
                if (this.checkRepeatFoodRefusal(stack, player)) {
                    AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Food refused. Consuming interaction.", (Object)this.m_19879_(), (Object)world.m_46467_());
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Attempting feeding via tryFeedingAsTamed.", (Object)this.m_19879_(), (Object)world.m_46467_());
                boolean feedingOccurred = this.tryFeedingAsTamed(player, stack);
                if (feedingOccurred) {
                    AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] tryFeedingAsTamed returned true. Setting last food, decrementing stack.", (Object)this.m_19879_(), (Object)world.m_46467_());
                    this.lastFoodItem = stack.m_41777_();
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] tryFeedingAsTamed returned false. Passing to vanilla/sitting.", (Object)this.m_19879_(), (Object)world.m_46467_());
            }
            if (!(isSneaking || isPotentialFood || stack.m_150930_((Item)ModItems.CHEESE.get()) || stack.m_150930_(Items.f_271209_))) {
                AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Not sneaking or holding handled food/petals. Calling super.interactMob.", (Object)this.m_19879_(), (Object)world.m_46467_());
                InteractionResult vanillaResult = super.m_6071_(player, hand);
                AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] super.interactMob returned: {}", new Object[]{this.m_19879_(), world.m_46467_(), vanillaResult});
                if (vanillaResult.m_19077_()) {
                    return vanillaResult;
                }
            }
            if (!world.m_5776_() && !isSneaking) {
                AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Fallback: Toggling sitting state.", (Object)this.m_19879_(), (Object)world.m_46467_());
                this.m_21839_((Boolean)this.f_19804_.m_135370_(IS_SITTING) == false);
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.CONSUME_PARTIAL;
            }
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Reached end of owner logic. Returning client-side success/pass.", (Object)this.m_19879_(), (Object)world.m_46467_());
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Player is not owner. Calling super.interactMob.", (Object)this.m_19879_(), (Object)world.m_46467_());
        return super.m_6071_(player, hand);
    }

    public void m_7105_(boolean tamed) {
        this.setTamed(tamed, true);
    }

    public void setTamed(boolean tamed, boolean updateAttributes) {
        super.m_7105_(tamed);
        if (updateAttributes) {
            if (tamed) {
                this.m_21051_(Attributes.f_22276_).m_22100_(16.0);
                this.m_21153_(this.m_21233_());
                this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
            } else {
                this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
                this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
            }
        }
    }

    public boolean isInCustomLove() {
        return this.customLoveTimer > 0;
    }

    public void setCustomInLove(Player player) {
        this.customLoveTimer = 600;
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)18);
        }
    }

    public void m_6863_(boolean baby) {
        this.m_146762_(baby ? -24000 : 0);
    }

    public void m_21837_(boolean inSittingPose) {
        super.m_21837_(inSittingPose);
        if ((Boolean)this.f_19804_.m_135370_(IS_SITTING) != inSittingPose) {
            this.f_19804_.m_135381_(IS_SITTING, (Object)inSittingPose);
        }
        if (!inSittingPose) {
            if (this.m_5803_()) {
                this.setSleeping(false);
            }
            if (this.isKnockedOut()) {
                this.setKnockedOut(false);
            }
        }
    }

    public HamsterVariant getVariantEnum() {
        return HamsterVariant.byId(this.getVariant());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        HamsterVariant babyFinalVariant;
        boolean motherHasOverlay;
        HamsterEntity baby = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).m_20615_((Level)world);
        if (baby == null) {
            return null;
        }
        if (!(mate instanceof HamsterEntity)) {
            int randomVariantId = this.f_19796_.m_188503_(HamsterVariant.values().length);
            baby.setVariant(randomVariantId);
            baby.m_6863_(true);
            AdorableHamsterPets.LOGGER.warn("Hamster breeding attempted with non-hamster mate. Assigning random variant to baby.");
            return baby;
        }
        HamsterEntity mother = (HamsterEntity)mate;
        HamsterEntity father = this;
        HamsterVariant parentProvidingBaseColor = this.f_19796_.m_188499_() ? father.getVariantEnum() : mother.getVariantEnum();
        HamsterVariant babyBaseColorEnum = parentProvidingBaseColor.getBaseVariant();
        @Nullable String fatherOverlayName = father.getVariantEnum().getOverlayTextureName();
        @Nullable String motherOverlayName = mother.getVariantEnum().getOverlayTextureName();
        List<HamsterVariant> allVariantsForBabyBase = HamsterVariant.getVariantsForBase(babyBaseColorEnum);
        ArrayList<@Nullable String> eligibleOverlayNames = new ArrayList<String>();
        for (HamsterVariant variant : allVariantsForBabyBase) {
            boolean matchesMother;
            @Nullable String candidateOverlay = variant.getOverlayTextureName();
            boolean matchesFather = fatherOverlayName != null && fatherOverlayName.equals(candidateOverlay);
            boolean bl = matchesMother = motherOverlayName != null && motherOverlayName.equals(candidateOverlay);
            if (matchesFather || matchesMother) continue;
            eligibleOverlayNames.add(candidateOverlay);
        }
        ArrayList<@Nullable String> finalSelectableOverlayNames = new ArrayList<String>();
        boolean fatherHasOverlay = fatherOverlayName != null;
        boolean bl = motherHasOverlay = motherOverlayName != null;
        if (fatherHasOverlay && motherHasOverlay) {
            for (String overlayName : eligibleOverlayNames) {
                if (overlayName == null) continue;
                finalSelectableOverlayNames.add(overlayName);
            }
            if (finalSelectableOverlayNames.isEmpty() && babyBaseColorEnum != HamsterVariant.WHITE) {
                for (HamsterVariant variant : allVariantsForBabyBase) {
                    if (variant.getOverlayTextureName() == null) continue;
                    finalSelectableOverlayNames.add(variant.getOverlayTextureName());
                }
            }
        } else {
            finalSelectableOverlayNames.addAll(eligibleOverlayNames);
        }
        if (!finalSelectableOverlayNames.isEmpty()) {
            @Nullable String chosenOverlayName = (String)finalSelectableOverlayNames.get(this.f_19796_.m_188503_(finalSelectableOverlayNames.size()));
            babyFinalVariant = HamsterVariant.getVariantByBaseAndOverlay(babyBaseColorEnum, chosenOverlayName);
        } else {
            babyFinalVariant = babyBaseColorEnum;
        }
        baby.setVariant(babyFinalVariant.getId());
        UUID ownerUUID = father.m_21805_();
        if (ownerUUID != null) {
            baby.m_21816_(ownerUUID);
            baby.setTamed(true, true);
        }
        baby.m_6863_(true);
        return baby;
    }

    public boolean m_6898_(ItemStack stack) {
        return HamsterEntity.isIsFood(stack);
    }

    public void m_8119_() {
        Level world;
        int chanceDenominator;
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
        if (this.cleaningCooldownTimer > 0) {
            --this.cleaningCooldownTimer;
        }
        if (this.cleaningTimer > 0) {
            --this.cleaningTimer;
            if (this.cleaningTimer == 0) {
                if (!this.m_9236_().f_46443_) {
                    this.f_19804_.m_135381_(IS_CLEANING, (Object)false);
                }
                this.cleaningCooldownTimer = 200;
            }
        }
        if (this.wakingUpTicks > 0) {
            --this.wakingUpTicks;
        }
        if (this.autoEatCooldownTicks > 0) {
            --this.autoEatCooldownTicks;
        }
        if (this.autoEatProgressTicks > 0) {
            --this.autoEatProgressTicks;
        }
        if (this.ejectionCheckCooldown > 0) {
            --this.ejectionCheckCooldown;
        }
        if (this.preAutoEatDelayTicks > 0) {
            --this.preAutoEatDelayTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.diamondCelebrationSoundTicks > 0) {
            --this.diamondCelebrationSoundTicks;
        }
        if (this.sulkOrchestraHitDelayTicks > 0) {
            --this.sulkOrchestraHitDelayTicks;
        }
        if (this.sulkFailParticleTicks > 0) {
            --this.sulkFailParticleTicks;
        }
        if (this.sulkEntityEffectTicks > 0) {
            --this.sulkEntityEffectTicks;
        }
        if (this.sulkShockedSoundDelayTicks > 0) {
            --this.sulkShockedSoundDelayTicks;
        }
        if (this.diamondSparkleSoundDelayTicks > 0) {
            --this.diamondSparkleSoundDelayTicks;
        }
        if (this.isKnockedOut() && ((Boolean)this.f_19804_.m_135370_(IS_CLEANING)).booleanValue()) {
            this.f_19804_.m_135381_(IS_CLEANING, (Object)false);
            this.cleaningTimer = 0;
        }
        DozingPhase currentPhase = this.getDozingPhase();
        if (!this.m_9236_().m_5776_() && this.m_21824_() && ((Boolean)this.f_19804_.m_135370_(IS_SITTING)).booleanValue() && !((Boolean)this.f_19804_.m_135370_(IS_CLEANING)).booleanValue() && this.cleaningCooldownTimer <= 0 && (currentPhase == DozingPhase.NONE || currentPhase == DozingPhase.QUIESCENT_SITTING) && (chanceDenominator = ((Integer)Configs.AHP.cleaningChanceDenominator.get()).intValue()) > 0 && this.f_19796_.m_188503_(chanceDenominator) == 0) {
            this.cleaningTimer = this.f_19796_.m_216332_(30, 60);
            this.f_19804_.m_135381_(IS_CLEANING, (Object)true);
        }
        if (this.isThrown()) {
            ++this.throwTicks;
            Vec3 currentPos = this.m_20182_();
            Vec3 currentVel = this.m_20184_();
            Vec3 nextPos = currentPos.m_82549_(currentVel);
            Level world2 = this.m_9236_();
            BlockHitResult blockHit = world2.m_45547_(new ClipContext(currentPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            boolean stopped = false;
            if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = blockHit;
                BlockPos adjacentPos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                this.m_6034_((double)adjacentPos.m_123341_() + 0.5, adjacentPos.m_123342_(), (double)adjacentPos.m_123343_() + 0.5);
                this.m_20256_(currentVel.m_82542_(0.6, 0.0, 0.6));
                this.setThrown(false);
                this.m_5496_(SoundEvents.f_11916_, 1.0f, 1.2f);
                this.setKnockedOut(true);
                this.m_21837_(true);
                if (!world2.m_5776_()) {
                    this.triggerAnimOnServer("mainController", "crash");
                }
                stopped = true;
            } else {
                EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)world2, (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)this.m_20191_().m_82369_(currentVel).m_82400_(1.0), this::canHitEntity);
                if (entityHit != null && entityHit.m_82443_() != null) {
                    Entity hitEntity = entityHit.m_82443_();
                    BlockPos impactPos = hitEntity.m_20183_();
                    boolean playEffects = false;
                    if (hitEntity instanceof ArmorStand) {
                        playEffects = true;
                    } else if (hitEntity instanceof LivingEntity) {
                        LivingEntity livingHit = (LivingEntity)hitEntity;
                        boolean damaged = livingHit.m_6469_(this.m_269291_().m_269390_((Entity)this, (Entity)this.m_269323_()), ((Double)Configs.AHP.hamsterThrowDamage.get()).floatValue());
                        if (damaged) {
                            livingHit.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 20, 0, false, false, false));
                            playEffects = true;
                        }
                    } else {
                        playEffects = true;
                    }
                    if (playEffects) {
                        world2.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.HAMSTER_IMPACT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        if (!world2.m_5776_()) {
                            ((ServerLevel)world2).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_(), 50, 0.4, 0.4, 0.4, 0.1);
                        }
                    }
                    Optional<BlockPos> safePosOpt = this.findSafeSpawnPosition(impactPos, world2, 2);
                    safePosOpt.ifPresentOrElse(safePos -> this.m_6034_((double)safePos.m_123341_() + 0.5, safePos.m_123342_(), (double)safePos.m_123343_() + 0.5), () -> {
                        AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Could not find safe landing spot after hitting entity. Using entity's position {} as fallback.", (Object)impactPos);
                        this.m_6034_((double)impactPos.m_123341_() + 0.5, impactPos.m_123342_(), (double)impactPos.m_123343_() + 0.5);
                    });
                    this.m_20256_(currentVel.m_82542_(0.1, 0.1, 0.1));
                    this.setThrown(false);
                    this.setKnockedOut(true);
                    this.m_21837_(true);
                    if (!world2.m_5776_()) {
                        this.triggerAnimOnServer("mainController", "crash");
                    }
                    stopped = true;
                }
            }
            if (this.isThrown() && !stopped) {
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
                }
                Vec3 currentVelocity = this.m_20184_();
                if (Double.isNaN(currentVelocity.f_82479_) || Double.isNaN(currentVelocity.f_82480_) || Double.isNaN(currentVelocity.f_82481_)) {
                    this.m_20256_(Vec3.f_82478_);
                    this.setThrown(false);
                    AdorableHamsterPets.LOGGER.warn("Hamster velocity became NaN, resetting and stopping throw.");
                } else {
                    this.m_6034_(this.m_20185_() + currentVelocity.f_82479_, this.m_20186_() + currentVelocity.f_82480_, this.m_20189_() + currentVelocity.f_82481_);
                    this.f_19812_ = true;
                    if (!world2.m_5776_() && this.throwTicks > 5) {
                        double offsetMultiplier = 1.5;
                        double spawnX = this.f_19854_ - currentVelocity.f_82479_ * offsetMultiplier;
                        double spawnY = this.f_19855_ + (double)this.m_20206_() / 2.0 - currentVelocity.f_82480_ * offsetMultiplier;
                        double spawnZ = this.f_19856_ - currentVelocity.f_82481_ * offsetMultiplier;
                        ((ServerLevel)world2).m_8767_((ParticleOptions)ParticleTypes.f_123796_, spawnX, spawnY, spawnZ, 1, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            } else if (this.throwTicks != 0) {
                this.throwTicks = 0;
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_21824_() && !this.isKnockedOut()) {
            boolean canInitiateDrowsiness = this.checkConditionsForInitiatingDrowsiness();
            boolean canSustainSlumber = this.checkConditionsForSustainingSlumber();
            switch (currentPhase.ordinal()) {
                case 0: {
                    int durationTicks;
                    if (!((Boolean)this.f_19804_.m_135370_(IS_SITTING)).booleanValue() || !canInitiateDrowsiness || this.quiescentSitDurationTimer != 0) break;
                    this.setDozingPhase(DozingPhase.QUIESCENT_SITTING);
                    int minSeconds = (Integer)Configs.AHP.tamedQuiescentSitMinSeconds.get();
                    int maxSeconds = (Integer)Configs.AHP.tamedQuiescentSitMaxSeconds.get();
                    if (minSeconds > maxSeconds) {
                        AdorableHamsterPets.LOGGER.info("Config issue: tamedQuiescentSitMinSeconds ({}) > tamedQuiescentSitMaxSeconds ({}). Swapping.", (Object)minSeconds, (Object)maxSeconds);
                        int temp = minSeconds;
                        minSeconds = maxSeconds;
                        maxSeconds = temp;
                    }
                    if (maxSeconds < minSeconds) {
                        maxSeconds = minSeconds;
                    }
                    this.quiescentSitDurationTimer = durationTicks = this.f_19796_.m_216332_(minSeconds * 20, maxSeconds * 20 + 1);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering QUIESCENT_SITTING for {} ticks.", (Object)this.m_19879_(), (Object)durationTicks);
                    break;
                }
                case 1: {
                    if (!((Boolean)this.f_19804_.m_135370_(IS_SITTING)).booleanValue() || !canInitiateDrowsiness) {
                        this.resetSleepSequence("Quiescent sitting interrupted: no longer sitting or conditions unfavorable.");
                        break;
                    }
                    if (this.quiescentSitDurationTimer > 0) {
                        --this.quiescentSitDurationTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DRIFTING_OFF);
                    this.driftingOffTimer = 1800;
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DRIFTING_OFF for {} ticks.", (Object)this.m_19879_(), (Object)this.driftingOffTimer);
                    break;
                }
                case 2: {
                    String settleAnimId;
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Drifting off interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.driftingOffTimer > 0) {
                        --this.driftingOffTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.SETTLING_INTO_SLUMBER);
                    int choice = this.f_19796_.m_188503_(3);
                    String deepSleepAnimIdForTracker = switch (choice) {
                        case 0 -> {
                            settleAnimId = "anim_hamster_settle_sleep1";
                            yield "anim_hamster_sleep_pose1";
                        }
                        case 1 -> {
                            settleAnimId = "anim_hamster_settle_sleep2";
                            yield "anim_hamster_sleep_pose2";
                        }
                        default -> {
                            settleAnimId = "anim_hamster_settle_sleep3";
                            yield "anim_hamster_sleep_pose3";
                        }
                    };
                    this.f_19804_.m_135381_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)deepSleepAnimIdForTracker);
                    this.triggerAnimOnServer("mainController", settleAnimId);
                    this.settleSleepAnimationCooldown = 20;
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering SETTLING_INTO_SLUMBER, triggering {}, target deep sleep anim ID: {}.", new Object[]{this.m_19879_(), settleAnimId, deepSleepAnimIdForTracker});
                    break;
                }
                case 3: {
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Settling into slumber interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.settleSleepAnimationCooldown > 0) {
                        --this.settleSleepAnimationCooldown;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DEEP_SLEEP);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DEEP_SLEEP, playing {}.", (Object)this.m_19879_(), this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID));
                    break;
                }
                case 4: {
                    if (canSustainSlumber) break;
                    this.resetSleepSequence("Deep sleep interrupted: conditions for slumber no longer met.");
                }
            }
        }
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.isSulking() && !this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -1.0, 0.0));
            this.f_19812_ = true;
        }
        if (!(world = this.m_9236_()).m_5776_()) {
            BlockPos particlePos;
            if (this.ejectionCheckCooldown <= 0) {
                this.ejectionCheckCooldown = 100;
                boolean ejectedItem = false;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.m_41619_() || !this.isItemDisallowed(stack)) continue;
                    AdorableHamsterPets.LOGGER.warn("[HamsterTick {}] Ejecting disallowed item {} from slot {}.", new Object[]{this.m_19879_(), stack.m_41720_(), i});
                    Containers.m_18992_((Level)world, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)stack.m_41777_());
                    this.items.set(i, (Object)ItemStack.f_41583_);
                    this.m_6596_();
                    ejectedItem = true;
                    break;
                }
            }
            if (this.m_21824_() && this.m_21223_() < this.m_21233_() && !this.isAutoEating() && !((Boolean)this.f_19804_.m_135370_(IS_CONSIDERING_AUTO_EAT)).booleanValue() && this.autoEatCooldownTicks == 0 && !this.isThrown() && !this.isKnockedOut()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.m_41619_() || !AUTO_HEAL_FOODS.contains(stack.m_41720_())) continue;
                    this.f_19804_.m_135381_(IS_CONSIDERING_AUTO_EAT, (Object)true);
                    this.preAutoEatDelayTicks = 40;
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Eligible to auto-eat. Starting 2s pre-eat delay.", (Object)this.m_19879_());
                    break;
                }
            }
            if (((Boolean)this.f_19804_.m_135370_(IS_CONSIDERING_AUTO_EAT)).booleanValue() && this.preAutoEatDelayTicks == 0) {
                this.f_19804_.m_135381_(IS_CONSIDERING_AUTO_EAT, (Object)false);
                boolean foodStillAvailable = false;
                ItemStack foodToEat = ItemStack.f_41583_;
                int foodSlot = -1;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.m_41619_() || !AUTO_HEAL_FOODS.contains(stack.m_41720_())) continue;
                    foodStillAvailable = true;
                    foodToEat = stack;
                    foodSlot = i;
                    break;
                }
                if (foodStillAvailable) {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished. Starting auto-eat on {} from slot {}", new Object[]{this.m_19879_(), foodToEat.m_41720_(), foodSlot});
                    this.isAutoEating = true;
                    this.autoEatProgressTicks = 60;
                    this.m_5496_(SoundEvents.f_11912_, 0.7f, 1.3f);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, foodToEat.m_41620_(1)), this.m_20185_() + this.f_19796_.m_188583_() * 0.1, this.m_20186_() + (double)this.m_20206_() / 2.0 + this.f_19796_.m_188583_() * 0.1, this.m_20189_() + this.f_19796_.m_188583_() * 0.1, 5, 0.1, 0.1, 0.1, 0.02);
                    }
                    if (foodToEat.m_41619_()) {
                        this.items.set(foodSlot, (Object)ItemStack.f_41583_);
                    }
                    this.updateCheekTrackers();
                } else {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished, but food no longer available.", (Object)this.m_19879_());
                }
            }
            if (this.isAutoEating() && this.autoEatProgressTicks == 0) {
                this.m_5634_(((Float)Configs.AHP.hamsterFoodMixHealing.get()).floatValue());
                this.autoEatCooldownTicks = 60;
                this.isAutoEating = false;
                AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Auto-eat finished. Healed. Cooldown set to 60.", (Object)this.m_19879_());
                LivingEntity livingEntity = this.m_269323_();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
                    ModCriteria.HAMSTER_AUTO_FED.trigger(serverPlayerOwner, this);
                }
            }
            if (!this.m_9236_().m_5776_() && this.isCelebratingDiamond()) {
                SoundEvent sparkleSound;
                if (this.diamondSparkleSoundDelayTicks == 1 && (sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.DIAMOND_SPARKLE_SOUNDS, this.f_19796_)) != null) {
                    if (this.currentOreTarget != null) {
                        this.m_9236_().m_5594_(null, this.currentOreTarget, sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        this.m_9236_().m_5594_(null, this.m_20183_(), sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                if (this.celebrationParticleTicks > 0) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123749_, this.m_20185_(), this.m_20186_() + 1.8, this.m_20189_(), 2, 0.12, 0.25, 0.12, 0.15);
                    if (this.currentOreTarget != null && this.f_19796_.m_188503_(4) == 0) {
                        particlePos = this.currentOreTarget.m_7494_();
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123815_, (double)particlePos.m_123341_() + 0.5, (double)particlePos.m_123342_() + 0.5, (double)particlePos.m_123343_() + 0.5, 1, 0.2, 0.35, 0.2, 0.003);
                    }
                }
                if (this.diamondCelebrationSoundTicks <= 0) {
                    SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.f_19796_);
                    if (celebrationSound != null) {
                        this.m_9236_().m_5594_(null, this.m_20183_(), celebrationSound, SoundSource.NEUTRAL, 0.8f, this.m_6100_());
                    }
                    this.diamondCelebrationSoundTicks = 30;
                }
            }
            if (this.isSulking()) {
                if (this.sulkOrchestraHitDelayTicks == 1) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.ALARM_ORCHESTRA_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkShockedSoundDelayTicks == 1) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SHOCKED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkFailParticleTicks > 0 && this.currentOreTarget != null && this.f_19796_.m_188503_(3) == 0) {
                    particlePos = this.currentOreTarget.m_7494_();
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)particlePos.m_123341_() + 0.5, (double)particlePos.m_123342_() + 0.5, (double)particlePos.m_123343_() + 0.5, 2, 0.3, 0.3, 0.3, 0.005);
                }
                if (this.sulkEntityEffectTicks > 0 && this.f_19796_.m_188503_(5) == 0) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.3), this.m_20187_(), this.m_20262_(0.3), 0, 0.3, 0.3, 0.3, 1.0);
                }
            }
        }
        if (world.f_46443_ && this.m_21023_(MobEffects.f_19600_) && this.f_19796_.m_188503_(5) == 0) {
            for (int i = 0; i < 2; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
            }
        }
        if (this.isRefusingFood() && this.refuseTimer > 0 && --this.refuseTimer <= 0) {
            this.setRefusingFood(false);
        }
        if (this.tamingCooldown > 0) {
            --this.tamingCooldown;
        }
        if (this.customLoveTimer > 0) {
            --this.customLoveTimer;
        }
        if (this.customLoveTimer <= 0 && this.m_27593_()) {
            this.setInLove(false);
        }
    }

    public boolean m_21515_() {
        return super.m_21515_() && !this.isThrown();
    }

    public boolean m_6094_() {
        return super.m_6094_() && !this.isThrown();
    }

    public void m_6667_(DamageSource source) {
        Level world = this.m_9236_();
        if (!world.m_5776_()) {
            for (ItemStack stack : this.items) {
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)world, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)stack);
            }
            this.items.clear();
            this.updateCheekTrackers();
        }
        super.m_6667_(source);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "mainController", 5, event -> {
            DozingPhase currentDozingPhase = this.getDozingPhase();
            int personality = (Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID);
            if (this.isKnockedOut()) {
                return event.setAndContinue(KNOCKED_OUT_ANIM);
            }
            if (this.isSulking()) {
                return event.setAndContinue(SULKING_ANIM);
            }
            if (this.isThrown()) {
                return event.setAndContinue(FLYING_ANIM);
            }
            boolean isSeekingGoalActive = false;
            String activeGoalName = this.getActiveCustomGoalDebugName();
            if (activeGoalName.startsWith(HamsterSeekDiamondGoal.class.getSimpleName())) {
                isSeekingGoalActive = true;
            }
            if (isSeekingGoalActive) {
                double horizontalSpeedSquared = this.m_20184_().m_165925_();
                if (horizontalSpeedSquared > 1.0E-7) {
                    return event.setAndContinue(SEEKING_DIAMOND_ANIM);
                }
                return event.setAndContinue(WANTS_TO_SEEK_DIAMOND_ANIM);
            }
            if (this.isCelebratingDiamond()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (this.m_21824_()) {
                switch (currentDozingPhase.ordinal()) {
                    case 2: {
                        return event.setAndContinue(switch (personality) {
                            case 2 -> DRIFTING_OFF_POSE2_ANIM;
                            case 3 -> DRIFTING_OFF_POSE3_ANIM;
                            default -> DRIFTING_OFF_POSE1_ANIM;
                        });
                    }
                    case 3: {
                        String targetDeepSleepId = (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID);
                        if (!targetDeepSleepId.isEmpty()) {
                            RawAnimation targetDeepSleepAnim = switch (targetDeepSleepId) {
                                case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                                case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                                case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                                default -> SITTING_POSE1_ANIM;
                            };
                            return event.setAndContinue(targetDeepSleepAnim);
                        }
                        if (!((Boolean)this.f_19804_.m_135370_(IS_SITTING)).booleanValue()) break;
                        return event.setAndContinue(switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        });
                    }
                    case 4: {
                        String deepSleepId;
                        RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                            case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                            case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                            case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                            default -> {
                                switch (personality) {
                                    case 2: {
                                        yield SITTING_POSE2_ANIM;
                                    }
                                    case 3: {
                                        yield SITTING_POSE3_ANIM;
                                    }
                                }
                                yield SITTING_POSE1_ANIM;
                            }
                        };
                        return event.setAndContinue(deepSleepAnimToPlay);
                    }
                }
            }
            if (!this.m_21824_() && this.m_5803_()) {
                return event.setAndContinue(SLEEP_POSE1_ANIM);
            }
            if (((Boolean)this.f_19804_.m_135370_(IS_SITTING)).booleanValue() && !this.isKnockedOut()) {
                if (((Boolean)this.f_19804_.m_135370_(IS_CLEANING)).booleanValue()) {
                    return event.setAndContinue(CLEANING_ANIM);
                }
                return event.setAndContinue(switch (personality) {
                    case 2 -> SITTING_POSE2_ANIM;
                    case 3 -> SITTING_POSE3_ANIM;
                    default -> SITTING_POSE1_ANIM;
                });
            }
            double horizontalSpeedSquared = this.m_20184_().m_165925_();
            if (horizontalSpeedSquared > 1.0E-6) {
                return event.setAndContinue(horizontalSpeedSquared > 0.002 ? RUNNING_ANIM : WALKING_ANIM);
            }
            if (this.isBegging()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            return event.setAndContinue(IDLE_ANIM);
        }).triggerableAnim("crash", CRASH_ANIM).triggerableAnim("wakeup", WAKE_UP_ANIM).triggerableAnim("no", NO_ANIM).triggerableAnim("attack", ATTACK_ANIM).triggerableAnim("anim_hamster_settle_sleep1", SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_settle_sleep2", SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_settle_sleep3", SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_wild_settle_sleep", WILD_SETTLE_SLEEP_ANIM).triggerableAnim("anim_hamster_sulk", SULK_ANIM).setParticleKeyframeHandler(event -> {
            this.particleEffectId = event.getKeyframeData().getEffect();
        }).setSoundKeyframeHandler(event -> {
            this.soundEffectId = event.getKeyframeData().getSound();
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void triggerAnimOnServer(String controllerName, String animName) {
        if (!this.m_9236_().m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)this.m_9236_();
            this.triggerAnim(controllerName, animName);
            AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Triggered server-side animation: Controller='{}', Anim='{}'", new Object[]{this.m_19879_(), controllerName, animName});
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(ANIMATION_PERSONALITY_ID, (Object)1);
        this.f_19804_.m_135372_(IS_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(IS_SITTING, (Object)false);
        this.f_19804_.m_135372_(IS_BEGGING, (Object)false);
        this.f_19804_.m_135372_(IS_IN_LOVE, (Object)false);
        this.f_19804_.m_135372_(IS_REFUSING_FOOD, (Object)false);
        this.f_19804_.m_135372_(IS_THROWN, (Object)false);
        this.f_19804_.m_135372_(LEFT_CHEEK_FULL, (Object)false);
        this.f_19804_.m_135372_(RIGHT_CHEEK_FULL, (Object)false);
        this.f_19804_.m_135372_(IS_KNOCKED_OUT, (Object)false);
        this.f_19804_.m_135372_(PINK_PETAL_TYPE, (Object)0);
        this.f_19804_.m_135372_(CHEEK_POUCH_UNLOCKED, (Object)false);
        this.f_19804_.m_135372_(IS_CONSIDERING_AUTO_EAT, (Object)false);
        this.f_19804_.m_135372_(DOZING_PHASE, (Object)DozingPhase.NONE.ordinal());
        this.f_19804_.m_135372_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)"");
        this.f_19804_.m_135372_(IS_SULKING, (Object)false);
        this.f_19804_.m_135372_(IS_CELEBRATING_DIAMOND, (Object)false);
        this.f_19804_.m_135372_(IS_CLEANING, (Object)false);
        this.f_19804_.m_135372_(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)"None");
    }

    protected void m_8099_() {
        AdorableHamsterPets.LOGGER.debug("[AI Init {} Tick {}] Initializing goals. Current State: isSleeping={}, isSittingPose={}", new Object[]{this.m_19879_(), this.m_9236_().f_46443_ ? "ClientTick?" : Long.valueOf(this.m_9236_().m_46467_()), this.m_5803_(), this.m_21825_()});
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HamsterSeekDiamondGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HamsterMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new HamsterMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new HamsterFollowOwnerGoal(this, 1.2, 4.0f, 16.0f));
        this.f_21345_.m_25352_(5, new HamsterFleeGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 1.0, 1.5));
        this.f_21345_.m_25352_(6, (Goal)new HamsterTemptGoal(this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SLICED_CUCUMBER.get(), (ItemLike)ModItems.CHEESE.get(), (ItemLike)ModItems.STEAMED_GREEN_BEANS.get()}), false));
        this.f_21345_.m_25352_(7, (Goal)new HamsterSitGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new HamsterSleepGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new HamsterWanderAroundFarGoal(this, 0.75));
        this.f_21345_.m_25352_(10, (Goal)new HamsterLookAtEntityGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(11, (Goal)new HamsterLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        AdorableHamsterPets.LOGGER.debug("[AI Init {} Tick {}] Finished initializing goals.", (Object)this.m_19879_(), this.m_9236_().f_46443_ ? "ClientTick?" : Long.valueOf(this.m_9236_().m_46467_()));
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target == null) {
            super.m_6710_(null);
            return;
        }
        if (this.m_21824_() && this.m_269323_() != null) {
            TraceableEntity ownableFallback;
            Entity fallbackOwnerEntity;
            LivingEntity owner = this.m_269323_();
            UUID ownerUuid = owner.m_20148_();
            boolean preventTargeting = false;
            if (target instanceof TamableAnimal) {
                TamableAnimal tameablePet = (TamableAnimal)target;
                UUID petOwnerUuid = tameablePet.m_21805_();
                if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid) && tameablePet != this) {
                    preventTargeting = true;
                }
            } else if (target instanceof AbstractHorse) {
                AbstractHorse horsePet = (AbstractHorse)target;
                LivingEntity horseOwnerEntity = horsePet.m_269323_();
                if (horseOwnerEntity != null && horseOwnerEntity.m_20148_().equals(ownerUuid)) {
                    preventTargeting = true;
                }
            } else if (target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).m_19749_()) != null && fallbackOwnerEntity.m_20148_().equals(ownerUuid) && ownableFallback != this) {
                preventTargeting = true;
            }
            if (preventTargeting) {
                super.m_6710_(null);
                return;
            }
        }
        super.m_6710_(target);
    }

    protected SoundEvent m_7515_() {
        if (this.isKnockedOut()) {
            return null;
        }
        if (this.isBegging()) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.f_19796_);
        }
        boolean playSleepSounds = false;
        if (this.m_21824_()) {
            DozingPhase phase = this.getDozingPhase();
            if (phase == DozingPhase.DRIFTING_OFF || phase == DozingPhase.SETTLING_INTO_SLUMBER || phase == DozingPhase.DEEP_SLEEP) {
                playSleepSounds = true;
            }
        } else if (this.m_5803_()) {
            playSleepSounds = true;
        }
        if (playSleepSounds) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SLEEP_SOUNDS, this.f_19796_);
        }
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_IDLE_SOUNDS, this.f_19796_);
    }

    public void m_8032_() {
        SoundEvent soundEvent = this.m_7515_();
        if (soundEvent != null && Arrays.asList(ModSounds.HAMSTER_BEG_SOUNDS).contains(soundEvent)) {
            this.m_5496_(soundEvent, 0.8f, this.m_6100_());
        } else {
            super.m_8032_();
        }
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.f_19796_);
    }

    protected SoundEvent m_5592_() {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DEATH_SOUNDS, this.f_19796_);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!HamsterRenderTracker.isBeingRendered(this.m_19879_())) {
            try {
                SoundType group = state.m_60827_();
                float volume = state.m_60713_(Blocks.f_49994_) ? 0.060000002f : 0.1f;
                this.m_5496_(group.m_56776_(), volume, group.m_56774_() * 1.5f);
            }
            catch (Exception ex) {
                AdorableHamsterPets.LOGGER.warn("Error playing fallback step sound", (Throwable)ex);
            }
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (entity instanceof ArmorStand) {
            return !entity.m_5833_();
        }
        if (!entity.m_5833_() && entity.m_6084_() && entity.m_6087_()) {
            LivingEntity owner = this.m_269323_();
            return entity != this && (owner == null || !owner.m_20365_(entity));
        }
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag nbt) {
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] HamsterEntity.initialize called. SpawnReason: {}", (Object)spawnReason);
        this.f_19804_.m_135381_(ANIMATION_PERSONALITY_ID, (Object)this.f_19796_.m_216332_(1, 3));
        if (spawnReason == MobSpawnType.NATURAL || spawnReason == MobSpawnType.SPAWN_EGG || spawnReason == MobSpawnType.CHUNK_GENERATION) {
            Holder biomeEntry = world.m_204166_(this.m_20183_());
            String biomeKeyStr = biomeEntry.m_203543_().map(key -> key.m_135782_().toString()).orElse("UNKNOWN");
            AdorableHamsterPets.LOGGER.debug("[HamsterInit] SpawnReason: {}, BiomeKey: {}", (Object)spawnReason, (Object)biomeKeyStr);
            HamsterVariant chosenVariant = HamsterEntity.determineVariantForBiome((Holder<Biome>)biomeEntry, this.f_19796_);
            this.setVariant(chosenVariant.getId());
            AdorableHamsterPets.LOGGER.debug("[HamsterInit] Assigned variant: {}", (Object)chosenVariant.name());
        } else {
            int randomVariantId = this.f_19796_.m_188503_(HamsterVariant.values().length);
            this.setVariant(randomVariantId);
            AdorableHamsterPets.LOGGER.debug("[HamsterInit] SpawnReason: {}, Assigned random variant: {}", (Object)spawnReason, (Object)HamsterVariant.byId(randomVariantId).name());
        }
        this.updateCheekTrackers();
        return super.m_6518_(world, difficulty, spawnReason, entityData, nbt);
    }

    private boolean isSafeSpawnLocation(BlockPos pos, Level world) {
        BlockPos floorPos = pos.m_7495_();
        BlockState floorState = world.m_8055_(floorPos);
        BlockPathTypes floorType = LandPathNodeMakerInvoker.callGetCommonNodeType((BlockGetter)world, floorPos);
        if (HAZARDOUS_FLOOR_TYPES.contains(floorType)) {
            return false;
        }
        if (floorState.m_60812_((BlockGetter)world, floorPos).m_83281_()) {
            return false;
        }
        return world.m_8055_(pos).m_60812_((BlockGetter)world, pos).m_83281_() && world.m_8055_(pos.m_7494_()).m_60812_((BlockGetter)world, pos.m_7494_()).m_83281_();
    }

    private Optional<BlockPos> findSafeSpawnPosition(BlockPos initialTarget, Level world, int searchRadius) {
        if (this.isSafeSpawnLocation(initialTarget, world)) {
            return Optional.of(initialTarget);
        }
        for (int i = 1; i <= 3; ++i) {
            BlockPos abovePos = initialTarget.m_6630_(i);
            if (!this.isSafeSpawnLocation(abovePos, world)) continue;
            return Optional.of(abovePos);
        }
        for (int r = 1; r <= searchRadius; ++r) {
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    BlockPos checkPos;
                    if (Math.abs(i) != r && Math.abs(j) != r || !this.isSafeSpawnLocation(checkPos = initialTarget.m_7918_(i, 0, j), world)) continue;
                    return Optional.of(checkPos);
                }
            }
        }
        return Optional.empty();
    }

    public boolean isItemDisallowed(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (DISALLOWED_ITEMS.contains(item)) {
            return true;
        }
        for (TagKey<Item> tag : DISALLOWED_ITEM_TAGS) {
            if (!stack.m_204117_(tag)) continue;
            return true;
        }
        if (item instanceof BlockItem) {
            return !stack.m_204117_(ModItemTags.ALLOWED_POUCH_BLOCKS);
        }
        return item instanceof SpawnEggItem;
    }

    private HolderLookup.Provider getRegistryLookup() {
        return this.m_9236_().m_9598_();
    }

    private boolean tryTame(Player player, ItemStack itemStack) {
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        int denominator = Math.max(1, (Integer)config.tamingChanceDenominator.get());
        if (this.f_19796_.m_188503_(denominator) == 0) {
            this.m_21816_(player.m_20148_());
            this.setTamed(true, true);
            this.f_21344_.m_26573_();
            this.m_21839_(false);
            this.setSleeping(false);
            this.m_6710_(null);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            SoundEvent celebrateSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.f_19796_);
            this.m_9236_().m_5594_(null, this.m_20183_(), celebrateSound, SoundSource.NEUTRAL, 0.7f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10590_.m_68829_(serverPlayer, (Animal)this);
            }
            return true;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
        return false;
    }

    private boolean checkRepeatFoodRefusal(ItemStack currentStack, Player player) {
        if (REPEATABLE_FOODS.contains(currentStack.m_41720_())) {
            return false;
        }
        if (!this.lastFoodItem.m_41619_() && ItemStack.m_41656_((ItemStack)this.lastFoodItem, (ItemStack)currentStack)) {
            this.setRefusingFood(true);
            this.refuseTimer = 40;
            player.m_5661_((Component)Component.m_237113_((String)"Hamster wants to try something different."), true);
            if (!this.m_9236_().m_5776_()) {
                this.triggerAnimOnServer("mainController", "no");
            }
            return true;
        }
        return false;
    }

    private boolean tryFeedingAsTamed(Player player, ItemStack stack) {
        boolean isFood = HamsterEntity.isIsFood(stack);
        boolean isBuffItem = stack.m_150930_((Item)ModItems.STEAMED_GREEN_BEANS.get());
        boolean canHeal = this.m_21223_() < this.m_21233_();
        boolean readyToBreed = this.m_146764_() == 0 && !this.isInCustomLove();
        Level world = this.m_9236_();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        boolean actionTaken = false;
        AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Entering tryFeedingAsTamed. Item: {}, isFood={}, isBuff={}, canHeal={}, breedingAge={}, isInCustomLove={}, readyToBreed={}", new Object[]{this.m_19879_(), world.m_46467_(), stack.m_41720_(), isFood, isBuffItem, canHeal, this.m_146764_(), this.isInCustomLove(), readyToBreed});
        if (!isFood && !isBuffItem) {
            AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Item is not valid food or buff item. Returning false.", (Object)this.m_19879_(), (Object)world.m_46467_());
            return false;
        }
        if (isBuffItem) {
            long currentTime = world.m_46467_();
            if (this.steamedBeansCooldownEndTick > currentTime) {
                long remainingTicks = this.steamedBeansCooldownEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.beans_cooldown", (Object[])new Object[]{minutes, seconds}).m_130940_(ChatFormatting.RED), true);
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Buff item used, but on cooldown ({} ticks remaining). Returning false.", new Object[]{this.m_19879_(), world.m_46467_(), remainingTicks});
                return false;
            }
            int duration = (Integer)config.greenBeanBuffDuration.get();
            int speedAmplifier = (Integer)config.greenBeanBuffAmplifierSpeed.get();
            int strengthAmplifier = (Integer)config.greenBeanBuffAmplifierStrength.get();
            int absorptionAmplifier = (Integer)config.greenBeanBuffAmplifierAbsorption.get();
            int regenAmplifier = (Integer)config.greenBeanBuffAmplifierRegen.get();
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, speedAmplifier));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration, strengthAmplifier));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, duration, absorptionAmplifier));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, regenAmplifier));
            SoundEvent buffSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.f_19796_);
            world.m_5594_(null, this.m_20183_(), buffSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.steamedBeansCooldownEndTick = currentTime + (long)((Integer)config.steamedGreenBeansBuffCooldown.get()).intValue();
            actionTaken = true;
            AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Applied buffs from Steamed Green Beans. Cooldown set to {}. Returning true.", new Object[]{this.m_19879_(), world.m_46467_(), this.steamedBeansCooldownEndTick});
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModCriteria.FED_HAMSTER_STEAMED_BEANS.trigger(serverPlayer, this);
            }
        } else if (isFood) {
            boolean wasHealedOrBredThisTime = false;
            if (canHeal) {
                this.m_5634_(((Float)config.standardFoodHealing.get()).floatValue());
                actionTaken = true;
                wasHealedOrBredThisTime = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Healed with standard food.", (Object)this.m_19879_());
            } else if (readyToBreed) {
                this.setSitting(false, true);
                this.setCustomInLove(player);
                this.setInLove(true);
                actionTaken = true;
                wasHealedOrBredThisTime = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Entered love mode with standard food.", (Object)this.m_19879_());
            }
            if (wasHealedOrBredThisTime && stack.m_150930_((Item)ModItems.HAMSTER_FOOD_MIX.get()) && !((Boolean)this.f_19804_.m_135370_(CHEEK_POUCH_UNLOCKED)).booleanValue()) {
                this.f_19804_.m_135381_(CHEEK_POUCH_UNLOCKED, (Object)true);
                AdorableHamsterPets.LOGGER.debug("Hamster {} cheek pouch unlocked by food mix.", (Object)this.m_19879_());
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModCriteria.CHEEK_POUCH_UNLOCKED.trigger(serverPlayer, this);
                }
                world.m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.NEUTRAL, 0.5f, 1.5f);
                if (!world.f_46443_) {
                    ((ServerLevel)world).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModItems.HAMSTER_FOOD_MIX.get())), this.m_20185_(), this.m_20227_(0.2), this.m_20189_(), 10, 0.25, 0.15, 0.25, 0.2);
                }
            }
            if (!actionTaken) {
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Standard food used, but no action (heal/breed) taken.", (Object)this.m_19879_());
            }
        }
        return actionTaken;
    }

    @Unique
    private boolean checkConditionsForInitiatingDrowsiness() {
        if (!((Boolean)this.f_19804_.m_135370_(IS_SITTING)).booleanValue()) {
            return false;
        }
        Level world = this.m_9236_();
        if (Configs.AHP.requireDaytimeForTamedSleep && !world.m_46461_()) {
            return false;
        }
        if (this.m_27593_()) {
            return false;
        }
        if (!this.m_20096_()) {
            return false;
        }
        double threatRadius = ((Integer)Configs.AHP.tamedSleepThreatDetectionRadiusBlocks.get()).intValue();
        List nearbyHostiles = world.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(threatRadius), entity -> entity instanceof Monster && entity.m_6084_() && !entity.m_5833_());
        return nearbyHostiles.isEmpty();
    }

    @Unique
    private boolean checkConditionsForSustainingSlumber() {
        return (Boolean)this.f_19804_.m_135370_(IS_SITTING) != false && this.checkConditionsForInitiatingDrowsiness();
    }

    @Unique
    private void resetSleepSequence(String reason) {
        AdorableHamsterPets.LOGGER.debug("Hamster {} resetting sleep sequence: {}. Current phase was: {}", new Object[]{this.m_19879_(), reason, this.getDozingPhase()});
        this.setDozingPhase(DozingPhase.NONE);
        this.quiescentSitDurationTimer = 0;
        this.driftingOffTimer = 0;
        this.settleSleepAnimationCooldown = 0;
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        buf.writeInt(this.m_19879_());
    }

    public void m_142036_() {
        super.m_142036_();
        if (!this.m_9236_().m_5776_()) {
            HamsterRenderTracker.onEntityUnload(this.m_19879_());
        }
    }

    public static enum DozingPhase {
        NONE,
        QUIESCENT_SITTING,
        DRIFTING_OFF,
        SETTLING_INTO_SLUMBER,
        DEEP_SLEEP;

    }
}

