/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerEntityAccessor {
    @Unique
    private static final EntityDataAccessor<CompoundTag> HAMSTER_SHOULDER_ENTITY = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    @Unique
    private static final int CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final List<String> DISMOUNT_MESSAGE_KEYS = Arrays.asList("message.adorablehamsterpets.dismount.1", "message.adorablehamsterpets.dismount.2", "message.adorablehamsterpets.dismount.3", "message.adorablehamsterpets.dismount.4", "message.adorablehamsterpets.dismount.5", "message.adorablehamsterpets.dismount.6");
    @Unique
    private int adorablehamsterpets$diamondCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$creeperCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$diamondSoundCooldownTicks = 0;
    @Unique
    private int adorablehamsterpets$creeperSoundCooldownTicks = 0;
    @Unique
    private String adorablehamsterpets$lastDismountMessageKey = "";
    @Unique
    private boolean adorablehamsterpets$isDiamondAlertConditionMet = false;
    @Unique
    private int adorablehamsterpets$lastGoldMessageIndex = -1;

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$initDataTracker(CallbackInfo ci) {
        this.f_19804_.m_135372_(HAMSTER_SHOULDER_ENTITY, (Object)new CompoundTag());
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$writeNbt(CompoundTag nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] PlayerEntityMixin writeNbt is RUNNING for entity {}.", (Object)this.m_19879_());
        if (!this.getHamsterShoulderEntity().m_128456_()) {
            nbt.m_128365_("ShoulderHamster", (Tag)this.getHamsterShoulderEntity());
        }
        if (this.adorablehamsterpets$lastGoldMessageIndex != -1) {
            nbt.m_128405_("LastGoldMessageIndex", this.adorablehamsterpets$lastGoldMessageIndex);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$readNbt(CompoundTag nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] PlayerEntityMixin readNbt is RUNNING for entity {}.", (Object)this.m_19879_());
        if (nbt.m_128425_("ShoulderHamster", 10)) {
            this.setHamsterShoulderEntity(nbt.m_128469_("ShoulderHamster"));
        }
        this.adorablehamsterpets$lastGoldMessageIndex = nbt.m_128425_("LastGoldMessageIndex", 3) ? nbt.m_128451_("LastGoldMessageIndex") : -1;
    }

    @Inject(method={"remove(Lnet/minecraft/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onRemove(Entity.RemovalReason reason, CallbackInfo ci) {
        if (!this.m_9236_().m_5776_()) {
            HamsterRenderTracker.onPlayerDisconnect(this.m_20148_());
        }
    }

    @Override
    @Unique
    public CompoundTag getHamsterShoulderEntity() {
        return (CompoundTag)this.m_20088_().m_135370_(HAMSTER_SHOULDER_ENTITY);
    }

    @Override
    @Unique
    public void setHamsterShoulderEntity(CompoundTag nbt) {
        this.m_20088_().m_135381_(HAMSTER_SHOULDER_ENTITY, (Object)nbt);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onTick(CallbackInfo ci) {
        CompoundTag shoulderNbt;
        Player self = (Player)this;
        Level world = self.m_9236_();
        if (world.f_46443_) {
            return;
        }
        RandomSource random = world.m_213780_();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (this.adorablehamsterpets$diamondSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$diamondSoundCooldownTicks;
        }
        if (this.adorablehamsterpets$creeperSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$creeperSoundCooldownTicks;
        }
        if (!(shoulderNbt = this.getHamsterShoulderEntity()).m_128456_()) {
            if (self.m_6144_()) {
                HamsterEntity.spawnFromNbt((ServerLevel)world, self, shoulderNbt, this.adorablehamsterpets$isDiamondAlertConditionMet);
                this.adorablehamsterpets$isDiamondAlertConditionMet = false;
                this.setHamsterShoulderEntity(new CompoundTag());
                world.m_5594_(null, self.m_20183_(), (SoundEvent)ModSounds.HAMSTER_DISMOUNT.get(), SoundSource.PLAYERS, 0.7f, 1.0f + random.m_188501_() * 0.2f);
                if (config.enableShoulderDismountMessages && !DISMOUNT_MESSAGE_KEYS.isEmpty()) {
                    String chosenKey;
                    if (DISMOUNT_MESSAGE_KEYS.size() == 1) {
                        chosenKey = DISMOUNT_MESSAGE_KEYS.get(0);
                    } else {
                        ArrayList<String> availableKeys = new ArrayList<String>(DISMOUNT_MESSAGE_KEYS);
                        availableKeys.remove(this.adorablehamsterpets$lastDismountMessageKey);
                        chosenKey = availableKeys.isEmpty() ? this.adorablehamsterpets$lastDismountMessageKey : (String)availableKeys.get(random.m_188503_(availableKeys.size()));
                    }
                    self.m_5661_((Component)Component.m_237115_((String)chosenKey), true);
                    this.adorablehamsterpets$lastDismountMessageKey = chosenKey;
                }
                return;
            }
            if (config.enableShoulderDiamondDetection) {
                ++this.adorablehamsterpets$diamondCheckTimer;
                if (this.adorablehamsterpets$diamondCheckTimer >= 20) {
                    this.adorablehamsterpets$diamondCheckTimer = 0;
                    if (this.isDiamondNearby(self, (Double)config.shoulderDiamondDetectionRadius.get())) {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = true;
                        if (this.adorablehamsterpets$diamondSoundCooldownTicks == 0) {
                            world.m_5594_(null, self.m_20183_(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, random), SoundSource.NEUTRAL, 2.5f, 1.0f);
                            self.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.diamond_nearby").m_130940_(ChatFormatting.AQUA), true);
                            this.adorablehamsterpets$diamondSoundCooldownTicks = random.m_216332_(140, 200);
                            ModCriteria.HAMSTER_DIAMOND_ALERT_TRIGGERED.trigger((ServerPlayer)self);
                        }
                    } else {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
                    }
                }
            }
            if (config.enableShoulderCreeperDetection) {
                ++this.adorablehamsterpets$creeperCheckTimer;
                if (this.adorablehamsterpets$creeperCheckTimer >= 20) {
                    this.adorablehamsterpets$creeperCheckTimer = 0;
                    if (this.creeperSeesPlayer(self, (Double)config.shoulderCreeperDetectionRadius.get()) && this.adorablehamsterpets$creeperSoundCooldownTicks == 0) {
                        world.m_5594_(null, self.m_20183_(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CREEPER_DETECT_SOUNDS, random), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        self.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.creeper_detected").m_130940_(ChatFormatting.RED), true);
                        this.adorablehamsterpets$creeperSoundCooldownTicks = random.m_216332_(100, 160);
                        ModCriteria.HAMSTER_CREEPER_ALERT_TRIGGERED.trigger((ServerPlayer)self);
                    }
                }
            }
        }
    }

    @Unique
    private boolean isDiamondNearby(Player player, double radius) {
        Level world = player.m_9236_();
        BlockPos center = player.m_20183_();
        int intRadius = (int)Math.ceil(radius);
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)center.m_7918_(-intRadius, -intRadius, -intRadius), (BlockPos)center.m_7918_(intRadius, intRadius, intRadius))) {
            BlockState state;
            if (!(checkPos.m_123331_((Vec3i)center) <= radius * radius) || !(state = world.m_8055_(checkPos)).m_60713_(Blocks.f_50089_) && !state.m_60713_(Blocks.f_152474_)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private boolean creeperSeesPlayer(Player player, double radius) {
        AABB searchBox;
        Level world = player.m_9236_();
        List nearbyCreepers = world.m_6443_(Creeper.class, searchBox = new AABB(player.m_20182_().m_82492_(radius, radius, radius), player.m_20182_().m_82520_(radius, radius, radius)), creeper -> creeper.m_6084_() && creeper.m_5448_() == player && EntitySelector.f_20402_.test(creeper));
        return !nearbyCreepers.isEmpty();
    }

    @Override
    @Unique
    public int ahp_getLastGoldMessageIndex() {
        return this.adorablehamsterpets$lastGoldMessageIndex;
    }

    @Override
    @Unique
    public void ahp_setLastGoldMessageIndex(int index) {
        this.adorablehamsterpets$lastGoldMessageIndex = index;
    }
}

