/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.networking;

import dev.architectury.networking.NetworkManager;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ModPackets {
    public static final ResourceLocation THROW_HAMSTER_ID = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"throw_hamster");
    public static final ResourceLocation UPDATE_HAMSTER_RENDER_STATE_ID = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"update_hamster_render_state");
    public static final ResourceLocation START_HAMSTER_FLIGHT_SOUND_ID = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"start_hamster_flight_sound");
    public static final ResourceLocation START_HAMSTER_THROW_SOUND_ID = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"start_hamster_throw_sound");

    public static void registerC2SPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)THROW_HAMSTER_ID, (buf, context) -> context.queue(() -> HamsterEntity.tryThrowFromShoulder((ServerPlayer)context.getPlayer())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)UPDATE_HAMSTER_RENDER_STATE_ID, (buf, context) -> {
            int entityId = buf.readInt();
            boolean isRendering = buf.readBoolean();
            context.queue(() -> {
                if (isRendering) {
                    HamsterRenderTracker.addPlayer(entityId, context.getPlayer().m_20148_());
                } else {
                    HamsterRenderTracker.removePlayer(entityId, context.getPlayer().m_20148_());
                }
            });
        });
    }

    public static void registerS2CPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)START_HAMSTER_FLIGHT_SOUND_ID, (buf, context) -> {
            int entityId = buf.readInt();
            context.queue(() -> AdorableHamsterPetsClient.handleStartFlightSound(entityId));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)START_HAMSTER_THROW_SOUND_ID, (buf, context) -> {
            int entityId = buf.readInt();
            context.queue(() -> AdorableHamsterPetsClient.handleStartThrowSound(entityId));
        });
    }
}

