/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.screen;

import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.screen.slot.HamsterSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class HamsterInventoryScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    @Nullable
    private final HamsterEntity hamsterEntityInstance;

    public HamsterInventoryScreenHandler(int syncId, Inventory playerInventory, @Nullable HamsterEntity hamsterEntity) {
        super((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get(), syncId);
        if (hamsterEntity != null) {
            this.inventory = hamsterEntity;
            this.hamsterEntityInstance = hamsterEntity;
            HamsterInventoryScreenHandler.m_38869_((Container)this.inventory, (int)6);
        } else {
            AdorableHamsterPets.LOGGER.warn("Could not find HamsterEntity on client, using empty inventory.");
            this.inventory = new SimpleContainer(6);
            this.hamsterEntityInstance = null;
        }
        this.inventory.m_5856_(playerInventory.f_35978_);
        this.setupSlots(playerInventory);
    }

    @Nullable
    public HamsterEntity getHamsterEntity() {
        return this.hamsterEntityInstance;
    }

    private void setupSlots(Inventory playerInventory) {
        int i;
        this.m_38897_(new HamsterSlot(this.inventory, 0, 26, 95));
        this.m_38897_(new HamsterSlot(this.inventory, 1, 44, 95));
        this.m_38897_(new HamsterSlot(this.inventory, 2, 62, 95));
        this.m_38897_(new Slot((Container)new SimpleContainer(1), 0, 80, 95){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player playerEntity) {
                return false;
            }

            public boolean m_6659_() {
                return false;
            }
        });
        this.m_38897_(new HamsterSlot(this.inventory, 3, 98, 95));
        this.m_38897_(new HamsterSlot(this.inventory, 4, 116, 95));
        this.m_38897_(new HamsterSlot(this.inventory, 5, 134, 95));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 140 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 198));
        }
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack sourceStack = slot.m_7993_();
            itemStack = sourceStack.m_41777_();
            int hamsterInvSize = 6;
            int gapSlotIndex = 3;
            int totalHamsterAreaSlots = hamsterInvSize + 1;
            if (slotIndex < totalHamsterAreaSlots && slotIndex != gapSlotIndex) {
                if (!this.m_38903_(sourceStack, totalHamsterAreaSlots, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (slotIndex >= totalHamsterAreaSlots) {
                if (this.hamsterEntityInstance != null && this.hamsterEntityInstance.isItemDisallowed(sourceStack)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(sourceStack, 0, gapSlotIndex, false) && !this.m_38903_(sourceStack, gapSlotIndex + 1, totalHamsterAreaSlots, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (sourceStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (sourceStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, sourceStack);
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.inventory.m_5785_(player);
    }
}

