/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.forge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.world.ModWorldGeneration;
import net.dawson.adorablehamsterpets.world.forge.ModBiomeModifiers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record ConfigurableFeatureModifier(HolderSet<Biome> biomes, Optional<HolderSet<PlacedFeature>> featuresToAdd, Optional<HolderSet<PlacedFeature>> featuresToRemove) implements BiomeModifier
{
    public static final MapCodec<ConfigurableFeatureModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).fieldOf("biomes").forGetter(ConfigurableFeatureModifier::biomes), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256988_).optionalFieldOf("features_to_add").forGetter(ConfigurableFeatureModifier::featuresToAdd), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256988_).optionalFieldOf("features_to_remove").forGetter(ConfigurableFeatureModifier::featuresToRemove)).apply((Applicative)instance, ConfigurableFeatureModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        String biomeName = biome.m_203543_().map(k -> k.m_135782_().toString()).orElse("unknown");
        AdorableHamsterPets.LOGGER.debug("[AHP Feature Modifier] Running modify for biome: {} in phase: {}", (Object)biomeName, (Object)phase);
        if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
            this.featuresToAdd.ifPresent(additions -> {
                for (Holder feature : additions) {
                    String featureName = feature.m_203543_().map(k -> k.m_135782_().toString()).orElse("unknown");
                    AdorableHamsterPets.LOGGER.debug("[AHP Feature Modifier] Considering ADDING feature '{}' to biome '{}'", (Object)featureName, (Object)biomeName);
                    if (this.shouldFeatureBeInBiome((Holder<PlacedFeature>)feature, biome)) {
                        builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, feature);
                        AdorableHamsterPets.LOGGER.debug("    -> SUCCESS: Added feature '{}' to biome '{}'", (Object)featureName, (Object)biomeName);
                        continue;
                    }
                    AdorableHamsterPets.LOGGER.debug("    -> SKIPPED: Feature '{}' is not valid for biome '{}'", (Object)featureName, (Object)biomeName);
                }
            });
        }
        if (phase == BiomeModifier.Phase.REMOVE && this.biomes.m_203333_(biome)) {
            this.featuresToRemove.ifPresent(removals -> {
                for (Holder feature : removals) {
                    String featureName = feature.m_203543_().map(k -> k.m_135782_().toString()).orElse("unknown");
                    AdorableHamsterPets.LOGGER.debug("[AHP Feature Modifier] Considering REMOVING feature '{}' from biome '{}'", (Object)featureName, (Object)biomeName);
                    if (this.shouldFeatureBeInBiome((Holder<PlacedFeature>)feature, biome)) {
                        boolean removed = builder.getGenerationSettings().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).remove(feature);
                        AdorableHamsterPets.LOGGER.debug("    -> SUCCESS: Removed feature '{}' from biome '{}'. Was present: {}", new Object[]{featureName, biomeName, removed});
                        continue;
                    }
                    AdorableHamsterPets.LOGGER.debug("    -> SKIPPED: Feature '{}' is not valid for biome '{}'", (Object)featureName, (Object)biomeName);
                }
            });
        }
    }

    private boolean shouldFeatureBeInBiome(Holder<PlacedFeature> feature, Holder<Biome> biome) {
        String featurePath;
        return switch (featurePath = feature.m_203543_().map(key -> key.m_135782_().m_135815_()).orElse("")) {
            case "custom_sunflower_placed", "patch_sunflower" -> ModWorldGeneration.isSunflowerPlains(biome);
            case "wild_green_bean_bush_placed" -> ModWorldGeneration.isGreenBeanBiome(biome);
            case "wild_cucumber_bush_placed" -> ModWorldGeneration.isCucumberBiome(biome);
            default -> true;
        };
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ModBiomeModifiers.CONFIGURABLE_FEATURE_MODIFIER.get();
    }
}

