/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.forge;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.world.forge.ModBiomeModifiers;
import net.dawson.adorablehamsterpets.world.gen.ModEntitySpawns;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class ConfigurableHamsterSpawnModifier
implements BiomeModifier {
    public static final MapCodec<ConfigurableHamsterSpawnModifier> CODEC = MapCodec.unit(ConfigurableHamsterSpawnModifier::new);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.ADD) {
            return;
        }
        String biomeName = biome.m_203543_().map(k -> k.m_135782_().toString()).orElse("unknown");
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Modifier] Running modify for biome: {}", (Object)biomeName);
        if (biome.m_203543_().map(key -> ModEntitySpawns.isKeyInSpawnList(key.m_135782_())).orElse(false).booleanValue()) {
            MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
            MobSpawnSettings.SpawnerData spawnEntry = new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HAMSTER.get(), ((Integer)Configs.AHP.spawnWeight.get()).intValue(), 1, ((Integer)Configs.AHP.maxGroupSize.get()).intValue());
            spawnBuilder.m_48376_(MobCategory.CREATURE, spawnEntry);
            AdorableHamsterPets.LOGGER.debug("    -> SUCCESS: Added hamster spawn to biome '{}'", (Object)biomeName);
        } else {
            AdorableHamsterPets.LOGGER.debug("    -> SKIPPED: Biome '{}' is not in the hamster spawn list.", (Object)biomeName);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ModBiomeModifiers.CONFIGURABLE_HAMSTER_SPAWN.get();
    }
}

