/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.forge;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModSpawnPlacementsImpl {
    private static final List<SpawnPlacementData<?>> PENDING_PLACEMENTS = new ArrayList();

    public static <T extends Mob> void register(EntityType<T> entityType, SpawnPlacements.Type location, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
        PENDING_PLACEMENTS.add(new SpawnPlacementData<T>(entityType, location, heightmapType, predicate));
    }

    @SubscribeEvent
    public static void onRegisterSpawnPlacements(SpawnPlacementRegisterEvent event) {
        for (SpawnPlacementData<?> data : PENDING_PLACEMENTS) {
            data.register(event);
        }
        PENDING_PLACEMENTS.clear();
    }

    private record SpawnPlacementData<T extends Mob>(EntityType<T> entityType, SpawnPlacements.Type location, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
        void register(SpawnPlacementRegisterEvent event) {
            event.register(this.entityType, this.location, this.heightmapType, this.predicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
        }
    }
}

