/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.gen;

import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.HashSet;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ModEntitySpawns {
    public static final Set<Block> VALID_SPAWN_BLOCKS = new HashSet<Block>();

    public static void initialize() {
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] Initializing biome modifications for hamster spawns.");
        BiomeModifications.addProperties(ModEntitySpawns::shouldSpawnInBiome, (context, props) -> {
            context.getKey().ifPresent(key -> AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] Applying spawn entry to biome: {}", (Object)key.toString()));
            props.getSpawnProperties().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HAMSTER.get(), ((Integer)Configs.AHP.spawnWeight.get()).intValue(), 1, ((Integer)Configs.AHP.maxGroupSize.get()).intValue()));
        });
    }

    public static boolean shouldSpawnInBiome(BiomeModifications.BiomeContext ctx) {
        boolean shouldSpawn = ctx.getKey().filter(ModEntitySpawns::isKeyInSpawnList).isPresent();
        ctx.getKey().ifPresent(key -> AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] Checking biome [{}]: Should spawn? -> {}", (Object)key.toString(), (Object)shouldSpawn));
        return shouldSpawn;
    }

    public static boolean isKeyInSpawnList(ResourceLocation id) {
        return ModEntitySpawns.matchesAnyBiomeKey(id, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186755_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48182_, Biomes.f_271432_, Biomes.f_151785_, Biomes.f_151784_, Biomes.f_220594_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48203_, Biomes.f_48202_, Biomes.f_48176_, Biomes.f_186754_, Biomes.f_186762_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186768_, Biomes.f_186759_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_48197_, Biomes.f_186760_, Biomes.f_48215_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48151_, Biomes.f_48206_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_186753_, Biomes.f_48217_);
    }

    @SafeVarargs
    public static boolean matchesAnyBiomeKey(ResourceLocation id, ResourceKey<Biome> ... keysToMatch) {
        if (id == null) {
            return false;
        }
        for (ResourceKey<Biome> k : keysToMatch) {
            if (!k.m_135782_().equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSnowyBiome(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203543_().map(key -> ModEntitySpawns.matchesAnyBiomeKey(key.m_135782_(), Biomes.f_186761_, Biomes.f_48152_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186755_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)).orElse(false);
    }

    public static boolean isIceSpikesBiome(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203565_(Biomes.f_48182_);
    }

    public static boolean isCherryGroveBiome(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203565_(Biomes.f_271432_);
    }

    public static boolean isDesertBiome(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203565_(Biomes.f_48203_);
    }

    public static boolean isPlainsBiome(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203543_().map(key -> ModEntitySpawns.matchesAnyBiomeKey(key.m_135782_(), Biomes.f_48202_, Biomes.f_48176_, Biomes.f_186754_)).orElse(false);
    }

    public static boolean isSwampBiome(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203543_().map(key -> ModEntitySpawns.matchesAnyBiomeKey(key.m_135782_(), Biomes.f_48207_, Biomes.f_220595_)).orElse(false);
    }

    public static boolean isCaveBiome(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203543_().map(key -> ModEntitySpawns.matchesAnyBiomeKey(key.m_135782_(), Biomes.f_151785_, Biomes.f_151784_, Biomes.f_220594_)).orElse(false);
    }

    public static boolean isOldGrowthBirchForest(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203565_(Biomes.f_186762_);
    }

    public static boolean isWindsweptOrStonyPeaks(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203543_().map(key -> ModEntitySpawns.matchesAnyBiomeKey(key.m_135782_(), Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186768_, Biomes.f_186759_)).orElse(false);
    }

    public static boolean isJungleBiome(Holder<Biome> biomeEntry) {
        return biomeEntry.m_203656_(BiomeTags.f_207610_);
    }

    static {
        VALID_SPAWN_BLOCKS.add(Blocks.f_49992_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_49993_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50352_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50287_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50288_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50289_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50290_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50291_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50292_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50293_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50294_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50295_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50296_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50297_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50298_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50299_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50300_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50301_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50302_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50069_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50334_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50228_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50122_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_49994_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50493_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50546_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50599_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50127_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50195_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_220864_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_220843_);
    }
}

