/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.salju.kobolds.entity.Kobold;
import net.salju.kobolds.entity.KoboldCaptain;
import net.salju.kobolds.entity.KoboldChild;
import net.salju.kobolds.entity.KoboldEnchanter;
import net.salju.kobolds.entity.KoboldEngineer;
import net.salju.kobolds.entity.KoboldWarrior;
import net.salju.kobolds.entity.KoboldZombie;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsMobs;
import net.salju.kobolds.init.KoboldsModSounds;
import net.salju.kobolds.item.KoboldPotionUtils;

public abstract class AbstractKoboldEntity
extends PathfinderMob
implements CrossbowAttackMob,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.m_135353_(AbstractKoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DIAMOND_EYES = SynchedEntityData.m_135353_(AbstractKoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack primary = new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get());
    private ItemStack trident = ItemStack.f_41583_;
    private UUID thrownTrident = null;
    private boolean partyKobold;
    private int breed;
    private int cooldown;
    private int potion;
    @Nullable
    private BlockPos jukebox;

    protected AbstractKoboldEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.m_21553_(true);
        this.m_21530_();
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Primary", (Tag)this.primary.m_41739_(new CompoundTag()));
        tag.m_128365_("Trident", (Tag)this.trident.m_41739_(new CompoundTag()));
        if (this.thrownTrident != null) {
            tag.m_128362_("TridentUUID", this.thrownTrident);
        }
        tag.m_128405_("Breed", this.breed);
        tag.m_128405_("CD", this.cooldown);
        tag.m_128405_("PCD", this.potion);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.primary = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Primary"));
        this.trident = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Trident"));
        if (tag.m_128441_("TridentUUID")) {
            this.thrownTrident = tag.m_128342_("TridentUUID");
        }
        this.breed = tag.m_128451_("Breed");
        this.cooldown = tag.m_128451_("CD");
        this.potion = tag.m_128451_("PCD");
    }

    protected boolean m_8028_() {
        return false;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.225;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21532_();
    }

    public void m_6504_(LivingEntity target, float f) {
        if (this.m_21205_().m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 2.0f);
        } else {
            Item item = this.m_21205_().m_41720_();
            if (item instanceof BowItem) {
                BowItem bow = (BowItem)item;
                AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)this.m_21205_(), (float)f);
                arrow = bow.customArrow(arrow);
                double d0 = target.m_20185_() - this.m_20185_();
                double d1 = target.m_20227_(0.3333333333333333) - arrow.m_20186_();
                double d2 = target.m_20189_() - this.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
                this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                this.m_9236_().m_7967_((Entity)arrow);
            } else if (this.m_21206_().m_41720_() instanceof TridentItem) {
                this.trident = this.m_21206_();
                ThrownTrident proj = new ThrownTrident(this.m_9236_(), (LivingEntity)this, this.trident);
                double d0 = target.m_20185_() - this.m_20185_();
                double d1 = target.m_20227_(0.3333333333333333) - proj.m_20186_();
                double d2 = target.m_20189_() - this.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                proj.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
                this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                this.m_9236_().m_7967_((Entity)proj);
                this.m_21008_(InteractionHand.MAIN_HAND, this.primary);
                this.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                this.thrownTrident = proj.m_20148_();
                this.setCD(1200);
            }
        }
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_5811_(LivingEntity arg0, ItemStack arg1, Projectile arg2, float arg3) {
        this.m_32322_((LivingEntity)this, arg0, arg2, arg3, 1.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CHARGING_STATE, (Object)false);
        this.f_19804_.m_135372_(DATA_DIAMOND_EYES, (Object)false);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING_STATE);
    }

    public void m_6136_(boolean check) {
        this.f_19804_.m_135381_(DATA_CHARGING_STATE, (Object)check);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public ItemStack m_255207_(ItemStack stack) {
        EquipmentSlot slot = AbstractKoboldEntity.m_147233_((ItemStack)stack);
        ItemStack current = this.m_6844_(slot);
        boolean flag = this.m_7808_(stack, current);
        if (stack.m_41720_() == Items.f_42616_ || stack.m_41720_() instanceof TridentItem) {
            slot = EquipmentSlot.OFFHAND;
            current = this.m_6844_(slot);
            flag = this.m_7808_(stack, current);
        }
        if (flag && this.m_7252_(stack)) {
            double d0 = this.m_21519_(slot);
            if (!current.m_41619_() && (double)Math.max(this.f_19796_.m_188501_() - 0.1f, 0.0f) < d0) {
                this.m_19983_(current);
            }
            if (stack.m_41720_() == Items.f_42616_ && stack.m_41613_() > 1) {
                stack = stack.m_41620_(1);
            }
            if (slot.m_254934_() && stack.m_41613_() > 1) {
                ItemStack copy = stack.m_255036_(1);
                this.m_21468_(slot, copy);
                return copy;
            }
            this.m_21468_(slot, stack);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    protected boolean m_7808_(ItemStack drop, ItemStack hand) {
        if (drop.m_41720_() instanceof SwordItem) {
            if (hand.m_41720_() instanceof SwordItem) {
                SwordItem newbie = (SwordItem)drop.m_41720_();
                SwordItem weapon = (SwordItem)hand.m_41720_();
                if (newbie.m_43299_() != weapon.m_43299_()) {
                    return newbie.m_43299_() > weapon.m_43299_();
                }
                return this.m_21477_(drop, hand);
            }
            if (!(hand.m_41720_() instanceof CrossbowItem) && !(hand.m_41720_() instanceof BowItem)) {
                return hand.m_41619_() ? this.trident.m_41619_() : true;
            }
        } else if (drop.m_41720_() instanceof AxeItem) {
            if (hand.m_41720_() instanceof AxeItem) {
                AxeItem newbie = (AxeItem)drop.m_41720_();
                AxeItem weapon = (AxeItem)hand.m_41720_();
                if (newbie.m_41008_() != weapon.m_41008_()) {
                    return newbie.m_41008_() > weapon.m_41008_();
                }
                return this.m_21477_(drop, hand);
            }
            if (!(hand.m_41720_() instanceof CrossbowItem) && !(hand.m_41720_() instanceof BowItem)) {
                return hand.m_41619_() ? this.trident.m_41619_() : true;
            }
        } else if (drop.m_41720_() instanceof CrossbowItem || drop.m_41720_() instanceof BowItem) {
            if (hand.m_41720_() instanceof CrossbowItem || hand.m_41720_() instanceof BowItem) {
                return this.m_21477_(drop, hand);
            }
            if (!(hand.m_41720_() instanceof TieredItem)) {
                return hand.m_41619_() ? this.trident.m_41619_() : true;
            }
        } else if (drop.m_41720_() instanceof ArmorItem) {
            if (EnchantmentHelper.m_44920_((ItemStack)hand)) {
                return false;
            }
            if (hand.m_41619_() || hand.m_41720_() instanceof BlockItem) {
                return true;
            }
            if (hand.m_41720_() instanceof ArmorItem) {
                ArmorItem newbie = (ArmorItem)drop.m_41720_();
                ArmorItem worn = (ArmorItem)hand.m_41720_();
                if (newbie.m_40404_() != worn.m_40404_()) {
                    return newbie.m_40404_() > worn.m_40404_();
                }
                if (newbie.m_40405_() != worn.m_40405_()) {
                    return newbie.m_40405_() > worn.m_40405_();
                }
                return this.m_21477_(drop, hand);
            }
        } else if (drop.m_41720_() instanceof ShieldItem) {
            if (hand.m_41720_() instanceof ShieldItem) {
                return this.m_21477_(drop, hand);
            }
            if (hand.m_41619_() && this.trident.m_41619_()) {
                return true;
            }
        } else if (drop.m_41720_() instanceof TridentItem) {
            if (hand.m_41720_() instanceof TridentItem && this.m_21477_(drop, hand)) {
                this.trident = drop;
                return true;
            }
            if (hand.m_41619_() && this.trident.m_41619_()) {
                this.primary = this.m_21205_();
                this.trident = drop;
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                return true;
            }
        } else if (drop.m_41720_() == Items.f_42616_ && hand.m_41619_() && !(this instanceof KoboldCaptain) && !(this instanceof KoboldWarrior)) {
            return true;
        }
        return false;
    }

    public void m_8107_() {
        this.m_21203_();
        this.updateNoActionTime();
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 32.76) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.partyKobold = false;
            this.jukebox = null;
        }
        super.m_8107_();
    }

    public void updateNoActionTime() {
        float f = this.m_213856_();
        if (f > 0.5f) {
            this.f_20891_ += 2;
        }
    }

    public void m_6818_(BlockPos pos, boolean boop) {
        this.jukebox = pos;
        this.partyKobold = boop;
    }

    public void setCD(int i) {
        this.cooldown = i;
    }

    public void setBreed(int i) {
        this.breed = i;
    }

    public void setPotionCD(int i) {
        this.potion = i;
    }

    public boolean isPartyKobold() {
        return this.partyKobold;
    }

    public boolean isDiamond() {
        return (Boolean)this.m_20088_().m_135370_(DATA_DIAMOND_EYES);
    }

    public int getCD() {
        return this.cooldown;
    }

    public int getBreed() {
        return this.breed;
    }

    public int getPotionCD() {
        return this.potion;
    }

    public SoundEvent m_7515_() {
        return this.m_6162_() ? (SoundEvent)KoboldsModSounds.KOBOLD_YIP.get() : (SoundEvent)KoboldsModSounds.KOBOLD_IDLE.get();
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return this.m_21254_() ? SoundEvents.f_12346_ : (SoundEvent)KoboldsModSounds.KOBOLD_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)KoboldsModSounds.KOBOLD_DEATH.get();
    }

    public void m_6667_(DamageSource source) {
        if (source.m_7640_() instanceof Zombie && !this.m_6162_()) {
            this.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)level;
                InteractionHand hand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, stack -> stack == KoboldsItems.KOBOLD_POTION.get());
                if (this.m_21120_(hand).m_150930_((Item)KoboldsItems.KOBOLD_POTION.get())) {
                    if (this.m_21206_().m_41720_() instanceof ShieldItem) {
                        this.m_21008_(hand, this.getPrimaryWeapon());
                    } else {
                        this.m_21008_(hand, ItemStack.f_41583_);
                    }
                }
                KoboldZombie zombo = (KoboldZombie)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_ZOMBIE.get(), true);
                zombo.setZombo(this);
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)zombo);
            }
        }
        super.m_6667_(source);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack gem = player.m_21120_(hand).m_41777_();
        if (this.m_6084_()) {
            if (player.m_21205_().m_41619_() && player.m_21206_().m_41619_()) {
                this.m_5496_((SoundEvent)KoboldsModSounds.KOBOLD_PURR.get(), 1.0f, this.m_6162_() ? 1.2f : 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (gem.m_150930_((Item)KoboldsItems.KOBOLD_SPAWN_EGG.get()) && !this.m_6162_()) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)level;
                    BlockPos spawn = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_());
                    KoboldChild koboldChild = (KoboldChild)((EntityType)KoboldsMobs.KOBOLD_CHILD.get()).m_262496_(lvl, spawn, MobSpawnType.BREEDING);
                }
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_21515_() && !this.m_9236_().m_5776_() && !this.m_6162_()) {
                if (gem.m_150930_(Items.f_151049_) && this.breed <= 0) {
                    this.setBreed(20000);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.m_21206_().m_41619_()) {
                    if (gem.m_41720_() instanceof AxeItem && hand != InteractionHand.MAIN_HAND && this instanceof Kobold) {
                        this.m_21008_(InteractionHand.OFF_HAND, gem);
                        if (!player.m_7500_()) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (gem.m_150930_(Items.f_42616_) && (this instanceof Kobold || this instanceof KoboldEnchanter || this instanceof KoboldEngineer)) {
                        gem.m_41764_(1);
                        this.m_21008_(InteractionHand.OFF_HAND, gem);
                        if (!player.m_7500_()) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return super.m_6071_(player, hand);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        this.m_213945_(world.m_213780_(), difficulty);
        this.m_213946_(world.m_213780_(), difficulty);
        return super.m_6518_(world, difficulty, reason, data, tag);
    }

    protected void m_213945_(RandomSource randy, DifficultyInstance souls) {
        if (this.m_6095_() == KoboldsMobs.KOBOLD_WARRIOR.get()) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_AXE.get()));
        } else if (this.m_6095_() == KoboldsMobs.KOBOLD_RASCAL.get() || this.m_6095_() == KoboldsMobs.KOBOLD_CAPTAIN.get()) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
        } else if (this.m_6095_() == KoboldsMobs.KOBOLD_ENGINEER.get()) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
        } else if (this.m_6095_() == KoboldsMobs.KOBOLD.get() || this.m_6095_() == KoboldsMobs.KOBOLD_PIRATE.get()) {
            if (Math.random() >= 0.6) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
            }
        }
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        if (this.m_6095_() == KoboldsMobs.KOBOLD_WARRIOR.get()) {
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        } else if (this.m_6095_() == KoboldsMobs.KOBOLD_PIRATE.get() && Math.random() >= 0.75) {
            this.primary = this.m_21205_();
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42713_));
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            this.trident = this.m_21206_();
        }
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    public ItemStack m_6298_(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weapon = (ProjectileWeaponItem)item;
            ItemStack extra = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)weapon.m_6442_());
            return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)stack, (ItemStack)(extra.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : extra));
        }
        return super.m_6298_(stack);
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.m_21515_()) {
            this.checkTrident();
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.potion > 0) {
                --this.potion;
            } else if (this.m_21223_() < 12.0f) {
                this.givePotion(KoboldPotionUtils.makePotion(new ItemStack((ItemLike)KoboldsItems.KOBOLD_POTION.get()), MobEffects.f_19601_, MobEffects.f_19605_, 1, 900), 900);
            }
            if (this.breed > 0) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)level;
                    if (this.breed > 18000) {
                        AbstractKoboldEntity target = (AbstractKoboldEntity)this.m_9236_().m_45963_(AbstractKoboldEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(64.0));
                        if (Mth.m_216271_((RandomSource)this.f_19796_, (int)1, (int)10) > 8) {
                            double d = this.f_19796_.m_188583_() * 0.02;
                            lvl.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 3, d, d, d, 0.0);
                        }
                        if (target != null && !target.m_7306_((Entity)this) && target.getBreed() > 18000) {
                            if ((double)this.m_20270_((Entity)target) >= 1.0) {
                                this.m_21573_().m_5624_((Entity)target, 1.0);
                            } else if ((double)this.m_20270_((Entity)target) < 1.0) {
                                BlockPos pos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_());
                                KoboldChild baby = (KoboldChild)((EntityType)KoboldsMobs.KOBOLD_CHILD.get()).m_262496_(lvl, pos, MobSpawnType.BREEDING);
                                target.setBreed(18000);
                                this.setBreed(18000);
                            }
                        }
                    }
                }
                if (!this.isDiamond()) {
                    this.m_20088_().m_135381_(DATA_DIAMOND_EYES, (Object)true);
                }
                --this.breed;
                if (this.breed <= 0 && this.isDiamond()) {
                    this.m_20088_().m_135381_(DATA_DIAMOND_EYES, (Object)false);
                }
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity target;
        Entity entity;
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.m_21515_() && this.getPotionCD() <= 0) {
            if ((source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268546_)) && !this.m_21023_(MobEffects.f_19607_)) {
                this.givePotion(KoboldPotionUtils.makePotion(new ItemStack((ItemLike)KoboldsItems.KOBOLD_POTION.get()), MobEffects.f_19607_, null, 3600, 0), 120);
            } else if (source.m_276093_(DamageTypes.f_268722_) && !this.m_21023_(MobEffects.f_19608_)) {
                this.givePotion(KoboldPotionUtils.makePotion(new ItemStack((ItemLike)KoboldsItems.KOBOLD_POTION.get()), MobEffects.f_19608_, null, 3600, 0), 120);
            }
        }
        if (this.m_21254_() && (entity = source.m_7639_()) instanceof LivingEntity && (target = (LivingEntity)entity).m_213824_()) {
            this.setCD(100);
        }
        return source.m_7639_() instanceof AbstractKoboldEntity || source.m_276093_(DamageTypes.f_268631_) ? false : super.m_6469_(source, amount);
    }

    protected void givePotion(ItemStack stack, int i) {
        if (this.m_21206_().m_41720_() instanceof TridentItem || this.m_21206_().m_41720_() instanceof ShieldItem) {
            if (!this.m_21205_().m_41619_()) {
                this.primary = this.m_21205_();
            }
            this.m_21008_(InteractionHand.MAIN_HAND, stack);
            this.setPotionCD(i);
        } else if (this.m_21206_().m_41619_()) {
            this.m_21008_(InteractionHand.OFF_HAND, stack);
            this.setPotionCD(i);
        }
    }

    protected void checkTrident() {
        Level level;
        if (this.thrownTrident != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            if (this.m_21206_().m_41619_() && this.cooldown <= 1180) {
                ThrownTrident proj;
                Entity entity = lvl.m_8791_(this.thrownTrident);
                if (entity instanceof ThrownTrident && (proj = (ThrownTrident)entity).m_19749_().m_7306_((Entity)this)) {
                    if ((double)this.m_20270_((Entity)proj) < 2.0 || this.cooldown == 1) {
                        this.giveTrident(proj);
                    } else if ((double)this.m_20270_((Entity)proj) < 32.0 && this.m_5448_() == null) {
                        this.m_21573_().m_5624_((Entity)proj, 1.0);
                    }
                } else if (lvl.m_8791_(this.thrownTrident) == null && this.cooldown <= 1) {
                    this.giveTrident(null);
                }
            }
        }
    }

    protected void giveTrident(@Nullable ThrownTrident proj) {
        this.primary = this.m_21205_();
        this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        this.m_21008_(InteractionHand.OFF_HAND, this.trident);
        this.thrownTrident = null;
        if (this.cooldown > 1 && proj != null) {
            this.setCD(0);
            proj.m_146870_();
        }
    }

    public ItemStack getPrimaryWeapon() {
        return this.primary;
    }

    public static List<ItemStack> getTradeItems(AbstractKoboldEntity kobold, String table) {
        return kobold.m_9236_().m_7654_().m_278653_().m_278676_(new ResourceLocation(table)).m_287195_(new LootParams.Builder((ServerLevel)kobold.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)kobold).m_287235_(LootContextParamSets.f_81410_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22276_, 18.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        return builder;
    }
}

