/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.worldgen;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.salju.kobolds.entity.KoboldRascal;
import net.salju.kobolds.init.KoboldsMobs;
import net.salju.kobolds.worldgen.KoboldData;

public class KoboldRascalSpawner {
    private final RandomSource randy = RandomSource.m_216327_();
    private final KoboldData data;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public KoboldRascalSpawner(KoboldData info) {
        this.data = info;
        this.tickDelay = 1200;
        this.spawnDelay = info.getRascalDelay();
        this.spawnChance = info.getRascalChance();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 18000;
            info.setRascalDelay(this.spawnDelay);
            this.spawnChance = 25;
            info.setRascalChance(this.spawnChance);
        }
    }

    public int tick(ServerLevel world) {
        if (--this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = 1200;
        this.spawnDelay -= 1200;
        this.data.setRascalDelay(this.spawnDelay);
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = 18000;
        if (!world.m_46469_().m_46207_(GameRules.f_46134_)) {
            return 0;
        }
        int i = this.spawnChance;
        this.spawnChance = Mth.m_14045_((int)(this.spawnChance + 25), (int)25, (int)100);
        this.data.setRascalChance(this.spawnChance);
        if (this.randy.m_188503_(100) > i) {
            return 0;
        }
        if (this.spawn(world)) {
            this.spawnChance = 25;
            return 1;
        }
        return 0;
    }

    private boolean spawn(ServerLevel world) {
        KoboldRascal rascal;
        ServerPlayer player = world.m_8890_();
        if (player == null) {
            return true;
        }
        BlockPos pos = player.m_20183_();
        BlockPos spawn = this.findSpawnPositionNear((LevelReader)world, pos, 32);
        return spawn != null && this.hasEnoughSpace((BlockGetter)world, spawn) && spawn.m_123342_() <= 42 && player.m_9236_().m_46472_() == Level.f_46428_ && (rascal = (KoboldRascal)((EntityType)KoboldsMobs.KOBOLD_RASCAL.get()).m_262496_(world, spawn, MobSpawnType.EVENT)) != null;
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader world, BlockPos pos, int i) {
        BlockPos spawn = null;
        for (int c = 0; c < 25; ++c) {
            int z;
            int y;
            int x = pos.m_123341_() + this.randy.m_188503_(i * 2) - i;
            BlockPos poz = new BlockPos(x, y = pos.m_123342_() + this.randy.m_188503_(i * 2) - i, z = pos.m_123343_() + this.randy.m_188503_(i * 2) - i);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)world, (BlockPos)poz, (EntityType)((EntityType)KoboldsMobs.KOBOLD_RASCAL.get()))) continue;
            spawn = poz;
            break;
        }
        return spawn;
    }

    private boolean hasEnoughSpace(BlockGetter getter, BlockPos poz) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)poz, (BlockPos)poz.m_7918_(1, 2, 1))) {
            if (getter.m_8055_(pos).m_60812_(getter, pos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

