/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.Config;
import com.tom.storagemod.StorageModClient;
import com.tom.storagemod.gui.ControllMode;
import com.tom.storagemod.gui.CraftingTerminalScreen;
import com.tom.storagemod.gui.GuiButton;
import com.tom.storagemod.gui.StorageTerminalMenu;
import com.tom.storagemod.platform.PlatformContainerScreen;
import com.tom.storagemod.platform.PlatformEditBox;
import com.tom.storagemod.util.ComponentJoiner;
import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.NumberFormatUtil;
import com.tom.storagemod.util.StoredItemStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.lwjgl.glfw.GLFW;

public abstract class AbstractStorageTerminalScreen<T extends StorageTerminalMenu>
extends PlatformContainerScreen<T>
implements IDataReceiver {
    private static final LoadingCache<StoredItemStack, List<String>> tooltipCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<StoredItemStack, List<String>>(){

        public List<String> load(StoredItemStack key) throws Exception {
            return key.getStack().m_41651_((Player)Minecraft.m_91087_().f_91074_, AbstractStorageTerminalScreen.getTooltipFlag()).stream().map(Component::getString).collect(Collectors.toList());
        }
    });
    private static final LoadingCache<StoredItemStack, String> nbtCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> String.valueOf(key.getStack().m_41783_())));
    private static final LoadingCache<StoredItemStack, List<String>> tagCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> key.getStack().m_204131_().map(t -> t.f_203868_().toString()).toList()));
    protected Minecraft mc = Minecraft.m_91087_();
    protected float currentScroll;
    protected boolean isScrolling;
    private boolean refreshItemList;
    protected boolean wasClicking;
    protected PlatformEditBox searchField;
    protected int slotIDUnderMouse = -1;
    protected int controllMode;
    protected int rowCount;
    protected int searchType;
    private String searchLast = "";
    protected boolean loadedSearch = false;
    protected boolean ghostItems;
    protected boolean tallMode;
    public final int textureSlotCount;
    public final int guiHeight;
    public final int slotStartX;
    public final int slotStartY;
    private StoredItemStack.IStoredItemStackComparator comparator = new StoredItemStack.ComparatorAmount(false);
    protected GuiButton buttonSortingType;
    protected GuiButton buttonDirection;
    protected GuiButton buttonSearchType;
    protected GuiButton buttonCtrlMode;
    protected GuiButton buttonGhostMode;
    protected GuiButton buttonTallMode;
    private Comparator<StoredItemStack> sortComp;
    private FakeSlot fakeSlotUnderMouse = new FakeSlot();

    public AbstractStorageTerminalScreen(T screenContainer, Inventory inv, Component titleIn, int textureSlotCount, int guiHeight, int slotStartX, int slotStartY) {
        super(screenContainer, inv, titleIn);
        ((StorageTerminalMenu)screenContainer).onPacket = this::onPacket;
        this.textureSlotCount = textureSlotCount;
        this.guiHeight = guiHeight;
        this.slotStartX = slotStartX;
        this.slotStartY = slotStartY;
    }

    protected void onPacket() {
        boolean tallMode;
        int s = ((StorageTerminalMenu)this.f_97732_).terminalData;
        this.controllMode = (s & 3) % ControllMode.VALUES.length;
        boolean rev = (s & 4) > 0;
        int type = (s & 0x18) >> 3;
        this.comparator = StoredItemStack.SortingTypes.VALUES[type % StoredItemStack.SortingTypes.VALUES.length].create(rev);
        this.searchType = (s & 0xE0) >> 5;
        this.ghostItems = (s & 0x200) == 0;
        boolean bl = tallMode = (s & 0x400) != 0;
        if (tallMode != this.tallMode) {
            this.tallMode = tallMode;
            this.m_7856_();
        }
        if (!this.searchField.m_93696_() && (this.searchType & 1) > 0) {
            this.searchField.m_93692_(true);
        }
        this.buttonSortingType.setState(type);
        this.buttonDirection.setState(rev ? 1 : 0);
        this.buttonSearchType.setState(this.searchType);
        this.buttonCtrlMode.setState(this.controllMode);
        this.buttonGhostMode.setState(this.ghostItems ? 1 : 0);
        this.buttonTallMode.setState(tallMode ? 1 : 0);
        if (!this.loadedSearch && ((StorageTerminalMenu)this.f_97732_).search != null) {
            this.loadedSearch = true;
            if ((this.searchType & 2) > 0) {
                this.searchField.m_94144_(((StorageTerminalMenu)this.f_97732_).search);
            }
        }
    }

    protected void sendUpdate() {
        CompoundTag c = new CompoundTag();
        c.m_128405_("d", this.updateData());
        CompoundTag msg = new CompoundTag();
        msg.m_128365_("c", (Tag)c);
        ((StorageTerminalMenu)this.f_97732_).sendMessage(msg);
    }

    protected int updateData() {
        int d = 0;
        d |= this.controllMode & 3;
        d |= (this.comparator.isReversed() ? 1 : 0) << 2;
        d |= this.comparator.type() << 3;
        d |= (this.searchType & 7) << 5;
        d |= (this.ghostItems ? 0 : 1) << 9;
        return d |= (this.tallMode ? 1 : 0) << 10;
    }

    protected void m_7856_() {
        this.m_169413_();
        if (this.tallMode) {
            int guiSize = this.guiHeight - this.textureSlotCount * 18;
            this.rowCount = (this.f_96544_ - 30 - guiSize) / 18;
            this.f_97727_ = guiSize + this.rowCount * 18;
            ((StorageTerminalMenu)this.f_97732_).setOffset(0, (this.rowCount - this.textureSlotCount) * 18);
            ((StorageTerminalMenu)this.f_97732_).addStorageSlots(this.rowCount, this.slotStartX + 1, this.slotStartY + 1);
        } else {
            this.rowCount = this.textureSlotCount;
            ((StorageTerminalMenu)this.f_97732_).setOffset(0, 0);
            ((StorageTerminalMenu)this.f_97732_).addStorageSlots(this.rowCount, this.slotStartX + 1, this.slotStartY + 1);
        }
        this.f_97731_ = this.f_97727_ - 92;
        super.m_7856_();
        Font font = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.searchField = new PlatformEditBox(font, this.f_97735_ + 82, this.f_97736_ + 6, 89, 9, (Component)Component.m_237115_((String)"narrator.toms_storage.terminal_search"));
        this.searchField.m_94199_(100);
        this.searchField.m_94182_(false);
        this.searchField.m_94194_(true);
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94144_(this.searchLast);
        this.searchLast = "";
        this.m_7787_((GuiEventListener)this.searchField);
        this.buttonSortingType = (GuiButton)this.m_142416_((GuiEventListener)this.makeButton(this.f_97735_ - 18, this.f_97736_ + 5, 0, b -> {
            this.comparator = StoredItemStack.SortingTypes.VALUES[(this.comparator.type() + 1) % StoredItemStack.SortingTypes.VALUES.length].create(this.comparator.isReversed());
            this.buttonSortingType.setState(this.comparator.type());
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonDirection = (GuiButton)this.m_142416_((GuiEventListener)this.makeButton(this.f_97735_ - 18, this.f_97736_ + 5 + 18, 1, b -> {
            this.comparator.setReversed(!this.comparator.isReversed());
            this.buttonDirection.setState(this.comparator.isReversed() ? 1 : 0);
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonSearchType = (GuiButton)this.m_142416_((GuiEventListener)new GuiButton(this.f_97735_ - 18, this.f_97736_ + 5 + 36, 2, b -> {
            this.searchType = this.searchType + 1 & (IAutoFillTerminal.hasSync() || this instanceof CraftingTerminalScreen ? 7 : 3);
            this.buttonSearchType.setState(this.searchType);
            this.sendUpdate();
        }){
            {
                this.texX = 194;
                this.texY = 30;
            }

            @Override
            public void m_87963_(GuiGraphics st, int mouseX, int mouseY, float pt) {
                if (this.f_93624_) {
                    int x = this.m_252754_();
                    int y = this.m_252907_();
                    int state = this.getState();
                    this.f_93622_ = mouseX >= x && mouseY >= y && mouseX < x + this.f_93618_ && mouseY < y + this.f_93619_;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    st.m_280218_(AbstractStorageTerminalScreen.this.getGui(), x, y, this.texX, this.texY + this.tile * 16, this.f_93618_, this.f_93619_);
                    if ((state & 1) > 0) {
                        st.m_280218_(AbstractStorageTerminalScreen.this.getGui(), x + 1, y + 1, this.texX + 16, this.texY + this.tile * 16, this.f_93618_ - 2, this.f_93619_ - 2);
                    }
                    if ((state & 2) > 0) {
                        st.m_280218_(AbstractStorageTerminalScreen.this.getGui(), x + 1, y + 1, this.texX + 16 + 14, this.texY + this.tile * 16, this.f_93618_ - 2, this.f_93619_ - 2);
                    }
                    if ((state & 4) > 0) {
                        st.m_280218_(AbstractStorageTerminalScreen.this.getGui(), x + 1, y + 1, this.texX + 16 + 28, this.texY + this.tile * 16, this.f_93618_ - 2, this.f_93619_ - 2);
                    }
                }
            }
        });
        this.buttonCtrlMode = (GuiButton)this.m_142416_((GuiEventListener)this.makeButton(this.f_97735_ - 18, this.f_97736_ + 5 + 54, 3, b -> {
            this.controllMode = (this.controllMode + 1) % ControllMode.VALUES.length;
            this.buttonCtrlMode.setState(this.controllMode);
            this.sendUpdate();
        }));
        this.buttonGhostMode = (GuiButton)this.m_142416_((GuiEventListener)this.makeButton(this.f_97735_ - 18, this.f_97736_ + 5 + 72, 5, b -> {
            this.ghostItems = !this.ghostItems;
            this.buttonGhostMode.setState(this.ghostItems ? 1 : 0);
            this.sendUpdate();
        }));
        this.buttonTallMode = (GuiButton)this.m_142416_((GuiEventListener)this.makeButton(this.f_97735_ - 18, this.f_97736_ + 5 + 90, 6, b -> {
            this.tallMode = !this.tallMode;
            this.buttonTallMode.setState(this.tallMode ? 1 : 0);
            this.sendUpdate();
            this.m_7856_();
        }));
        this.buttonSortingType.tooltipFactory = s -> Tooltip.m_257550_((Component)Component.m_237115_((String)("tooltip.toms_storage.sorting_" + s)));
        this.buttonSearchType.tooltipFactory = s -> Tooltip.m_257550_((Component)Component.m_237110_((String)("tooltip.toms_storage.search_" + s), (Object[])new Object[]{IAutoFillTerminal.getHandlerName()}));
        this.buttonCtrlMode.tooltipFactory = s -> Tooltip.m_257550_((Component)Arrays.stream(I18n.m_118938_((String)("tooltip.toms_storage.ctrlMode_" + s), (Object[])new Object[0]).split("\\\\")).map(Component::m_237113_).collect(ComponentJoiner.joining((Component)Component.m_237119_(), (Component)Component.m_237113_((String)"\n"))));
        this.buttonGhostMode.tooltipFactory = s -> Tooltip.m_257550_((Component)Component.m_237115_((String)("tooltip.toms_storage.ghostMode_" + s)));
        this.buttonTallMode.tooltipFactory = s -> Tooltip.m_257550_((Component)Component.m_237115_((String)("tooltip.toms_storage.tallMode_" + s)));
        this.updateSearch();
    }

    protected void updateSearch() {
        String searchString = this.searchField.m_94155_();
        if (this.refreshItemList || !this.searchLast.equals(searchString)) {
            Pattern m;
            ((StorageTerminalMenu)this.m_6262_()).itemListClientSorted.clear();
            boolean searchMod = searchString.startsWith("@");
            boolean searchNbt = !searchMod && searchString.startsWith("$");
            boolean searchTag = !searchMod && !searchNbt && searchString.startsWith("#");
            String search = searchMod || searchNbt || searchTag ? searchString.substring(1) : searchString;
            try {
                m = Pattern.compile(search.toLowerCase(), 2);
            }
            catch (Throwable ignore) {
                try {
                    m = Pattern.compile(Pattern.quote(search.toLowerCase()), 2);
                }
                catch (Throwable __) {
                    return;
                }
            }
            try {
                block6: for (int i = 0; i < ((StorageTerminalMenu)this.m_6262_()).itemListClient.size(); ++i) {
                    StoredItemStack is = ((StorageTerminalMenu)this.m_6262_()).itemListClient.get(i);
                    if (is == null || is.getStack() == null) continue;
                    String dspName = searchMod ? BuiltInRegistries.f_257033_.m_7981_((Object)is.getStack().m_41720_()).m_135827_() : (searchNbt && is.getStack().m_41782_() ? (String)nbtCache.get((Object)is) : is.getStack().m_41786_().getString());
                    boolean notDone = true;
                    if (!searchTag && m.matcher(dspName.toLowerCase()).find()) {
                        this.addStackToClientList(is);
                        notDone = false;
                    }
                    if (!notDone || searchMod || searchNbt) continue;
                    List list = searchTag ? (List)tagCache.get((Object)is) : (List)tooltipCache.get((Object)is);
                    for (String lp : list) {
                        if (!m.matcher(lp).find()) continue;
                        this.addStackToClientList(is);
                        continue block6;
                    }
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            Collections.sort(((StorageTerminalMenu)this.m_6262_()).itemListClientSorted, ((StorageTerminalMenu)this.f_97732_).noSort ? this.sortComp : this.comparator);
            if (!this.searchLast.equals(searchString)) {
                ((StorageTerminalMenu)this.m_6262_()).scrollTo(0.0f);
                this.currentScroll = 0.0f;
                if ((this.searchType & 4) > 0) {
                    IAutoFillTerminal.sync(searchString);
                }
                if ((this.searchType & 2) > 0) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128359_("s", searchString);
                    ((StorageTerminalMenu)this.f_97732_).sendMessage(nbt);
                }
                this.onUpdateSearch(searchString);
            } else {
                ((StorageTerminalMenu)this.m_6262_()).scrollTo(this.currentScroll);
            }
            this.refreshItemList = false;
            this.searchLast = searchString;
        }
    }

    private void addStackToClientList(StoredItemStack is) {
        ((StorageTerminalMenu)this.m_6262_()).itemListClientSorted.add(is);
    }

    public static TooltipFlag getTooltipFlag() {
        return Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
    }

    protected void m_181908_() {
        this.updateSearch();
        this.searchField.m_94120_();
    }

    public void m_88315_(GuiGraphics st, int mouseX, int mouseY, float partialTicks) {
        boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) != 0;
        int i = this.f_97735_;
        int j = this.f_97736_;
        int k = i + 174;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + this.rowCount * 18;
        if (this.ghostItems && AbstractStorageTerminalScreen.m_96638_()) {
            if (!((StorageTerminalMenu)this.f_97732_).noSort) {
                List<StoredItemStack> list = ((StorageTerminalMenu)this.m_6262_()).itemListClientSorted;
                Object2IntOpenHashMap map = new Object2IntOpenHashMap();
                map.defaultReturnValue(Integer.MAX_VALUE);
                for (int m = 0; m < list.size(); ++m) {
                    map.put((Object)list.get(m), m);
                }
                this.sortComp = Comparator.comparing(arg_0 -> ((Object2IntMap)map).getInt(arg_0));
                ((StorageTerminalMenu)this.f_97732_).noSort = true;
            }
        } else if (((StorageTerminalMenu)this.f_97732_).noSort) {
            this.sortComp = null;
            ((StorageTerminalMenu)this.f_97732_).noSort = false;
            this.refreshItemList = true;
            ((StorageTerminalMenu)this.f_97732_).itemListClient = new ArrayList<StoredItemStack>(((StorageTerminalMenu)this.f_97732_).itemList);
        }
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((StorageTerminalMenu)this.m_6262_()).scrollTo(this.currentScroll);
        }
        super.m_88315_(st, mouseX, mouseY, partialTicks);
        i = k;
        j = l;
        k = j1;
        this.drawScroll(st, i, j + (int)((float)(k - j - 17) * this.currentScroll), this.needsScrollBars());
        this.searchField.m_88315_(st, mouseX, mouseY, partialTicks);
        if (((StorageTerminalMenu)this.f_97732_).beaconLvl >= 0) {
            int x = 176;
            int y = 24 + this.rowCount * 18;
            st.m_280480_(new ItemStack((ItemLike)Items.f_42065_), this.f_97735_ + x, this.f_97736_ + y);
            if (this.m_6774_(x, y, 16, 16, mouseX, mouseY)) {
                Object info = Config.get().wirelessTermBeaconLvlDim != -1 && ((StorageTerminalMenu)this.f_97732_).beaconLvl >= Config.get().wirelessTermBeaconLvlDim ? "\\" + I18n.m_118938_((String)"tooltip.toms_storage.terminal_beacon.anywhere", (Object[])new Object[0]) : (Config.get().wirelessTermBeaconLvl != -1 && ((StorageTerminalMenu)this.f_97732_).beaconLvl >= Config.get().wirelessTermBeaconLvl ? "\\" + I18n.m_118938_((String)"tooltip.toms_storage.terminal_beacon.sameDim", (Object[])new Object[0]) : "");
                st.m_280666_(this.f_96547_, Arrays.stream(I18n.m_118938_((String)"tooltip.toms_storage.terminal_beacon", (Object[])new Object[]{((StorageTerminalMenu)this.f_97732_).beaconLvl, info}).split("\\\\")).map(Component::m_237113_).collect(Collectors.toList()), mouseX, mouseY);
            }
        }
        if (((StorageTerminalMenu)this.f_97732_).m_142621_().m_41619_() && this.slotIDUnderMouse != -1) {
            StorageTerminalMenu.SlotStorage slot = ((StorageTerminalMenu)this.m_6262_()).storageSlotList.get(this.slotIDUnderMouse);
            if (slot.stack != null) {
                if (slot.stack.getQuantity() > 9999L) {
                    StorageModClient.setTooltip(new Component[]{Component.m_237110_((String)"tooltip.toms_storage.amount", (Object[])new Object[]{slot.stack.getQuantity()})});
                }
                st.m_280153_(this.f_96547_, slot.stack.getActualStack(), mouseX, mouseY);
                StorageModClient.setTooltip(new Component[0]);
            }
        } else {
            this.m_280072_(st, mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics st, int mouseX, int mouseY) {
        super.m_280003_(st, mouseX, mouseY);
        st.m_280168_().m_85836_();
        this.slotIDUnderMouse = this.drawSlots(st, mouseX, mouseY);
        st.m_280168_().m_85849_();
    }

    protected int drawSlots(GuiGraphics st, int mouseX, int mouseY) {
        StorageTerminalMenu term = (StorageTerminalMenu)this.m_6262_();
        int slotHover = -1;
        for (int i = 0; i < term.storageSlotList.size(); ++i) {
            if (!this.drawSlot(st, term.storageSlotList.get(i), mouseX, mouseY)) continue;
            slotHover = i;
        }
        return slotHover;
    }

    protected boolean drawSlot(GuiGraphics st, StorageTerminalMenu.SlotStorage slot, int mouseX, int mouseY) {
        if (slot.stack != null) {
            ItemStack stack = slot.stack.getStack().m_41777_().m_41620_(1);
            int i = slot.xDisplayPosition;
            int j = slot.yDisplayPosition;
            st.m_280480_(stack, i, j);
            st.m_280370_(this.f_96547_, stack, i, j);
            this.drawStackSize(st, this.getFont(), slot.stack.getQuantity(), i, j);
        }
        if (mouseX >= this.getGuiLeft() + slot.xDisplayPosition - 1 && mouseY >= this.getGuiTop() + slot.yDisplayPosition - 1 && mouseX < this.getGuiLeft() + slot.xDisplayPosition + 17 && mouseY < this.getGuiTop() + slot.yDisplayPosition + 17) {
            int l = slot.xDisplayPosition;
            int t = slot.yDisplayPosition;
            AbstractStorageTerminalScreen.m_280359_((GuiGraphics)st, (int)l, (int)t, (int)0);
            return true;
        }
        return false;
    }

    private void drawStackSize(GuiGraphics st, Font fr, long size, int x, int y) {
        float scaleFactor = 0.6f;
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        String stackSize = NumberFormatUtil.formatNumber(size);
        st.m_280168_().m_85836_();
        st.m_280168_().m_85841_(scaleFactor, scaleFactor, scaleFactor);
        st.m_280168_().m_252880_(0.0f, 0.0f, 450.0f);
        float inverseScaleFactor = 1.0f / scaleFactor;
        int X = (int)(((float)x + 0.0f + 16.0f - (float)fr.m_92895_(stackSize) * scaleFactor) * inverseScaleFactor);
        int Y = (int)(((float)y + 0.0f + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        st.m_280056_(fr, stackSize, X, Y, 0xFFFFFF, true);
        st.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
    }

    protected boolean needsScrollBars() {
        return ((StorageTerminalMenu)this.m_6262_()).itemListClientSorted.size() > this.rowCount * 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.slotIDUnderMouse > -1) {
            if (this.isPullOne(mouseButton)) {
                if (((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                this.storageSlotClick(((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack, StorageTerminalMenu.SlotAction.PULL_ONE, this.isTransferOne(mouseButton));
                return true;
            }
            if (this.pullHalf(mouseButton)) {
                if (!((StorageTerminalMenu)this.f_97732_).m_142621_().m_41619_()) {
                    this.storageSlotClick(null, AbstractStorageTerminalScreen.m_96637_() ? StorageTerminalMenu.SlotAction.GET_QUARTER : StorageTerminalMenu.SlotAction.GET_HALF, false);
                    return true;
                }
                if (((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                this.storageSlotClick(((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.m_96637_() ? StorageTerminalMenu.SlotAction.GET_QUARTER : StorageTerminalMenu.SlotAction.GET_HALF, false);
                return true;
            }
            if (!this.pullNormal(mouseButton)) return true;
            if (!((StorageTerminalMenu)this.f_97732_).m_142621_().m_41619_()) {
                this.storageSlotClick(null, StorageTerminalMenu.SlotAction.PULL_OR_PUSH_STACK, false);
                return true;
            }
            if (((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
            if (((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
            this.storageSlotClick(((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.m_96638_() ? StorageTerminalMenu.SlotAction.SHIFT_PULL : StorageTerminalMenu.SlotAction.PULL_OR_PUSH_STACK, false);
            return true;
        }
        if (GLFW.glfwGetKey((long)this.mc.m_91268_().m_85439_(), (int)32) != 0) {
            this.storageSlotClick(null, StorageTerminalMenu.SlotAction.SPACE_CLICK, false);
            return true;
        }
        int n = this.searchField.m_252754_() - this.f_97735_;
        int n2 = this.searchField.m_252907_() - this.f_97736_;
        Objects.requireNonNull(this.getFont());
        if (this.m_6774_(n, n2, 89, 9, mouseX, mouseY)) {
            if (mouseButton != 1) return super.m_6375_(mouseX, mouseY, mouseButton);
            this.searchField.m_94144_("");
            return true;
        }
        this.searchField.m_93692_(false);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    protected void storageSlotClick(StoredItemStack slotStack, StorageTerminalMenu.SlotAction act, boolean mod) {
        ((StorageTerminalMenu)this.f_97732_).sync.sendInteract(slotStack, act, mod);
    }

    public boolean isPullOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1 && AbstractStorageTerminalScreen.m_96638_();
            }
            case RS: {
                return mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && !((StorageTerminalMenu)this.f_97732_).m_142621_().m_41619_();
            }
        }
        return false;
    }

    public boolean isTransferOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return AbstractStorageTerminalScreen.m_96638_() && AbstractStorageTerminalScreen.m_96637_();
            }
            case RS: {
                return AbstractStorageTerminalScreen.m_96638_() && mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && AbstractStorageTerminalScreen.m_96638_();
            }
        }
        return false;
    }

    public boolean pullHalf(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1;
            }
            case RS: {
                return mouseButton == 1;
            }
            case DEF: {
                return mouseButton == 1 && ((StorageTerminalMenu)this.f_97732_).m_142621_().m_41619_();
            }
        }
        return false;
    }

    public boolean pullNormal(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: 
            case RS: 
            case DEF: {
                return mouseButton == 0;
            }
        }
        return false;
    }

    private ControllMode ctrlm() {
        return ControllMode.VALUES[this.controllMode];
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (pKeyCode == 258) {
            return super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        if (this.searchField.m_7933_(pKeyCode, pScanCode, pModifiers) || this.searchField.m_94204_()) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.m_5534_(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (((StorageTerminalMenu)this.f_97732_).itemListClientSorted.size() + 9 - 1) / 9 - 5;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((StorageTerminalMenu)this.f_97732_).scrollTo(this.currentScroll);
        return true;
    }

    public abstract ResourceLocation getGui();

    protected void m_7286_(GuiGraphics st, float partialTicks, int mouseX, int mouseY) {
        if (this.tallMode) {
            st.m_280218_(this.getGui(), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.slotStartY);
            int guiStart = this.textureSlotCount * 18 + this.slotStartY;
            int guiRStart = this.rowCount * 18 + this.slotStartY;
            int guiSize = this.guiHeight - this.textureSlotCount * 18 - this.slotStartY;
            st.m_280218_(this.getGui(), this.f_97735_, this.f_97736_ + guiRStart, 0, guiStart, this.f_97726_, guiSize);
            int scrollbarW = 25;
            st.m_280218_(this.getGui(), this.f_97735_, this.f_97736_ + this.slotStartY, 0, this.slotStartY, this.slotStartX + 162 + scrollbarW, 18);
            for (int i = 1; i < this.rowCount - 1; ++i) {
                st.m_280218_(this.getGui(), this.f_97735_, this.f_97736_ + this.slotStartY + i * 18, 0, this.slotStartY + 18, this.slotStartX + 162 + scrollbarW, 18);
            }
            st.m_280218_(this.getGui(), this.f_97735_, this.f_97736_ + this.slotStartY + (this.rowCount - 1) * 18, 0, this.slotStartY + (this.textureSlotCount - 1) * 18, this.slotStartX + 162 + scrollbarW, 18);
        } else {
            st.m_280218_(this.getGui(), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        }
    }

    public GuiButton makeButton(int x, int y, int tile, Button.OnPress pressable) {
        GuiButton btn = new GuiButton(x, y, tile, pressable);
        btn.texX = 194;
        btn.texY = 30;
        btn.texture = this.getGui();
        return btn;
    }

    protected void onUpdateSearch(String text) {
    }

    @Override
    public void receive(CompoundTag tag) {
        ((StorageTerminalMenu)this.f_97732_).receiveClientNBTPacket(tag);
        this.refreshItemList = true;
    }

    public Slot getSlotUnderMouse() {
        Slot s = super.getSlotUnderMouse();
        if (s != null) {
            return s;
        }
        if (this.slotIDUnderMouse > -1 && ((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack != null) {
            this.fakeSlotUnderMouse.f_40218_.m_6836_(0, ((StorageTerminalMenu)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack());
            return this.fakeSlotUnderMouse;
        }
        return null;
    }

    private static class FakeSlot
    extends Slot {
        private static final Container DUMMY = new SimpleContainer(1);

        public FakeSlot() {
            super(DUMMY, 0, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public boolean m_150651_(Player p_150652_) {
            return false;
        }

        public void m_5852_(ItemStack p_40240_) {
        }

        public ItemStack m_6201_(int p_40227_) {
            return ItemStack.f_41583_;
        }
    }
}

