/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public final class CartWheel {
    private float rotation;
    private float rotationIncrement;
    private final float offsetX;
    private final float offsetZ;
    private final float circumference;
    private double posX;
    private double posZ;
    private double prevPosX;
    private double prevPosZ;
    private final AbstractDrawnEntity cart;

    public CartWheel(AbstractDrawnEntity cartIn, float offsetXIn, float offsetZIn, float circumferenceIn) {
        this.cart = cartIn;
        this.offsetX = offsetXIn;
        this.offsetZ = offsetZIn;
        this.circumference = circumferenceIn;
        this.posX = this.prevPosX = cartIn.m_20185_();
        this.posZ = this.prevPosZ = cartIn.m_20189_();
    }

    public CartWheel(AbstractDrawnEntity cartIn, float offsetX) {
        this(cartIn, offsetX, 0.0f, 3.9269907f);
    }

    public void tick() {
        this.rotation += this.rotationIncrement;
        this.prevPosX = this.posX;
        this.prevPosZ = this.posZ;
        float yaw = (float)Math.toRadians(this.cart.m_146908_());
        float nx = -Mth.m_14031_((float)yaw);
        float nz = Mth.m_14089_((float)yaw);
        this.posX = this.cart.m_20185_() + (double)(nx * this.offsetZ) - (double)(nz * this.offsetX);
        this.posZ = this.cart.m_20189_() + (double)(nz * this.offsetZ) + (double)(nx * this.offsetX);
        double dx = this.posX - this.prevPosX;
        double dz = this.posZ - this.prevPosZ;
        float distanceTravelled = (float)Math.sqrt(dx * dx + dz * dz);
        double dxNormalized = dx / (double)distanceTravelled;
        double dzNormalized = dz / (double)distanceTravelled;
        float travelledForward = Mth.m_14205_((double)(dxNormalized * (double)nx + dzNormalized * (double)nz));
        if ((double)distanceTravelled > 0.2) {
            BlockPos blockpos = new BlockPos(Mth.m_14107_((double)this.posX), Mth.m_14107_((double)(this.cart.m_20186_() - (double)0.2f)), Mth.m_14107_((double)this.posZ));
            BlockState blockstate = this.cart.m_9236_().m_8055_(blockpos);
            if (!blockstate.addRunningEffects(this.cart.m_9236_(), blockpos, (Entity)this.cart) && blockstate.m_60799_() != RenderShape.INVISIBLE) {
                this.cart.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), this.posX, this.cart.m_20186_(), this.posZ, dx, (double)distanceTravelled, dz);
            }
        }
        this.rotationIncrement = travelledForward * distanceTravelled * this.circumference * 0.2f;
    }

    public void clearIncrement() {
        this.rotationIncrement = 0.0f;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getRotationIncrement() {
        return this.rotationIncrement;
    }
}

