/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.burrowers;

import com.ibm.icu.impl.Pair;
import com.jocosero.burrowers.block.ModBlocks;
import com.jocosero.burrowers.block.entity.ModBlockEntities;
import com.jocosero.burrowers.entity.ModEntities;
import com.jocosero.burrowers.entity.client.renderer.BurrowerRenderer;
import com.jocosero.burrowers.entity.client.renderer.ChiefBurrowerRenderer;
import com.jocosero.burrowers.entity.client.renderer.ModBoatRenderer;
import com.jocosero.burrowers.entity.client.renderer.SilverDwellerRenderer;
import com.jocosero.burrowers.entity.custom.BurrowerMerchantEntity;
import com.jocosero.burrowers.item.ModCreativeModeTab;
import com.jocosero.burrowers.item.ModItems;
import com.jocosero.burrowers.potion.ModPotions;
import com.jocosero.burrowers.sound.ModSounds;
import com.jocosero.burrowers.util.ModDecoratedPotPatterns;
import com.jocosero.burrowers.util.ModPotionBrewingRecipe;
import com.jocosero.burrowers.util.ModWoodTypes;
import com.jocosero.burrowers.util.trades.TradeManager;
import com.jocosero.burrowers.util.trades.type.BasicTrade;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="burrowers")
public class BurrowersMod {
    public static final String MOD_ID = "burrowers";
    private static final Logger LOGGER = LogUtils.getLogger();

    public BurrowersMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModCreativeModeTab.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModPotions.register(modEventBus);
        ModEntities.register(modEventBus);
        ModSounds.register(modEventBus);
        ModDecoratedPotPatterns.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.TOUGH_ROOT.get()), 0.65f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModBlocks.CAVE_FERN.get()), 0.65f);
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModPotionBrewingRecipe(Potions.f_43602_, (Item)ModItems.DWELLER_DUNG.get(), (Potion)ModPotions.HASTE_POTION.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModPotionBrewingRecipe(Potions.f_43602_, (Item)ModItems.RAW_SILVER_DWELLER.get(), (Potion)ModPotions.HASTE_POTION.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModPotionBrewingRecipe((Potion)ModPotions.HASTE_POTION.get(), Items.f_42451_, (Potion)ModPotions.LONG_HASTE_POTION.get()));
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.CAVE_FERN.getId(), ModBlocks.POTTED_CAVE_FERN);
            TradeManager manager = TradeManager.instance();
            manager.registerTrader((EntityType<? extends BurrowerMerchantEntity>)((EntityType)ModEntities.CHIEF_BURROWER.get()));
            manager.registerTypeSerializer(BasicTrade.SERIALIZER);
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Burrowers Mod loaded!");
    }

    @Mod.EventBusSubscriber(modid="burrowers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModDecoratedPotPatterns.registerDecoratedPotPattern(Pair.of((Object)((Item)ModItems.BLANK_POTTERY_SHERD.get()), ModDecoratedPotPatterns.BLANK), Pair.of((Object)((Item)ModItems.WAIL_POTTERY_SHERD.get()), ModDecoratedPotPatterns.WAIL), Pair.of((Object)((Item)ModItems.MEMORY_POTTERTY_SHERD.get()), ModDecoratedPotPatterns.MEMORY));
            Sheets.addWoodType((WoodType)ModWoodTypes.ROOTWOOD);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_BOAT.get()), pContext -> new ModBoatRenderer(pContext, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_CHEST_BOAT.get()), pContext -> new ModBoatRenderer(pContext, true));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SILVER_DWELLER.get()), SilverDwellerRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BURROWER.get()), BurrowerRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.CHIEF_BURROWER.get()), ChiefBurrowerRenderer::new);
        }
    }
}

