/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.burrowers.block;

import com.jocosero.burrowers.block.custom.ModFlammableRotatedPillarBlock;
import com.jocosero.burrowers.block.custom.ModHangingSignBlock;
import com.jocosero.burrowers.block.custom.ModStandingSignBlock;
import com.jocosero.burrowers.block.custom.ModWallHangingSignBlock;
import com.jocosero.burrowers.block.custom.ModWallSignBlock;
import com.jocosero.burrowers.block.custom.ToughRootsBlock;
import com.jocosero.burrowers.block.custom.ToughRootsPlantBlock;
import com.jocosero.burrowers.item.ModItems;
import com.jocosero.burrowers.util.ModWoodTypes;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"burrowers");
    public static final RegistryObject<Block> ROOTWOOD_BLOCK = ModBlocks.registerBlock("rootwood_block", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283861_)));
    public static final RegistryObject<Block> STRIPPED_ROOTWOOD_BLOCK = ModBlocks.registerBlock("stripped_rootwood_block", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283907_)));
    public static final RegistryObject<Block> ROOTWOOD_PLANKS = ModBlocks.registerBlock("rootwood_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283907_)));
    public static final RegistryObject<Block> ROOTWOOD_STAIRS = ModBlocks.registerBlock("rootwood_stairs", () -> new StairBlock(() -> ((Block)ROOTWOOD_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283907_)));
    public static final RegistryObject<Block> ROOTWOOD_SLAB = ModBlocks.registerBlock("rootwood_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283907_)));
    public static final RegistryObject<Block> ROOTWOOD_FENCE = ModBlocks.registerBlock("rootwood_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283907_)));
    public static final RegistryObject<Block> ROOTWOOD_FENCE_GATE = ModBlocks.registerBlock("rootwood_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_).m_60978_(2.0f).m_60918_(SoundType.f_56736_), SoundEvents.f_11873_, SoundEvents.f_11872_));
    public static final RegistryObject<Block> ROOTWOOD_PRESSURE_PLATE = ModBlocks.registerBlock("rootwood_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_).m_60918_(SoundType.f_56736_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> ROOTWOOD_BUTTON = ModBlocks.registerBlock("rootwood_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_).m_60918_(SoundType.f_56736_), BlockSetType.f_271198_, 10, true));
    public static final RegistryObject<Block> ROOTWOOD_DOOR = ModBlocks.registerBlock("rootwood_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_).m_60918_(SoundType.f_56736_).m_60955_(), BlockSetType.f_271198_));
    public static final RegistryObject<Block> ROOTWOOD_TRAPDOOR = ModBlocks.registerBlock("rootwood_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_).m_60918_(SoundType.f_56736_).m_60955_(), BlockSetType.f_271198_));
    public static final RegistryObject<Block> ROOTWOOD_SIGN = ModBlocks.registerBlock("rootwood_sign", () -> new ModStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_), ModWoodTypes.ROOTWOOD));
    public static final RegistryObject<Block> ROOTWOOD_WALL_SIGN = ModBlocks.registerBlock("rootwood_wall_sign", () -> new ModWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50158_), ModWoodTypes.ROOTWOOD));
    public static final RegistryObject<Block> ROOTWOOD_HANGING_SIGN = ModBlocks.registerBlock("rootwood_hanging_sign", () -> new ModHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244319_), ModWoodTypes.ROOTWOOD));
    public static final RegistryObject<Block> ROOTWOOD_WALL_HANGING_SIGN = ModBlocks.registerBlock("rootwood_wall_hanging_sign", () -> new ModWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244093_), ModWoodTypes.ROOTWOOD));
    public static final RegistryObject<Block> CAVE_FERN = ModBlocks.registerBlock("cave_fern", () -> new FlowerBlock(() -> MobEffects.f_19598_, 5, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50035_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> POTTED_CAVE_FERN = BLOCKS.register("potted_cave_fern", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, CAVE_FERN, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50231_).m_60955_()));
    public static final RegistryObject<Block> TOUGH_ROOTS = ModBlocks.registerBlock("tough_roots", () -> new ToughRootsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50702_).m_284180_(MapColor.f_283774_).m_60977_().m_60910_().m_60966_().m_60918_(SoundType.f_154673_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> TOUGH_ROOTS_PLANT = ModBlocks.registerBlock("tough_roots_plant", () -> new ToughRootsPlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50703_).m_284180_(MapColor.f_283774_).m_60910_().m_60966_().m_60918_(SoundType.f_154673_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> LICHEN_LANTERN = ModBlocks.registerBlock("lichen_lantern", () -> new LanternBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283769_).m_280606_().m_60999_().m_60978_(0.5f).m_60918_(SoundType.f_56744_).m_60953_(p_187433_ -> 8).m_60955_().m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> MURKY_GOLD_ORE = ModBlocks.registerBlock("murky_gold_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<Block> MURKY_DEEPSLATE_GOLD_ORE = ModBlocks.registerBlock("murky_deepslate_gold_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49995_).m_284180_(MapColor.f_283875_).m_60913_(2.5f, 3.0f).m_60918_(SoundType.f_154677_)));
    public static final RegistryObject<Block> MURKY_IRON_ORE = ModBlocks.registerBlock("murky_iron_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<Block> MURKY_DEEPSLATE_IRON_ORE = ModBlocks.registerBlock("murky_deepslate_iron_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_).m_284180_(MapColor.f_283875_).m_60913_(2.5f, 3.0f).m_60918_(SoundType.f_154677_)));
    public static final RegistryObject<Block> MURKY_COAL_ORE = ModBlocks.registerBlock("murky_coal_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 3.0f), (IntProvider)UniformInt.m_146622_((int)0, (int)2)));
    public static final RegistryObject<Block> MURKY_DEEPSLATE_COAL_ORE = ModBlocks.registerBlock("murky_deepslate_coal_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49997_).m_284180_(MapColor.f_283875_).m_60913_(2.5f, 3.0f).m_60918_(SoundType.f_154677_), (IntProvider)UniformInt.m_146622_((int)0, (int)2)));
    public static final RegistryObject<Block> MURKY_COPPER_ORE = ModBlocks.registerBlock("murky_copper_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)));
    public static final RegistryObject<Block> MURKY_DEEPSLATE_COPPER_ORE = ModBlocks.registerBlock("murky_deepslate_copper_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152505_).m_284180_(MapColor.f_283875_).m_60913_(2.5f, 3.0f).m_60918_(SoundType.f_154677_)));
    public static final RegistryObject<Block> MURKY_EMERALD_ORE = ModBlocks.registerBlock("murky_emerald_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 3.0f), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> MURKY_DEEPSLATE_EMERALD_ORE = ModBlocks.registerBlock("murky_deepslate_emerald_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50264_).m_284180_(MapColor.f_283875_).m_60913_(2.5f, 3.0f).m_60918_(SoundType.f_154677_), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> MURKY_REDSTONE_ORE = ModBlocks.registerBlock("murky_redstone_ore", () -> new RedStoneOreBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60977_().m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<Block> MURKY_DEEPSLATE_REDSTONE_ORE = ModBlocks.registerBlock("murky_deepslate_redstone_ore", () -> new RedStoneOreBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50173_).m_284180_(MapColor.f_283875_).m_60913_(2.5f, 3.0f).m_60918_(SoundType.f_154677_)));
    public static final RegistryObject<Block> MURKY_DIAMOND_ORE = ModBlocks.registerBlock("murky_diamond_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 3.0f), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> MURKY_DEEPSLATE_DIAMOND_ORE = ModBlocks.registerBlock("murky_deepslate_diamond_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_284180_(MapColor.f_283875_).m_60913_(2.5f, 3.0f).m_60918_(SoundType.f_154677_), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> MURKY_LAPIS_ORE = ModBlocks.registerBlock("murky_lapis_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 3.0f), (IntProvider)UniformInt.m_146622_((int)2, (int)5)));
    public static final RegistryObject<Block> MURKY_DEEPSLATE_LAPIS_ORE = ModBlocks.registerBlock("murky_deepslate_lapis_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50059_).m_284180_(MapColor.f_283875_).m_60913_(2.5f, 3.0f).m_60918_(SoundType.f_154677_), (IntProvider)UniformInt.m_146622_((int)2, (int)5)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

