/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.burrowers.entity.client.model;

import com.jocosero.burrowers.entity.animations.BurrowerAnimationDefinitions;
import com.jocosero.burrowers.entity.custom.BurrowerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class BurrowerModel<T extends Entity>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart burrower;
    private final ModelPart torso;
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public BurrowerModel(ModelPart root) {
        this.burrower = root.m_171324_("burrower");
        this.torso = this.burrower.m_171324_("torso");
        this.head = this.burrower.m_171324_("head");
        this.leftarm = this.burrower.m_171324_("leftarm");
        this.rightarm = this.burrower.m_171324_("rightarm");
        this.leftleg = this.burrower.m_171324_("leftleg");
        this.rightleg = this.burrower.m_171324_("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition burrower = partdefinition.m_171599_("burrower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition torso = burrower.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -3.0f, 8.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.5f, -11.0f, -3.5f, 9.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition head = burrower.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-4.0f, -9.0f, -6.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(-0.01f)).m_171514_(48, 38).m_171488_(-6.0f, -6.0f, -2.0f, 2.0f, 4.0f, 0.0f, new CubeDeformation(-0.01f)).m_171514_(48, 38).m_171480_().m_171488_(4.0f, -6.0f, -2.0f, 2.0f, 4.0f, 0.0f, new CubeDeformation(-0.01f)).m_171555_(false).m_171514_(64, 35).m_171488_(1.0f, -4.0f, -6.0f, -2.0f, 3.0f, -2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition mouth = head.m_171599_("mouth", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition mouth_r1 = mouth.m_171599_("mouth_r1", CubeListBuilder.m_171558_().m_171514_(45, 23).m_171488_(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = burrower.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(28, 20).m_171480_().m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightarm = burrower.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(28, 20).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftleg = burrower.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(32, 32).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)8.0f, (float)0.0f));
        PartDefinition rightleg = burrower.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(32, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_267799_(BurrowerAnimationDefinitions.BURROWER_WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.m_233385_(((BurrowerEntity)((Object)entity)).inspectAnimationState, BurrowerAnimationDefinitions.BURROWER_HOLD, ageInTicks, 1.0f);
        if (!((BurrowerEntity)((Object)entity)).inspectAnimationState.m_216984_()) {
            this.m_233385_(((BurrowerEntity)((Object)entity)).idleAnimationState, BurrowerAnimationDefinitions.BURROWER_IDLE, ageInTicks, 1.0f);
            this.head.f_104204_ = netHeadYaw / 57.295776f;
            this.head.f_104203_ = headPitch / 57.295776f;
            this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.4662f + (float)Math.PI)) * limbSwingAmount;
            this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.4662f)) * limbSwingAmount;
        }
        this.rightleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.7f)) * 0.6f * limbSwingAmount;
        this.leftleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.7f)) * -0.6f * limbSwingAmount;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.burrower.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.burrower;
    }

    public void m_6002_(HumanoidArm side, PoseStack matrixStack) {
        this.getArm(side).m_104299_(matrixStack);
    }

    private ModelPart getArm(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }
}

