/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.burrowers.entity.custom;

import com.jocosero.burrowers.entity.custom.BurrowerMerchantEntity;
import com.jocosero.burrowers.util.trades.CustomOffers;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractBurrowerEntity
extends BurrowerMerchantEntity
implements Npc {
    @Nullable
    private Player customer;
    private Set<UUID> tradedCustomers = new HashSet<UUID>();
    @Nullable
    private MerchantOffers offers;
    private int restockDelay;

    protected AbstractBurrowerEntity(EntityType<? extends BurrowerMerchantEntity> type, Level level) {
        super(type, level);
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_21203_();
        if (!this.m_9236_().m_5776_() && this.getMaxRestockDelay() != -1 && ++this.restockDelay >= this.getMaxRestockDelay()) {
            this.m_6616_().forEach(MerchantOffer::m_45372_);
            this.restockDelay = 0;
        }
    }

    @Nullable
    public Player m_7962_() {
        return this.customer;
    }

    public void m_7189_(@Nullable Player player) {
        this.customer = player;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new CustomOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected abstract void populateTradeData();

    protected void addTrades(MerchantOffers offers, @Nullable List<VillagerTrades.ItemListing> trades, int max, boolean shuffle) {
        if (trades == null) {
            return;
        }
        List randomIndexes = IntStream.range(0, trades.size()).boxed().collect(Collectors.toList());
        if (shuffle) {
            Collections.shuffle(randomIndexes);
        }
        randomIndexes = randomIndexes.subList(0, Math.min(trades.size(), max));
        for (Integer index : randomIndexes) {
            VillagerTrades.ItemListing trade = trades.get(index);
            MerchantOffer offer = trade.m_213663_((Entity)this, this.m_217043_());
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public void m_6255_(@Nullable MerchantOffers offers) {
    }

    public boolean isTrading() {
        return this.hasCustomer();
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
        if (this.customer != null) {
            this.tradedCustomers.add(this.customer.m_20148_());
        }
        if (this.m_9236_() instanceof ServerLevel) {
            ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20318_(1.0f), (int)offer.m_45379_());
        }
    }

    public void m_7713_(ItemStack stack) {
    }

    @Override
    public Level getLevel() {
        return this.m_9236_();
    }

    public boolean m_183595_() {
        return this.getLevel().f_46443_;
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xpIn) {
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == Items.f_42656_) {
            heldItem.m_41647_(player, (LivingEntity)this, hand);
            return InteractionResult.SUCCESS;
        }
        if (!(!this.m_6084_() || this.hasCustomer() || this.m_6162_() || !this.m_5825_() && this.m_6060_())) {
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (!(this.m_9236_().m_5776_() || this.m_21188_() != null && this.m_21188_() == player)) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    protected void m_21137_(ItemStack stack, int count) {
        if (!stack.m_41619_() && this.m_6117_()) {
            if (stack.m_41780_() == UseAnim.DRINK) {
                this.m_5496_(this.m_7838_(stack), 0.5f, this.m_9236_().m_213780_().m_188501_() * 0.1f + 0.9f);
            }
            if (stack.m_41780_() == UseAnim.EAT) {
                this.spawnFoodParticles(stack, count);
                this.m_5496_(this.m_7866_(stack), 0.5f + 0.5f * (float)this.m_217043_().m_188503_(2), (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f);
            }
        }
    }

    protected void spawnFoodParticles(ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 frontPosition = Vec3.m_82498_((float)0.0f, (float)this.f_20883_).m_82490_(0.25);
            frontPosition = frontPosition.m_82520_(0.0, 0.35, 0.0);
            frontPosition = frontPosition.m_82549_(this.m_20182_());
            Vec3 motion = new Vec3(this.m_217043_().m_188500_() * 0.2 - 0.1, 0.1, this.m_217043_().m_188500_() * 0.2 - 0.1);
            if (this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), frontPosition.f_82479_, frontPosition.f_82480_, frontPosition.f_82481_, 1, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_, 0.0);
                continue;
            }
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), frontPosition.f_82479_, frontPosition.f_82480_, frontPosition.f_82481_, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_);
        }
    }

    public boolean isPreviousCustomer(Player player) {
        return this.tradedCustomers.contains(player.m_20148_());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean attacked = super.m_6469_(source, amount);
        if (attacked && source.m_7639_() instanceof Player) {
            this.m_21573_().m_26573_();
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        }
        return attacked;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Offers", 10)) {
            this.offers = new CustomOffers(compound.m_128469_("Offers"));
        }
        if (compound.m_128425_("RestockDelay", 3)) {
            this.restockDelay = compound.m_128451_("RestockDelay");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        MerchantOffers offers = this.m_6616_();
        if (!offers.isEmpty()) {
            compound.m_128365_("Offers", (Tag)offers.m_45388_());
        }
        compound.m_128405_("RestockDelay", this.restockDelay);
    }

    protected abstract int getMaxRestockDelay();
}

