/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.burrowers.entity.custom;

import com.jocosero.burrowers.entity.ai.SeekFruitAndTradeItem;
import com.jocosero.burrowers.sound.ModSounds;
import com.jocosero.burrowers.util.ModBuiltInLootTables;
import com.jocosero.burrowers.util.ModTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class BurrowerEntity
extends PathfinderMob
implements InventoryCarrier {
    private static final int BURROWER_INVENTORY_SIZE = 8;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(BurrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState inspectAnimationState = new AnimationState();
    @Nullable
    private final SimpleContainer inventory = new SimpleContainer(8);
    private int idleAnimationTimeout = 0;
    private double lastTickPosX;
    private double lastTickPosY;
    private double lastTickPosZ;
    private int inspectionTicks = 0;

    public BurrowerEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21530_();
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)this.f_19796_.m_188503_(7));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    private static List<ItemStack> getExchangeItems(Entity pEntity) {
        LootTable loottable = pEntity.m_9236_().m_7654_().m_278653_().m_278676_(ModBuiltInLootTables.BURROWER_TRADE);
        ObjectArrayList list = loottable.m_287195_(new LootParams.Builder((ServerLevel)pEntity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)pEntity).m_287235_(LootContextParamSets.f_81417_));
        return list;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}));
        this.f_21345_.m_25352_(2, (Goal)new SeekFruitAndTradeItem(this, 1.2, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.85, Ingredient.m_204132_(ModTags.Items.FRUIT), false));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.2, 1.5));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void m_8119_() {
        this.lastTickPosX = this.m_20185_();
        this.lastTickPosY = this.m_20186_();
        this.lastTickPosZ = this.m_20189_();
        super.m_8119_();
        ItemStack mainHandItem = this.m_21205_();
        if (this.isValuableItem(mainHandItem)) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.1);
            ++this.inspectionTicks;
            if (this.inspectionTicks == 1) {
                this.inspectAnimationState.m_216977_(this.f_19797_);
            }
            if (this.inspectionTicks >= 120) {
                List<ItemStack> exchangeItems;
                if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_5448_() == null && !(exchangeItems = BurrowerEntity.getExchangeItems((Entity)this)).isEmpty()) {
                    ItemStack randomItem = exchangeItems.get(this.f_19796_.m_188503_(exchangeItems.size()));
                    this.m_5552_(randomItem, 1.0f);
                }
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                this.inspectionTicks = 0;
            }
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
            this.inspectionTicks = 0;
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING && this.isMoving() ? Math.min(pPartialTick + 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    private boolean isMoving() {
        double dz;
        double dy;
        double dx = this.m_20185_() - this.lastTickPosX;
        return dx * dx + (dy = this.m_20186_() - this.lastTickPosY) * dy + (dz = this.m_20189_() - this.lastTickPosZ) * dz > 0.001;
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        float f = pRandom.m_188501_();
        float f2 = this.m_9236_().m_46791_() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = pRandom.m_188503_(3);
            if (i == 0) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42384_));
            }
        }
    }

    public void processHeldItem() {
        if (this.isValuableItem(this.m_21205_())) {
            ItemStack itemInHand;
            ++this.inspectionTicks;
            if (this.inspectionTicks >= 120 && this.addItemToInventory(itemInHand = this.m_21205_())) {
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                this.inspectionTicks = 0;
            }
        }
    }

    private boolean isValuableItem(ItemStack item) {
        return item.m_204117_(ModTags.Items.FRUIT);
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public boolean addItemToInventory(ItemStack itemStack) {
        SimpleContainer inventory = this.m_35311_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            inventory.m_6836_(i, itemStack);
            return true;
        }
        return false;
    }

    public SlotAccess m_141942_(int pSlot) {
        int i = pSlot - 300;
        return i >= 0 && i < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)i) : super.m_141942_(pSlot);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (hurt && !this.m_9236_().f_46443_ && this.isValuableItem(this.m_21205_())) {
            this.inspectAnimationState.m_216973_();
            this.m_19998_((ItemLike)this.m_21205_().m_41720_());
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        return hurt;
    }

    public boolean m_21531_() {
        ItemEntity itemEntity = this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82377_(1.0, 0.0, 1.0)).stream().min(Comparator.comparingDouble(arg_0 -> ((BurrowerEntity)this).m_20280_(arg_0))).orElse(null);
        if (itemEntity != null) {
            return this.isValuableItem(itemEntity.m_32055_());
        }
        return false;
    }

    public boolean m_7243_(ItemStack pStack) {
        ItemEntity itemEntity = this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82377_(1.0, 0.0, 1.0)).stream().min(Comparator.comparingDouble(arg_0 -> ((BurrowerEntity)this).m_20280_(arg_0))).orElse(null);
        if (itemEntity != null) {
            return this.isValuableItem(itemEntity.m_32055_());
        }
        return false;
    }

    public void m_253224_(CompoundTag p_253699_) {
        super.m_253224_(p_253699_);
    }

    public void m_252802_(CompoundTag p_254428_) {
        super.m_252802_(p_254428_);
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public void m_6593_(@Nullable Component name) {
        String customName;
        super.m_6593_(name);
        if (name != null && ("Fresqui".equals(customName = name.getString()) || "Frieza".equals(customName) || "Freezer".equals(customName))) {
            this.setVariant(7);
        }
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)variant);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.BURROWER_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.BURROWER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.BURROWER_DEATH.get();
    }
}

