/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.burrowers.entity.custom;

import com.jocosero.burrowers.entity.ModEntities;
import com.jocosero.burrowers.entity.ai.LookAtTradingPlayer;
import com.jocosero.burrowers.entity.ai.TradingAwareRandomLookAroundGoal;
import com.jocosero.burrowers.entity.ai.TradingAwareRandomStrollGoal;
import com.jocosero.burrowers.entity.ai.TradingAwareTemptGoal;
import com.jocosero.burrowers.entity.custom.AbstractBurrowerEntity;
import com.jocosero.burrowers.entity.custom.BurrowerMerchantEntity;
import com.jocosero.burrowers.sound.ModSounds;
import com.jocosero.burrowers.util.ModTags;
import com.jocosero.burrowers.util.trades.EntityTrades;
import com.jocosero.burrowers.util.trades.TradeManager;
import com.jocosero.burrowers.util.trades.TradeRarity;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiefBurrowerEntity
extends AbstractBurrowerEntity {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState tradingAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private double lastTickPosX;
    private double lastTickPosY;
    private double lastTickPosZ;

    public ChiefBurrowerEntity(EntityType<? extends AbstractBurrowerEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends BurrowerMerchantEntity>)pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22282_, 1.2).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    protected int getMaxRestockDelay() {
        return 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}));
        this.f_21345_.m_25352_(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(3, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(4, (Goal)new OpenDoorGoal((Mob)this, false));
        this.f_21345_.m_25352_(5, (Goal)new LookAtTradingPlayer(this));
        this.f_21345_.m_25352_(6, (Goal)new TradingAwareTemptGoal(this, 0.85, Ingredient.m_204132_(ModTags.Items.FRUIT), false));
        this.f_21345_.m_25352_(7, (Goal)new TradingAwareRandomLookAroundGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new TradingAwareRandomStrollGoal(this, 1.0));
    }

    public void m_8119_() {
        this.lastTickPosX = this.m_20185_();
        this.lastTickPosY = this.m_20186_();
        this.lastTickPosZ = this.m_20189_();
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else if (this.isTrading()) {
            this.idleAnimationState.m_216973_();
            this.tradingAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
            this.tradingAnimationState.m_216973_();
        }
    }

    private boolean isMoving() {
        double dz;
        double dy;
        double dx = this.m_20185_() - this.lastTickPosX;
        return dx * dx + (dy = this.m_20186_() - this.lastTickPosY) * dy + (dz = this.m_20189_() - this.lastTickPosZ) * dz > 0.001;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (hurt && !this.m_9236_().f_46443_) {
            this.tradingAnimationState.m_216973_();
            this.m_19998_((ItemLike)this.m_21205_().m_41720_());
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        return hurt;
    }

    public boolean m_6573_(@NotNull Player pPlayer) {
        return false;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.BURROWER_AMBIENT.get();
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.BURROWER_HURT.get();
    }

    @javax.annotation.Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.BURROWER_DEATH.get();
    }

    @Override
    protected void populateTradeData() {
        MerchantOffers offers = this.m_6616_();
        EntityTrades entityTrades = TradeManager.instance().getTrades((EntityType<? extends BurrowerMerchantEntity>)((EntityType)ModEntities.CHIEF_BURROWER.get()));
        if (entityTrades != null) {
            Map<TradeRarity, List<VillagerTrades.ItemListing>> tradeMap = entityTrades.getTradeMap();
            List<VillagerTrades.ItemListing> trades = tradeMap.get((Object)TradeRarity.COMMON);
            int min = 8;
            int max = 12;
            int count = min + this.m_217043_().m_188503_(max - min + 1);
            this.addTrades(offers, trades, count, TradeRarity.COMMON.shouldShuffle());
        }
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }
}

