/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.burrowers.entity.custom;

import com.jocosero.burrowers.entity.ModEntities;
import com.jocosero.burrowers.entity.ai.SeekOutAndConsumeItem;
import com.jocosero.burrowers.sound.ModSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SilverDwellerEntity
extends Animal {
    private static final EntityDataAccessor<Boolean> HURT = SynchedEntityData.m_135353_(SilverDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TARGETING = SynchedEntityData.m_135353_(SilverDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(SilverDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState hurtAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private double lastTickPosX;
    private double lastTickPosY;
    private double lastTickPosZ;

    public SilverDwellerEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        if (this.m_6162_()) {
            this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Silverfish.class, 10.0f, 1.5, 2.0));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.1);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(4.0);
        } else {
            this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
            this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
            this.f_21345_.m_25352_(1, (Goal)new FleeSunGoal((PathfinderMob)this, 1.5));
            this.f_21345_.m_25352_(2, (Goal)new SeekOutAndConsumeItem((PathfinderMob)this, Arrays.asList(Items.f_41905_, Items.f_41856_, Items.f_42252_, Items.f_42051_, Items.f_42157_), 1.2, 10.0f){

                @Override
                public void m_8056_() {
                    SilverDwellerEntity.this.setTargeting(true);
                    super.m_8056_();
                }

                @Override
                public void m_8041_() {
                    SilverDwellerEntity.this.setTargeting(false);
                    super.m_8041_();
                }

                public void m_8037_() {
                    List list = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82400_(1.0), itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_() && this.targetItems.contains(itemEntity.m_32055_().m_41720_()));
                    if (!list.isEmpty()) {
                        ItemEntity itemEntity2 = (ItemEntity)list.get(0);
                        double distance = this.mob.m_20270_((Entity)itemEntity2);
                        if (distance < 1.0) {
                            this.m_8041_();
                        } else {
                            this.mob.m_21573_().m_26519_(itemEntity2.m_20185_(), itemEntity2.m_20186_(), itemEntity2.m_20189_(), this.speedModifier);
                        }
                    }
                }
            });
            this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

                public boolean m_8036_() {
                    boolean canStart = super.m_8036_();
                    if (canStart) {
                        SilverDwellerEntity.this.setTargeting(true);
                    }
                    return canStart;
                }

                public void m_8041_() {
                    super.m_8041_();
                    SilverDwellerEntity.this.setTargeting(false);
                }
            });
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal<Silverfish>((Mob)this, Silverfish.class, true){

                public boolean m_8036_() {
                    boolean canStart = super.m_8036_();
                    if (canStart && !SilverDwellerEntity.this.m_27593_()) {
                        SilverDwellerEntity.this.setTargeting(true);
                        return true;
                    }
                    return false;
                }
            });
            this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 0.7));
            this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42583_}), false));
            this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.25);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(14.0);
        }
    }

    public void m_8119_() {
        this.lastTickPosX = this.m_20185_();
        this.lastTickPosY = this.m_20186_();
        this.lastTickPosZ = this.m_20189_();
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING && this.isMoving() ? Math.min(pPartialTick + 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    private boolean isMoving() {
        double dz;
        double dy;
        double dx = this.m_20185_() - this.lastTickPosX;
        return dx * dx + (dy = this.m_20186_() - this.lastTickPosY) * dy + (dz = this.m_20189_() - this.lastTickPosZ) * dz > 0.001;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setTargeting(tag.m_128471_("isTargeting"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isTargeting", this.isTargeting());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGETING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(HURT, (Object)false);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.hurtAnimationState.m_216977_(this.f_19797_);
        return super.m_6469_(pSource, pAmount);
    }

    public boolean isTargeting() {
        return (Boolean)this.f_19804_.m_135370_(TARGETING);
    }

    public void setTargeting(boolean targeting) {
        this.f_19804_.m_135381_(TARGETING, (Object)targeting);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)ModEntities.SILVER_DWELLER.get()).m_20615_((Level)pLevel);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.15f;
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_150930_(Items.f_42583_);
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, pEntity);
            if (pEntity instanceof Silverfish && ((Silverfish)pEntity).m_21224_() && !this.m_27593_()) {
                this.m_27595_(null);
            }
        }
        return flag;
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SILVER_DWELLER_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SILVER_DWELLER_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.SILVER_DWELLER_HURT.get();
    }
}

