/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.burrowers.item.custom;

import com.jocosero.burrowers.block.ModBlocks;
import com.jocosero.burrowers.util.ModTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class DwellerDungItem
extends Item {
    private final Map<Block, Block> murkyVariants = new HashMap<Block, Block>();

    public DwellerDungItem(Item.Properties pProperties) {
        super(pProperties);
        this.murkyVariants.put(Blocks.f_49997_, (Block)ModBlocks.MURKY_COAL_ORE.get());
        this.murkyVariants.put(Blocks.f_152469_, (Block)ModBlocks.MURKY_DEEPSLATE_COAL_ORE.get());
        this.murkyVariants.put(Blocks.f_49996_, (Block)ModBlocks.MURKY_IRON_ORE.get());
        this.murkyVariants.put(Blocks.f_152468_, (Block)ModBlocks.MURKY_DEEPSLATE_IRON_ORE.get());
        this.murkyVariants.put(Blocks.f_152505_, (Block)ModBlocks.MURKY_COPPER_ORE.get());
        this.murkyVariants.put(Blocks.f_152506_, (Block)ModBlocks.MURKY_DEEPSLATE_COPPER_ORE.get());
        this.murkyVariants.put(Blocks.f_49995_, (Block)ModBlocks.MURKY_GOLD_ORE.get());
        this.murkyVariants.put(Blocks.f_152467_, (Block)ModBlocks.MURKY_DEEPSLATE_GOLD_ORE.get());
        this.murkyVariants.put(Blocks.f_50173_, (Block)ModBlocks.MURKY_REDSTONE_ORE.get());
        this.murkyVariants.put(Blocks.f_152473_, (Block)ModBlocks.MURKY_DEEPSLATE_REDSTONE_ORE.get());
        this.murkyVariants.put(Blocks.f_50264_, (Block)ModBlocks.MURKY_EMERALD_ORE.get());
        this.murkyVariants.put(Blocks.f_152479_, (Block)ModBlocks.MURKY_DEEPSLATE_EMERALD_ORE.get());
        this.murkyVariants.put(Blocks.f_50059_, (Block)ModBlocks.MURKY_LAPIS_ORE.get());
        this.murkyVariants.put(Blocks.f_152472_, (Block)ModBlocks.MURKY_DEEPSLATE_LAPIS_ORE.get());
        this.murkyVariants.put(Blocks.f_50089_, (Block)ModBlocks.MURKY_DIAMOND_ORE.get());
        this.murkyVariants.put(Blocks.f_152474_, (Block)ModBlocks.MURKY_DEEPSLATE_DIAMOND_ORE.get());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Block clickedBlock = world.m_8055_(pos).m_60734_();
        ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.values()));
        Collections.shuffle(directions);
        directions.sort(Comparator.comparingInt(direction -> direction == Direction.UP || direction == Direction.DOWN ? 1 : 0));
        Block targetBlock = null;
        if (clickedBlock.m_49966_().m_204336_(ModTags.Blocks.STONE_ORES)) {
            targetBlock = Blocks.f_50069_;
        } else if (clickedBlock.m_49966_().m_204336_(ModTags.Blocks.DEEPSLATE_ORES)) {
            targetBlock = Blocks.f_152550_;
        }
        if (targetBlock != null) {
            for (Direction direction2 : directions) {
                Block murkyVariant;
                BlockPos neighborPos = pos.m_121945_(direction2);
                Block neighborBlock = world.m_8055_(neighborPos).m_60734_();
                if (neighborBlock != targetBlock || (murkyVariant = this.murkyVariants.get(clickedBlock)) == null) continue;
                world.m_46597_(neighborPos, murkyVariant.m_49966_());
                if (!player.m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
                this.addGrowthParticles(world, pos, 1);
                world.m_245747_(pos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (new Random().nextInt(2) == 0) {
                    world.m_245747_(pos, SoundEvents.f_12193_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    world.m_46597_(pos, murkyVariant.m_49966_());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void addGrowthParticles(Level world, BlockPos pos, int count) {
        if (world.f_46443_) {
            for (int i = 0; i < count; ++i) {
                world.m_46796_(1505, pos, 0);
            }
        }
    }
}

