/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.burrowers.util;

import com.google.common.collect.Maps;
import com.ibm.icu.impl.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModDecoratedPotPatterns {
    public static final DeferredRegister<String> DECORATED_POT_PATTERNS = DeferredRegister.create((ResourceKey)Registries.f_271200_, (String)"burrowers");
    public static final RegistryObject<String> BLANK = ModDecoratedPotPatterns.register("blank_pottery_pattern");
    public static final RegistryObject<String> WAIL = ModDecoratedPotPatterns.register("wail_pottery_pattern");
    public static final RegistryObject<String> MEMORY = ModDecoratedPotPatterns.register("memory_pottery_pattern");

    public static RegistryObject<String> register(String name) {
        return DECORATED_POT_PATTERNS.register(name, () -> name);
    }

    public static void register(IEventBus eventBus) {
        DECORATED_POT_PATTERNS.register(eventBus);
    }

    @SafeVarargs
    public static void registerDecoratedPotPattern(Pair<Item, RegistryObject<String>> ... entries) {
        HashMap itemToPotTextureMap = Maps.newHashMap((Map)DecoratedPotPatterns.f_271367_);
        for (Pair<Item, RegistryObject<String>> entry : entries) {
            itemToPotTextureMap.put((Item)entry.first, ((RegistryObject)entry.second).getKey());
        }
        DecoratedPotPatterns.f_271367_ = itemToPotTextureMap;
    }
}

