/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SilkCocoonBlock
extends Block {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape HANGING_SHAPE = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public SilkCocoonBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState state;
            if (direction.m_122434_() != Direction.Axis.Y || !(state = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? HANGING_SHAPE : SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HANGING, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = SilkCocoonBlock.getConnectedDirection(state).m_122424_();
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    protected static Direction getConnectedDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return SilkCocoonBlock.getConnectedDirection(state).m_122424_() == direction && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

